/** 
* @file  Platform/Aperios1.3.2/IPEndpoint.h
*
* @author <A href=mailto:robocup@m-wachter.de>Michael Wachter</A>
*/

#ifndef	_IPEndpoint_H_
#define	_IPEndpoint_H_

/**
* static class for system calls
* @attention the implementation is system specific!
*/

#include <ant.h>
#include <EndpointTypes.h>
#include <IPAddress.h>
#include "ProcessFramework.h"

class IPEndpoint
{
   
   public:
     IPEndpoint(int sbs = 16384, int rbs = 16384);
     ~IPEndpoint();
     virtual void listenCont(antEnvMsg* msg) {};
     virtual void sendCont(antEnvMsg* msg) {};
     virtual void receiveCont(antEnvMsg* msg) {};
     virtual void closeCont(antEnvMsg* msg) {};
     virtual void connectCont(antEnvMsg* msg){};
     
 
   protected:
     antModuleRef endpoint;        /*< ANT Library Endpoint */

     antSharedBuffer sendBuffer;   /*< ANT buffer for sending */
     byte*           sharedSendBuffer;     /*< Pointer to the data */
     int             sharedSendBufferSize;
     int             sharedReceiveBufferSize;

     
     antSharedBuffer receiveBuffer;/*< ANT buffer for receiving */
     byte*           sharedReceiveBuffer;  /*< Data received */

     /* Pointers to the entry-point selectors in the process-framework 
      * Need to be pointers because an IPEndpoint can be created before
      * the entry-points are created
      */

     int* listenContSelector;
     int* sendContSelector;
     int* receiveContSelector;
     int* closeContSelector;
     int* connectContSelector;
     
     /*
      * Stack-Ref
      */

     antStackRef ipStackRef;
     OID* myOID_;

 
   
     
};

Out& operator<<(Out& stream, const IPAddress& ipAddress);

#endif // _IPEndpoint_H_

/*
 * Change log :
 * 
 * $Log: IPEndpoint.h,v $
 * Revision 1.7  2004/01/26 13:44:07  wachter
 * shared-memory-buffers now have variable sizes
 *
 * Revision 1.6  2004/01/09 13:57:23  wachter
 * Addes streaming-operator for Open-R IPAddress
 *
 * Revision 1.5  2004/01/03 16:18:24  wachter
 * debug-communication mostly working now
 *
 * Revision 1.4  2003/12/21 19:27:02  wachter
 * Added classes for Sender/Receiver over TCP and UDP.
 * ( PLEASE DO NOT USE THIS NOW ! )
 *
 * Revision 1.3  2003/12/03 14:21:52  wachter
 * Splitted IPEndpoint.*
 *
 * Revision 1.2  2003/12/02 20:52:41  wachter
 * Added IP-networking to aperios process-framework.
 *
 * Revision 1.1  2003/11/29 23:01:06  wachter
 * idea of an ip-implementation in the process-framework
 *
 */
