/**
* @file Platform/Aperios1.3.2/File.cpp
* 
* Implementation of class File for Aperios 1.3.2.
*/

#include "Platform/File.h"

#include <stdarg.h>
#include <string.h>
#include "Platform/GTAssert.h"
#include "Tools/Debugging/Debugging.h"

File::File(const char* name,const char* mode)
{
  ASSERT(name);
  char buf[FILENAME_MAX];
  if(name[0] != '/' && name[0] != '\\' && (name[0] == 0 || name[1] != ':'))
  {
    sprintf(buf,"%s/CONF/",getGTDir());
  }
  else
    buf[0] = 0;
  ASSERT(strlen(buf) + strlen(name) < FILENAME_MAX);
  strcat(buf,name);
  stream = OFS::fopen(buf,mode);
  isWrite = (mode[0] == 'w')||(mode[0] == 'a');
  bufSize = 0;
  index = 0;
}

File::~File() 
{
  if(stream != 0)
  {
    if(isWrite)
      VERIFY(OFS::fwrite(buf,1,index,stream) == index);
    OFS::fclose(stream);
  }
}

void File::read(void* p,unsigned size) 
{
  ASSERT(!isWrite);
  if(!bufSize)
    bufSize = OFS::fread(buf, 1, sizeof(buf), stream);
  while(sizeof(buf) - index - 1 < size)
  {
    memcpy(p, buf + index, sizeof(buf) - index - 1);
    (char*&) p += sizeof(buf) - index - 1;
    size -= sizeof(buf) - index - 1;
    buf[0] = buf[sizeof(buf) - 1];
    bufSize = OFS::fread(buf + 1, 1, sizeof(buf) - 1, stream) + 1;
    index = 0;
  }
  memcpy(p, buf + index, size);
  index += size;
}

void File::write(const void *p,unsigned size) 
{
  while(sizeof(buf) - index < size)
  {
    memcpy(buf + index,p,sizeof(buf) - index);
    (char*&) p += sizeof(buf) - index;
    size -= sizeof(buf) - index;
    VERIFY(OFS::fwrite(buf,1,sizeof(buf),stream) == sizeof(buf));
    index = 0;
  }
  memcpy(buf + index,p,size);
  index += size;
}

void File::printf(const char* format, ...)
{
  ASSERT(!index); // sorry, text streams are unbuffered
  va_list args;
  va_start(args,format);
  OFS::vfprintf(stream,format,args);
  va_end(args); 
}

bool File::eof() const 
{
#ifdef __GNUC__
  return ((feof(stream) != 0) && (index >= bufSize));
#else
  return ((OFS::feof(stream) != 0) && (index >= bufSize));
#endif    
}

char* File::getGTDir()
{
	return "/MS/open-r/APP";
}

/*
* Change log :
* 
* $Log: File.cpp,v $
* Revision 1.5  2004/03/11 17:17:38  roefer
* 64k bug fix fixed
*
* Revision 1.4  2004/03/10 08:14:59  roefer
* 64k bug fixed
*
* Revision 1.3  2004/01/22 12:42:25  dueffert
* flush removed because it doesnt work properly on robots
*
* Revision 1.2  2004/01/16 15:46:27  dueffert
* flush added to File and OutFile
*
* Revision 1.1  2003/10/07 10:06:59  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.2  2002/11/18 17:32:35  dueffert
* RobotControl should be startable in any path now
*
* Revision 1.1  2002/09/10 15:40:04  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.1  2002/07/23 13:38:22  loetzsch
* moved Implementation of File into an own C++ file
*
*/
