/** 
* @file  Platform/Aperios1.3.2/DDPHandler.cpp
*
* Handles the Dog Discovery Protocol (DDP) so that the robot
* is able to find out the ip's of his teammates.
*
* @author <A href=mailto:robocup@m-wachter.de>Michael Wachter</A>
* 
*/

#include "DDPHandler.h"

#include <stdio.h>
#include <iostream.h>

#include <tools/debugging/debugging.h>
#include "NetConfig.h"

DDPHandler::DDPHandler() :
UDPEndpoint(2048,2048)
{
	for(int i=0; i< Player::numOfPlayerNumbers - 1; i++)
    {
        list[i].ip   = IP_ADDR_ANY;
        list[i].port = 0;
        list[i].timeLastSeen = 0;
    }
    timeLastPackage = 0;
}


void DDPHandler::updateDDPList()
{
       
}

void DDPHandler::initDDPHandler()
{
    bind(DDPPORT); 
}

IPAddress DDPHandler::getIPAddress(int number)
{ 
    // Schaue nach alter der IP-Addresse auf position number
    // Zu alt (>10s) : liefere 0.0.0.0 zurck
    // sonst liefere die IP zurck
  return(IP_ADDR_ANY);
}

void DDPHandler::onReceive(void* data, int size)
{
    ASSERT(size = sizeof(DDPPackage));
    
    DDPPackage* package = static_cast<DDPPackage*>(data);
 
    INFO(sendDDPInfo,idText,text,"Incoming DDP package from " << ipOfLastPackage << 
          " " << package->teamIdentifier << " " << package->teamColor <<
          " " << package->playerNumber );

    // Is the package from the same team and color ?
    if ( (strcmp(package->teamIdentifier,getPlayer().getTeamName()) == 0)  &&
         (package->teamColor == getPlayer().getTeamColor()) &&
         !ipOfLastPackage.InLoop())
    {
       // cout << "Incoming DDP package is from own team \n" << flush;
       int fieldNumberToUpdate = -1;
      /* int i;
      
       // Try to reuse old place 
       for (i=0; i< Player::numOfPlayerNumbers - 1; i++)
       {
          if (list[i].ip == ipOfLastPackage)
          {
              fieldNumberToUpdate = i;
          }
       }

       // Never seen this ip-address before - find oldest entry
       if(fieldNumberToUpdate == -1)
       {
          unsigned long oldestEntryTime = 999999999;
          for (i=0; i < Player::numOfPlayerNumbers - 1; i++)
          {
            if (list[i].timeLastSeen < oldestEntryTime)
            {
              oldestEntryTime = list[i].timeLastSeen;
              fieldNumberToUpdate = i;
            }
          }
       }  */

       int ownPlayerNumber = (int)getPlayer().getPlayerNumber();
	   if (package->playerNumber < ownPlayerNumber)
	   {
		   fieldNumberToUpdate = package->playerNumber;
	   }
	   else
	   {
		   fieldNumberToUpdate = package->playerNumber-1;
	   }

	   cout << "package:" << package->playerNumber << " own:" << ownPlayerNumber << " update: " << fieldNumberToUpdate << " \n";

       // Update the field
       list[fieldNumberToUpdate].ip   = ipOfLastPackage;
       list[fieldNumberToUpdate].port = 0xA1BC;
       list[fieldNumberToUpdate].timeLastSeen = SystemCall::getCurrentSystemTime();

       INFO(sendDDPInfo,idText,text,"Known Dogs: " 
         << list[0].ip << "(" << SystemCall::getTimeSince(list[0].timeLastSeen) << "), " 
         << list[1].ip << "(" << SystemCall::getTimeSince(list[1].timeLastSeen) << "), " 
         << list[2].ip << "(" << SystemCall::getTimeSince(list[2].timeLastSeen) << ")" 
/*#ifdef FIVEDOGS
		 << "," << list[3].ip << "(" << SystemCall::getTimeSince(list[3].timeLastSeen) << ")"
#endif	 */
		 );
       
    /*    cout << "Known Dogs: " 
         << list[0].ip << "(" << SystemCall::getTimeSince(list[0].timeLastSeen) << "), " 
         << list[1].ip << "(" << SystemCall::getTimeSince(list[1].timeLastSeen) << "), " 
         << list[2].ip << "(" << SystemCall::getTimeSince(list[2].timeLastSeen) << "), " 
		 << list[3].ip << "(" << SystemCall::getTimeSince(list[3].timeLastSeen) << ")"; */
    }
}

void DDPHandler::sendDDPPackage()
{
  if (SystemCall::getTimeSince(timeLastPackage) > 5000)
  {
    // Prepare package
    strcpy(thePackage.teamIdentifier, getPlayer().getTeamName());
    thePackage.teamColor = getPlayer().getTeamColor();
    thePackage.playerNumber = getPlayer().getPlayerNumber();
    send(&thePackage,sizeof(thePackage),IP_ADDR_BROADCAST,DDPPORT);
    timeLastPackage = SystemCall::getCurrentSystemTime();
  }
}



/*
 * Change log :
 * 
 * $Log: DDPHandler.cpp,v $
 * Revision 1.6  2004/05/14 15:03:47  wachter
 * - really using network-configuration now
 *
 * Revision 1.5  2004/05/14 14:12:08  wachter
 * - Added communication support for 5 robots
 * - rewrote parts of team-communication to be faster and more stable
 *
 * Revision 1.4  2004/01/26 13:44:07  wachter
 * shared-memory-buffers now have variable sizes
 *
 * Revision 1.3  2004/01/21 17:33:08  wachter
 * UDP Team-communication now working with packets<1400 bytes.
 * Not activated at the moment.
 *
 * Revision 1.2  2004/01/09 15:44:30  wachter
 * Worked on with the Dog-Discovery-Protocol
 *
 * Revision 1.1  2003/12/21 19:27:02  wachter
 * Added classes for Sender/Receiver over TCP and UDP.
 * ( PLEASE DO NOT USE THIS NOW ! )
 *
 * 
 */

