/** 
* @file  Platform/Aperios1.2.1/SystemCall.cpp
*
* Static class for system calls, aperios implementation.
* @attention this is the Aperios implementation
*
* @author <A href=mailto:brunn@sim.informatik.tu-darmstadt.de>Ronnie Brunn</A>
* @author <A href=mailto:risler@sim.informatik.tu-darmstadt.de>Max Risler</A>
*/

#include <MCOOP.h>
#include <OPENR/OPower.h>
#include <OPENR/OPENR.h>
#include "SystemCall.h"
#include "../Aperios1.3.2/GTAssert.h"

unsigned long SystemCall::getCurrentSystemTime() {
  SystemTime sysTime;
  GetSystemTime(&sysTime);
  return (sysTime.seconds * 1000 + sysTime.useconds / 1000);
}

unsigned long SystemCall::getFreeMem()
{
	//2do: what about MAV_System::GetFreeMemorySize();
	return 42;
}

unsigned char SystemCall::getRemainingPower()
{
  //2do: what about OObservePowerStatusMessage
  return 42;
}

void SystemCall::reboot()
{
	//no way :-)
}

void SystemCall::shutdown()
{
	//no way :-)
}

void SystemCall::getMacAddress(unsigned char address[6])
{
  for(int i = 0; i < 6; ++i)
    address[i] = 0;
}

RobotDesign::Design SystemCall::getRobotDesign()
{
  //static bool initialized = false;
  static RobotDesign::Design design;

  //design = RobotDesign::ERS110;
  design = RobotDesign::ERS210;
  return design;
}

/*
 * Change log :
 * 
 * $Log$
 *
 */
