/**
 * @file Platform/Aperios1.2.1/SoundDataSender.cpp
 * This file contains the implementation of a sender for sound data.
 */

#include "ProcessFramework.h"

SoundDataSender::SoundDataSender(PlatformProcess* process,bool blocking)
: SenderBase<SoundData>(process,"Sender.OSoundVectorData.S",blocking)
{
  //package[0] = 0;

  OPrimitiveID soundId;
/*  
  VERIFY(OPENR::OpenPrimitive(SystemCall::getRobotDesign() == RobotDesign::ERS210 
                              ? "PRM:/r1/c1/c2/c3/s1-Speaker:S1"
                              : "PRM:/s1-Speaker:S1",&soundId) == oSUCCESS);
  OSpeakerSoundType type = ospksndMONO8K8B;
  VERIFY(OPENR::ControlPrimitive(soundId,oprmreqSPEAKER_SET_SOUND_TYPE,&type,sizeof(type),0,0) == oSUCCESS);
*/
  int vol = SystemCall::getRobotDesign() == RobotDesign::ERS210 ? 0xf400 : 0xf600;
//  VERIFY(OPENR::ControlPrimitive(soundId,oprmreqSPEAKER_SET_VOLUME,&vol,sizeof(vol),0,0) == oSUCCESS);

  for(int i = 0; i < 2; ++i)
  {
//    VERIFY(OPENR::NewSoundVectorData(1, 256, &memID[i], &soundVec[i]) == oSUCCESS);
    soundVec[i]->SetNumData(1);
    OSoundInfo* info = soundVec[i]->GetInfo(0);
//    info->Set(odataSOUND_VECTOR,soundId,info->maxDataSize);
  }
}

SoundDataSender::~SoundDataSender()
{
  for(int i = 0; i < 2; ++i)
;//    VERIFY(OPENR::DeleteSoundVectorData(memID[i]) == oSUCCESS);
}

void SoundDataSender::prepare(int i)
{
  const SoundData& soundData = *static_cast<const SoundData*>(this);
  OSoundInfo* info = soundVec[i]->GetInfo(0);
  info->dataSize = info->frameSize;
  info->samplingRate  = 8000;
  info->bitsPerSample = 8;
  memcpy(soundVec[i]->GetData(0),soundData.pcmBuffer,256);
}

void SoundDataSender::preparePackage()
{
//  if(!package[0])
  {
    for(int i = 0; i < 2; ++i)
    {
/*
      VERIFY(package[i] = new RCRegion(soundVec[i]->vectorInfo.memRegionID,
                                       soundVec[i]->vectorInfo.offset,
                                       (void*) soundVec[i],
                                       soundVec[i]->vectorInfo.totalSize));
*/
      prepare(i);
    }
    index = -1;
  }
//  else
    prepare(index);
}

void SoundDataSender::setPackage(const ObserverID& receiver)
{
  for(int l = 0; l < 2; l++)
  {
/*    if (package[l]->NumberOfReference() == 1)
    {
      VERIFY(SetData(receiver,package[l]) == oSUCCESS);
    }
*/
    
  }
  //2do: do it without package
  //SetData(soundVec[0]->GetDataVectorID(), 0);  
}

/** @todo packages are not freed */
void SoundDataSender::freePackage()
{
  if(index == -1)
    index = 0;
  else
    index = 1 - index;
}

/*
 * Change log :
 * 
 * $Log$
 *
 */
