/**
* @file Platform/Aperios1.2.1/File.cpp
* 
* Implementation of class File for Aperios 1.2.1.
*/

#include "Platform/File.h"

#include <stdarg.h>
#include <string.h>
#include "Platform/GTAssert.h"

File::File(const char* name,const char* mode)
{
  ASSERT(name);
  char buf[FILENAME_MAX];
  if(name[0] != '/' && name[0] != '\\' && (name[0] == 0 || name[1] != ':'))
  {
    sprintf(buf,"%s/CONF/",getGTDir());
  }
  else
    buf[0] = 0;
  ASSERT(strlen(buf) + strlen(name) < FILENAME_MAX);
  strcat(buf,name);
  mEof = false;
  mFileHandle = FATFS::fopen(buf,mode);
  isWrite = (mode[0] == 'w')||(mode[0] == 'a');
  bufSize = 0;
  index = 0;
}

File::~File() 
{
  if(mFileHandle > 0)
  {
    if(isWrite)
      VERIFY(FATFS::fwrite(buf,1,index,mFileHandle) == index);
    FATFS::fclose(mFileHandle);
    mFileHandle = NULL;
  }
}

void File::read(void* p,unsigned size) 
{
  ASSERT(!isWrite);
  while(bufSize - index < size)
  {
    memcpy(p,buf + index,bufSize - index);
    (char*&) p += bufSize - index;
    size -= bufSize - index;
    bufSize = FATFS::fread(buf,1,sizeof(buf),mFileHandle);
    if (bufSize<sizeof(buf))
      mEof = true;
    index = 0;
  }
  memcpy(p,buf + index,size);
  index += size;
}

void File::write(const void *p,unsigned size) 
{
  while(sizeof(buf) - index < size)
  {
    memcpy(buf + index,p,sizeof(buf) - index);
    (char*&) p += sizeof(buf) - index;
    size -= sizeof(buf) - index;
    VERIFY(FATFS::fwrite(buf,1,sizeof(buf),mFileHandle) == sizeof(buf));
    index = 0;
  }
  memcpy(buf + index,p,size);
  index += size;
}

void File::printf(const char* format, ...)
{
  ASSERT(!index); // sorry, text streams are unbuffered
  //2do: implement:
  //va_list args;
  //va_start(args,format);
  //OFS::vfprintf(stream,format,args);
  //va_end(args); 
}

bool File::eof() const 
{
  return ((mEof == true) && (index >= bufSize));
}

char* File::getGTDir()
{
	return "/MS/open-r/APP";
}

/*
* Change log :
* 
* $Log$
*
*/
