#ifndef MSH2004INVKINWALKINGENGINE_H
#define MSH2004INVKINWALKINGENGINE_H

#include "InvKinWalkingEngine.h"
#include "InvKinWalkingParameterSets.h"

/**
 * @author  Thomas Kindler <thomas.kindler@gmx.de>
 */
class MSH2004InvKinWalkingEngine 
  : public WalkingEngine
{
  protected:
    InvKinWalkingEngine       *pEngine;
    MSH2004WalkingParameters           forward;
    MSH2004BackwardsWalkingParameters  backward;

  public:
    MSH2004InvKinWalkingEngine(InvKinWalkingEngine *pEngine);
    virtual bool executeParameterized(
      JointData& jointData,
      const MotionRequest& motionRequest
    );
    virtual bool handleMessage(InMessage& message);
};

#endif

/*
* Change log :
* 
* $Log: MSH2004InvKinWalkingEngine.h,v $
* Revision 1.3  2004/04/08 15:33:07  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.6  2004/04/04 00:43:49  kindler
* - now really really does the fast backwards thing (this time without annoying bugs ;)
*
* Revision 1.5  2004/04/01 10:09:55  kindler
* - now really uses the faster backwars walk..
*
* Revision 1.4  2004/03/31 12:48:55  pg_thki
* - improved fast/conservative walking parameters heuristics.
* - gives some debugging outputs (specially for tim, will be removed again later..).
*
* Revision 1.3  2004/03/30 16:45:25  pg_thki
* - MSH2004WalkingEngine now uses different Parameters for forward and backward.
*
* Revision 1.2  2004/03/17 11:55:57  dueffert
* warning removed; changelog added
*
*/
