/**
* @file TeamBallLocatorSelector.h
* 
* Definition of class TeamBallLocatorSelector
*
* @author Martin Ltzsch
*/

#ifndef __TeamBallLocatorSelector_h_
#define __TeamBallLocatorSelector_h_

#include "Tools/Module/ModuleSelector.h"

#include "TeamBallLocator.h"
#include "DefaultTeamBallLocator.h"
#include "ATH2004TeamBallLocator.h"
#include "SensorFusionTeamBallLocator.h"

/**
* @class TeamBallLocatorSelector
* 
* A module selector for team ball locators.
*
* @author Martin Ltzsch
*/
class TeamBallLocatorSelector : public ModuleSelector, public TeamBallLocatorInterfaces
{
public:
/**
* Constructor.
* @param handler The module handler of the process.
* @param interfaces The paramters of the TeamBallLocator module.
  */
  TeamBallLocatorSelector(
    ModuleHandler &handler,
    const TeamBallLocatorInterfaces& interfaces)
    : ModuleSelector(SolutionRequest::teamBallLocator),
    TeamBallLocatorInterfaces(interfaces)
  {
    handler.setModuleSelector(SolutionRequest::teamBallLocator, this);
  }
  
  /** 
  * Is called on start and when the selected solution changes
  * to create a specific solution.
  * @param id The id of the solution to create
  * @return The created solution or 0
  */
  virtual Module* createSolution(SolutionRequest::ModuleSolutionID id)
  {
    switch(id)
    {
    case SolutionRequest::defaultTeamBallLocator:
      return new DefaultTeamBallLocator(*this);
    case SolutionRequest::ath2004TeamBallLocator:
      return new ATH2004TeamBallLocator(*this);
    case SolutionRequest::sensorFusionTeamBallLocator:
      return new SensorFusionTeamBallLocator(*this);
    default:
      return 0;
    }
  }
};

#endif //__TeamBallLocatorSelector_h_

/*
* Change log:
*
* $Log: TeamBallLocatorSelector.h,v $
* Revision 1.5  2004/04/05 17:56:47  loetzsch
* merged the local German Open CVS of the aibo team humboldt with the tamara CVS
*
* Revision 1.4  2004/03/08 02:11:54  roefer
* Interfaces should be const
*
* Revision 1.3  2004/01/23 23:02:25  wachter
* Reinserted the famous GaussBellTeamBallLocator from the
* as GT2003-code as SensorFusionTeamBallLocator.
*
* Revision 1.2  2004/01/21 14:31:58  loetzsch
* Module Selectors create only the selected solution.
* When the solution changes, the old solution is erased and the new
* one ist created using createSolution(..)
*
* Revision 1.1  2003/10/06 14:10:14  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2003/05/01 17:09:08  loetzsch
* Redesign of ball modeling:
* - Modularized class BallPosition
* - splitted up module "BallLocator" into "BallLocator" for modeling of percepts
*   and "TeamBallLocator" for modelling communicated positions
* - Removed solution JumpingBallLocator
* - Splitted Solution DefaultBallLocator into DefaultBallLocator and DefaultTeamBallLocator
* - Renamed SensorFusionBallLocator to GaussBellTeamBallLocator
*
*/
