/**
* @file SensorFusionTeamBallLocator.h
* 
* Definition of class SensorFusionTeamBallLocator
*
* @author <A href=mailto:sebastian.schmidt@udo.edu>Sebastian Schmidt</A>
* @author <A href=mailto:kai_engel@gmx.de>Kai Engel</A>
* @author <A href=mailto:andreasreiss@gmx.de>Andreas Rei</A>
* @author <A href=mailto:m_wachter@gmx.de>Michael Wachter</A>
*/


#ifndef __GaussBellTeamBallLocator_h_
#define __GaussBellTeamBallLocator_h_

#include "TeamBallLocator.h"

#include "Tools/RingBuffer.h"
#include "Tools/Math/Matrix2x2.h"

#include "Tools/Math/GaussBell.h"

                  
const int NUMBER_OF_PLAYERS = 4;                      /**< Number of players per team */

class SensorFusionTeamBallLocator : public TeamBallLocator
{
public:

  /** 
  * Constructor.
  * @param interfaces The paramters of the TeamBallLocator module.
  */
  SensorFusionTeamBallLocator(const TeamBallLocatorInterfaces& interfaces);
  
  /** Executes the module */
  virtual void execute();
  
  private:
    const Vector2<double> sigmatTable;
    RingBuffer<GaussBell,5> history;

};

#endif// __SensorFusionTeamBallLocator_h_


/*
* Change log :
* 
* $Log: SensorFusionTeamBallLocator.h,v $
* Revision 1.4  2004/05/06 12:33:33  nistico
* Improved: percepts are filtered out if older than 1 second, variance is dependent on age, variance scale extended, history entries' variance increases much faster
*
* Revision 1.3  2004/03/08 02:11:54  roefer
* Interfaces should be const
*
* Revision 1.2  2004/01/28 08:25:24  dueffert
* doxygen bugs fixed
*
* Revision 1.1  2004/01/23 23:02:25  wachter
* Reinserted the famous GaussBellTeamBallLocator from the
* as GT2003-code as SensorFusionTeamBallLocator.
*
* Revision 1.6  2003/05/19 15:34:42  wachter
* Added calculation of timeWhenLastObserved
* Moved genration of debug-drawing
*
* Revision 1.5  2003/05/18 19:31:26  wachter
* Rewrote GaussBellTeamBallLocator
* Renamed SensorFusionGaussBell to GaussBell as requested.
*
* Revision 1.4  2003/05/13 15:56:35  engel
* cosmetics
*
* Revision 1.3  2003/05/09 16:23:12  engel
* variables updated... (for cooperation with the other GermanTeam-members)
*
* Revision 1.2  2003/05/05 14:52:36  dueffert
* warnings removed
*
* Revision 1.1  2003/05/01 17:09:08  loetzsch
* Redesign of ball modeling:
* - Modularized class BallPosition
* - splitted up module "BallLocator" into "BallLocator" for modeling of percepts
*   and "TeamBallLocator" for modelling communicated positions
* - Removed solution JumpingBallLocator
* - Splitted Solution DefaultBallLocator into DefaultBallLocator and DefaultTeamBallLocator
* - Renamed SensorFusionBallLocator to GaussBellTeamBallLocator
*
* Revision 1.19  2003/04/25 11:32:40  engel
* Comments inserted
*
* Revision 1.18  2003/04/24 16:27:32  engel
* Debug-Drawings changed: Now after 1000 Locations all these will be drawn.
* => We will be compare the Default-Locator with the SFBL
* Will be continued...
*
* Revision 1.17  2003/04/22 15:03:39  engel
* inserted some for-loops to make the code shorter
*
* Revision 1.16  2003/04/19 03:33:27  pruente
* Merged in changes by Kai: - History changed: Now the last NUMBER_OF_TAKEN_HISTIORY_ENTRYS
*                             many entrys will be merged. ;-)
*
*                           - Set ballPosition.knownPosition = ballPosition.seenPosition, if the ball is nearer
*                             the robot than 50cm.
*
*                           - Set ballPosition.validity to 0.001, if no robot has seen the ball.
*
*                           - if the ball was seen in one of the penalty areas it will not be merged.
*                             Cause: If the robots shows at the yellow goal, he will percept a ball,
*                             even if there is no ball (because of red goalie in front of yellow goal).
*
* Revision 1.16  2003/04/11 10:20:55  Engel
* If the ball was seen in one of the penalty areas it will not be merged.
* Cause: If the robots shows at the yellow goal, he will percept a ball,
* even if there is no ball (because of red goalie in front of yellow goal).
*
* Revision 1.15  2003/04/09 16:56:15  engel
* DefaultBallLocator for seen-Position in SFBL included (but only for seen-position).
*
* Revision 1.14  2003/04/06 16:26:29  engel
* Cosmetics
*
* Revision 1.13  2003/04/06 15:57:52  engel
* Little changes (cosmetic and some improvements).
*
* Revision 1.12  2003/04/04 10:21:25  engel
* Catch invalid values of doubles (doubleIsValid())
*
* Revision 1.11  2003/04/01 15:17:43  engel
* 1) The merged ball is now allways ON the field!
* 2) Deleted some methods
* 3) Cosmetics
*
* Revision 1.10  2003/04/01 08:05:28  engel
* determineRobotsSeenBall(): If one robot has not seen the ball for "a long time" its percept wont be merged.
*
* Revision 1.9  2003/03/27 16:17:24  engel
* Invalid BallPercepepts will be destroyed or repaired...
*
* Revision 1.8  2003/03/26 15:36:00  engel
* Body for calculateValidityOfBall(...) inserted.
* Changes for test-text-files.
* Calculation of sigmas from Validity.
*
* Revision 1.7  2003/03/12 11:04:37  engel
* Begin: If one roboter does not see the ball, its percept wont be taken...
*
* Revision 1.6  2003/03/04 11:55:04  engel
* still working on...
*
* Revision 1.5  2003/02/28 16:29:26  engel
* still working on ;-))
*
* Revision 1.4  2003/02/28 14:29:09  engel
* still working on ;-)
*
* Revision 1.3  2003/02/27 13:30:40  engel
* execute-Method extended
*
* Revision 1.2  2003/02/21 12:19:32  engel
* add the method erf(double _x)
*
* Revision 1.1  2003/02/14 14:34:02  wachter
* Added GaussBellTeamBallLocator
*
*
*/
