/**
* @file MotionNetData.h
* 
* Definition of class MotionNetData
*
* @author Martin Ltzsch, Max Risler, Uwe Dffert
*/

#ifndef __MotionNetData_h_
#define __MotionNetData_h_


#include "MotionNetNode.h"
#include "Representations/Motion/MotionRequest.h"

/**
* MotionNetData encapsulates all the motion data in the motion net.
*
* @author Martin Ltzsch
* @author Uwe Dffert
* @author Max Risler
*
*/
class MotionNetData
{
  public:
    /** Default Constructor */
    MotionNetData();

    /** Deconstructor */
    ~MotionNetData();

    /** Loads the motion net from a file or another stream. */
    void load(In &stream);

		/** jump table from extern.mof: get start index from request */
    short label_extern_start[MotionRequest::numOfSpecialAction];

    /** The motion net */
    MotionNetNode* nodeArray;
};

#endif

/** 
* Change Log:
*
* $Log: MotionNetData.h,v $
* Revision 1.2  2003/12/16 19:01:18  loetzsch
* The motion net is not compiled into a C++ file but parsed at run time.
*
*/
