/**
* @file SoundControlSelector.h
*
* Definition of class SoundControlSelector
*
* @author <a href="mailto:Oliver.Giese@uni-dortmund.de">Oliver Giese</a>
* @author <a href="mailto:matthias.hebbel@uni-dortmund.de">Matthias Hebbel</a>
*/

#ifndef __SoundControlSelector_h_
#define __SoundControlSelector_h_

#include "Tools/Module/ModuleSelector.h"
#include "DefaultSoundControl.h"

/**
* @class SoundControlSelector
* 
* A module selector for sound control modules 
*
* @author <a href="mailto:Oliver.Giese@uni-dortmund.de">Oliver Giese</a>
* @author <a href="mailto:matthias.hebbel@uni-dortmund.de">Matthias Hebbel</a>
*/ 
class SoundControlSelector : public ModuleSelector, public SoundControlInterfaces
{
public:
/**
* Constructor.
* @param handler The module handler of the process.
* @param interfaces The paramters of the SoundControl module.
  */
  SoundControlSelector(ModuleHandler &handler,const SoundControlInterfaces& interfaces) 
    : ModuleSelector(SolutionRequest::soundControl),
    SoundControlInterfaces(interfaces)
  {
    handler.setModuleSelector(SolutionRequest::soundControl,this);
  }
  
  /** 
  * Is called on start and when the selected solution changes
  * to create a specific solution.
  * @param id The id of the solution to create
  * @return The created solution or 0
  */
  virtual Module* createSolution(SolutionRequest::ModuleSolutionID id)
  {
    switch(id)
    {
    case SolutionRequest::defaultSoundControl:
      return new DefaultSoundControl(*this);
    default:
      return 0;
    }
  }
  
};  

#endif //__SoundControlSelector_h_

/*
* Change log :
* 
* $Log: SoundControlSelector.h,v $
* Revision 1.3  2004/03/08 02:11:52  roefer
* Interfaces should be const
*
* Revision 1.2  2004/01/21 14:31:58  loetzsch
* Module Selectors create only the selected solution.
* When the solution changes, the old solution is erased and the new
* one ist created using createSolution(..)
*
* Revision 1.1  2003/10/06 14:10:14  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.5  2002/11/19 15:43:03  dueffert
* doxygen comments corrected
*
* Revision 1.4  2002/10/14 13:14:25  dueffert
* doxygen comments corrected
*
* Revision 1.3  2002/09/11 00:06:58  loetzsch
* continued change of module/solution mechanisms
*
* Revision 1.2  2002/09/10 21:07:30  loetzsch
* continued change of module/solution mechanisms
*
* Revision 1.1  2002/09/10 15:36:16  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.4  2002/05/27 15:39:04  fischer
* Added SoundState (Sender and Receiver)
*
* Revision 1.3  2002/05/15 07:28:18  hebbel
* Removed mute, uses Soundprotocol instead, plays wave for patternchallenge
*
* Revision 1.2  2002/05/14 18:52:58  hebbel
* Added variable mute
*
* Revision 1.1.1.1  2002/05/10 12:40:16  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.1  2002/04/28 19:14:12  giese
* SoundPlay added...
*
*
* 
*/
