/**
* @file LogFile.h
*
* Definition of class LogFile
*
* @author <a href="mailto:ordyniak@informatik.hu-berlin.de">Sebastian Ordyniak</a>
* @author <a href="mailto:richert@informatik.hu-berlin.de">Marten Richert</a>
*/

#ifndef __LogFile_h_
#define __LogFile_h_

#include "MovementData.h"

/**
* @class LogFile
*
* @author <a href="mailto:ordyniak@informatik.hu-berlin.de">Sebastian Ordyniak</a>
* @author <a href="mailto:richert@informatik.hu-berlin.de">Marten Richert</a>
*/ 

#define MOV_COUNT 415

class LogFile
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the LogFile module.
  */
  LogFile();
  int isLogFrame(int findx1, int fidx2);
  int fitsFirst(int fidx1);
  MovementData* getMovementData(int fidx1, int fidx2);

private:
	

	MovementData data[MOV_COUNT];
	int currIdx;
};
#endif// __LogFile_h_

/*
* Change log :
* 
* $Log: LogFile.h,v $
* Revision 1.1  2004/03/23 22:50:07  ordyniak
* no message
*
*/
