/**
* @file SensorActorLoop.h
* 
* Definition of class SensorActorLoop
*/

#ifndef __SensorActorLoop_h_
#define __SensorActorLoop_h_

#include "Tools/Module/Module.h"
#include "Tools/MessageQueue/InMessage.h"
#include "Tools/Actorics/RobotDimensions.h"
#include "Tools/RobotConfiguration.h"

#include "Representations/Perception/Image.h"
#include "Representations/Perception/SensorDataBuffer.h"
#include "Representations/Motion/JointDataBuffer.h"
#include "Representations/Motion/PIDData.h"
#include "Representations/Motion/LEDRequest.h"

/**
* @class SensorActorLoopInterfaces
*
* The interfaces of the module SensorActorLoop
*/
class SensorActorLoopInterfaces
{
public:
  /** Constructor */
  SensorActorLoopInterfaces(
    const Image& image,
    const SensorDataBuffer& sensorDataBuffer,
    PIDData& pidData,
    JointDataBuffer& jointDataBuffer,
    LEDRequest& ledRequest
    )
    : 
  image(image),
    sensorDataBuffer(sensorDataBuffer),
    pidData(pidData),
    jointDataBuffer(jointDataBuffer),
    ledRequest(ledRequest)
  {}
  
protected:
  /**  */
  const Image& image;
  
  /** The SensorDataBuffer */
  const SensorDataBuffer& sensorDataBuffer;
  
  /** The current PID servo gains */
  PIDData& pidData;
  
  /** A buffer of joint data to be filled */
  JointDataBuffer& jointDataBuffer;
  
  /** The led request */
  LEDRequest& ledRequest;
};

/**
*/
class SensorActorLoop : public Module, protected SensorActorLoopInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the SensorActorLoop module.
  */
  SensorActorLoop(SensorActorLoopInterfaces& interfaces)
    : SensorActorLoopInterfaces(interfaces)
  {}
  
  /** Destructor */
  virtual ~SensorActorLoop() {}
  
private:
  /** That function is not used but has to be implemented */
  virtual void execute() {};
};

#endif //__SensorActorLoop_h_

/*
* Change log :
* 
* $Log: SensorActorLoop.h,v $
* Revision 1.3  2004/01/13 15:59:38  loetzsch
* made compilable
*
* Revision 1.2  2003/10/29 19:12:55  juengel
* Added image to interfaces
*
* Revision 1.1  2003/10/29 13:02:51  juengel
* Added module SensorActorLoop.
*
*/
