/**
* @file NeuroControl.h
*
* Definition of class NeuroControl.
* 
* @author Manfred Hild
*/

#ifndef __NeuroControl_h_
#define __NeuroControl_h_

#include "SensorActorLoop.h"

/**
* @class NeuroControl
*
* @author Manfred Hild
*/
class NeuroControl : public SensorActorLoop, public RobotDimensions
{
public:
/** 
* Constructor 
* @param interfaces The paramters of the NeuroControl module.
  */
  NeuroControl(SensorActorLoopInterfaces& interfaces);
  
  /** Executes the module */
  virtual void execute();
  
  /** 
  * Called from a MessageQueue to distribute messages.
  * Use message.getMessageID to decide if the message is relavant for 
  * the MesssageHandler derivate.
  * Use message.bin, message.text or message.config as In streams to get the data from.
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);
  
protected:
  
};

#endif// __NeuroControl_h_

/*
* Change log :
* 
* $Log: NeuroControl.h,v $
* Revision 1.2  2004/01/13 15:59:38  loetzsch
* made compilable
*
* Revision 1.1  2003/10/29 13:02:51  juengel
* Added module SensorActorLoop.
*
*
*/
