/**
* @file SingleLandmarkSelfLocator.h
* 
* This file contains a class for self-localization based on measurements to a single landmark
* @author <a href=mailto:mkunz@sim.tu-darmstadt.de>Michael Kunz</a>
* @author <a href=mailto:brunn@sim.tu-darmstadt.de>Ronnie Brunn</a>
*/

#ifndef __SingleLandmarkSelfLocator_h_
#define __SingleLandmarkSelfLocator_h_

#include "SelfLocator.h"

/**
* This class implements self-localization based on measurements to a single landmark.
*/
class SingleLandmarkSelfLocator : public SelfLocator
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the SelfLocator module.
  */
  SingleLandmarkSelfLocator(const SelfLocatorInterfaces& interfaces);

  /** Executes the module */
  virtual void execute();

private:

  Pose2D lastOdometry; /**< The state of the odometry at the previous call of this module. */

  /** 
   * The last position
   */
  RobotPose lastPose;

  double lastPositionValidity; /**< reliability of last postition */
  double lastRotationValidity; /**< reliability of last rotation */
  
  /**
   * nextPose computes a corrected Pose using distance and bearing to flag according to its validity and the oldPose of the Robot
   */
  RobotPose nextPose(const Flag& flag, RobotPose oldPose);
  /**
   * nextPose computes a corrected Pose using distance and bearing to goal according to its validity and the oldPose of the Robot
   */
  RobotPose nextPose(const Goal& goal, RobotPose oldPose);

  /**
   * getValidity computes validity from distance difference
   */
  double getValidityDistance(double difference);

  /**
   * getValidity computes validity from angle difference
   */
  double getValidityAngle(double difference);

  
};

#endif// __SingleLandmarkSelfLocator_h_

/*
 * Change log :
 * 
 * $Log: SingleLandmarkSelfLocator.h,v $
 * Revision 1.2  2004/03/08 02:11:48  roefer
 * Interfaces should be const
 *
 * Revision 1.1  2003/10/06 14:10:15  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2002/09/22 18:40:53  risler
 * added new math functions, removed GTMath library
 *
 * Revision 1.2  2002/09/12 12:24:09  juengel
 * continued change of module/solution mechanisms
 *
 * Revision 1.1  2002/09/10 15:36:16  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.3  2002/08/26 11:54:52  brunn
 * added more comments and translated some to doxygen style
 *
 * Revision 1.2  2002/08/22 14:41:03  risler
 * added some doxygen comments
 *
 * Revision 1.1.1.1  2002/05/10 12:40:15  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.5  2002/04/22 16:37:07  mkunz
 * Validity calculations changed
 *
 * Revision 1.4  2002/04/17 17:04:38  risler
 * Darmstadt GO
 *
 * Revision 1.3  2002/04/02 13:10:20  dueffert
 * big change: odometryData and cameraMatrix in image now, old logfiles may be obsolete
 *
 * Revision 1.2  2002/02/12 09:45:09  roefer
 * Progress in DefaultLandmarksPerceptor and MonteCarloSelfLocator
 *
 * Revision 1.1  2002/02/06 16:20:48  brunn
 * UNSWSelfLocator entfernt - dafr gibt es jetzt den SingleLandmarkSelfLocator
 *
 *
 */
