/**
* @file SelfLocatorSelector.h
* 
* Definition of class SelfLocatorSelector
*
* @author Max Risler
* @author Martin Ltzsch
* @author Matthias Jngel
*/

#ifndef __SelfLocatorSelector_h_
#define __SelfLocatorSelector_h_

#include "Tools/Module/ModuleSelector.h"

#include "MonteCarloSelfLocator.h"
#include "SingleLandmarkSelfLocator.h"
#include "MRSingleLandmarkSelfLocator.h"
#include "LinesSelfLocator.h"
#include "OdometrySelfLocator.h"
#include "SpecialPerceptSelfLocator.h"
#include "GT2003SelfLocator.h"
#include "Fusion2003SelfLocator.h"
#include "NoOdometrySelfLocator.h"
#include "MotionRatingSelfLocator.h"

/**
* SelfLocator selection module.
*
* A selector for self locators
*/
class SelfLocatorSelector : public ModuleSelector, public SelfLocatorInterfaces
{
public:
/**
* Constructor.
* @param handler The module handler of the process.
* @param interfaces The paramters of the SelfLocator module.
  */
  SelfLocatorSelector(ModuleHandler &handler, const SelfLocatorInterfaces& interfaces)
    : ModuleSelector(SolutionRequest::selfLocator),
    SelfLocatorInterfaces(interfaces)
  {
    handler.setModuleSelector(SolutionRequest::selfLocator, this);
  }
  
  /** 
  * Is called on start and when the selected solution changes
  * to create a specific solution.
  * @param id The id of the solution to create
  * @return The created solution or 0
  */
  virtual Module* createSolution(SolutionRequest::ModuleSolutionID id)
  {
    switch(id)
    {
    case SolutionRequest::monteCarloSelfLocator:
      return new MonteCarloSelfLocator(*this);
      
    case SolutionRequest::singleLandmarkSelfLocator:
      return new SingleLandmarkSelfLocator(*this);
      
    case SolutionRequest::mrSingleLandmarkSelfLocator:
      return new MRSingleLandmarkSelfLocator(*this);
      
    case SolutionRequest::linesSelfLocator:
      return new LinesSelfLocator(*this);
      
    case SolutionRequest::odometrySelfLocator:
      return new OdometrySelfLocator(*this);
      
    case SolutionRequest::specialPerceptSelfLocator:
      return new SpecialPerceptSelfLocator(*this);
      
    case SolutionRequest::gt2003SelfLocator:
      return new GT2003SelfLocator(*this);
      
    case SolutionRequest::fusion2003SelfLocator:
      return new Fusion2003SelfLocator(*this);
      
    case SolutionRequest::noOdometrySelfLocator:
      return new NoOdometrySelfLocator(*this);
      
    case SolutionRequest::motionRatingSelfLocator:
	    return new MotionRatingSelfLocator(*this);
	    
    default:
      return 0;
    }
  }
  
  
};

#endif // __SelfLocatorSelector_h_

/*
* Change log :
* 
* $Log: SelfLocatorSelector.h,v $
* Revision 1.5  2004/03/17 16:18:49  thomas
* added preversion of motion optimisation with behaviour, selflocator, headcontrol and robotcontrol dialog
*
* Revision 1.4  2004/03/08 02:11:48  roefer
* Interfaces should be const
*
* Revision 1.3  2004/01/21 14:31:58  loetzsch
* Module Selectors create only the selected solution.
* When the solution changes, the old solution is erased and the new
* one ist created using createSolution(..)
*
* Revision 1.2  2003/12/02 19:45:42  spranger
* added NoOdometrySelfLocator
*
* Revision 1.1  2003/10/06 14:10:15  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/09/30 09:36:11  juengel
* Removed FusionSelfLocator.
*
* Revision 1.2  2003/09/01 15:07:12  juengel
* Removed SelfLocatorSwitcher.
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.8  2003/05/26 13:14:53  brunn
* Fusion2003SelfLocator added
*
* Revision 1.7  2003/05/22 07:53:05  roefer
* GT2003SelfLocator added
*
* Revision 1.6  2003/03/29 23:06:44  loetzsch
* added class SelfLocatorSwitcher
*
* Revision 1.5  2003/01/22 14:59:49  dueffert
* checkerboard stuff added
*
* Revision 1.4  2003/01/12 15:24:47  juengel
* Added OdometrySelfLocator
*
* Revision 1.3  2002/11/27 23:58:59  mkunz
* FusionSelfLocator added
*
* Revision 1.2  2002/09/12 12:24:09  juengel
* continued change of module/solution mechanisms
*
* Revision 1.1  2002/09/10 15:36:16  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.2  2002/08/21 11:50:44  cesarz
* GT2001PlayersPerceptor, BerlinSelfLocator, GT2001WalkingEngine,
* DoWalkingEngine, FuzzyBehaviorControl, BremenGOBehaviorControl,
* FuzzyBehaviortesterdlgbar and Behaviortesterdlgbar removed.
*
* Revision 1.1.1.1  2002/05/10 12:40:15  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.9  2002/04/02 13:10:20  dueffert
* big change: odometryData and cameraMatrix in image now, old logfiles may be obsolete
*
* Revision 1.8  2002/04/01 08:28:32  roefer
* Dummy LinesSelfLocator added
*
* Revision 1.7  2002/02/06 16:20:48  brunn
* UNSWSelfLocator entfernt - dafr gibt es jetzt den SingleLandmarkSelfLocator
*
* Revision 1.6  2002/02/05 04:08:28  loetzsch
* changed the execution of the SelfLocator. Parameter
* const PerceptCollection& perceptCollection became
* const LandmarksPercept& landmarksPercept, const LinesPercept& linesPercept.
*
* Revision 1.5  2002/01/20 13:00:18  risler
* changed implementation of selecting default solution
*
* Revision 1.4  2002/01/17 14:35:48  risler
* SolutionRequest added
*
* Revision 1.3  2001/12/10 17:47:07  risler
* change log added
*
*/
