/**
* @file SelfLocator.h
* 
* This file contains a generic class for Self-Localization.
*/

#ifndef __SelfLocator_h_
#define __SelfLocator_h_

#include "Tools/Module/Module.h"

#include "Representations/Perception/LandmarksPercept.h"
#include "Representations/Perception/LinesPercept.h"
#include "Representations/Perception/SpecialPercept.h"
#include "Representations/Perception/PSDPercept.h"
#include "Representations/Cognition/RobotPose.h"
#include "Representations/Cognition/SampleSet.h"
#include "Representations/Motion/OdometryData.h"
#include "Representations/Perception/CameraMatrix.h"
#include "Representations/Cognition/LandmarksState.h"

/**
* @class SelfLocatorInterfaces
* 
* The interfaces of the SelfLocator module.
*/
class SelfLocatorInterfaces
{
public:
  /** Constructor.*/
  SelfLocatorInterfaces(
    const LandmarksPercept& landmarksPercept,
    const LinesPercept& linesPercept,
    const SpecialPercept& specialPercept,
    const PSDPercept& psdPercept,
    const OdometryData& odometryData,
    const CameraMatrix& cameraMatrix,
    RobotPose& robotPose,
    SampleSetProxy<PoseSample>& selfLocatorSamples,
    LandmarksState& landmarksState)
    : landmarksPercept(landmarksPercept),
    linesPercept(linesPercept),
    specialPercept(specialPercept),
    psdPercept(psdPercept),
    odometryData(odometryData),
    cameraMatrix(cameraMatrix),
    robotPose(robotPose),
    selfLocatorSamples(selfLocatorSamples),
    landmarksState(landmarksState)
  {}

protected:
  /** The landmarks detected in the last image */
  const LandmarksPercept& landmarksPercept;
  
  /** The lines detected in the last image */
  const LinesPercept& linesPercept;
  
  /** The special percepts detected in the last image */
  const SpecialPercept& specialPercept;
  
  /** The psd percepts detected with the PSD sensor */
  const PSDPercept& psdPercept;
  
  /** The odometry that was estimated by the motion modules */
  const OdometryData& odometryData;

  /** The camera matrix describing the camera's position */
  const CameraMatrix& cameraMatrix;

  /** The robots position to be generated */
  RobotPose& robotPose;

  /** The sample set proxy linked to the sample set of the active locator */
  SampleSetProxy<PoseSample>& selfLocatorSamples;

  /** the currently seen landmarks */
  LandmarksState& landmarksState;
};

/**
* @class SelfLocator 
*
* The Base class for self locators
*/
class SelfLocator : public Module, public SelfLocatorInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the SelfLocator module.
  */
  SelfLocator(const SelfLocatorInterfaces& interfaces)
    : SelfLocatorInterfaces(interfaces)
  {}
  
  /** Destructor */
  virtual ~SelfLocator() {}
};

#endif //__SelfLocator_h_

/*
 * Change log :
 * 
 * $Log: SelfLocator.h,v $
 * Revision 1.4  2004/04/07 14:42:56  risler
 * moved LandsmarksState to Cognition directory, generated by SelfLocator
 *
 * Revision 1.3  2004/03/08 02:11:48  roefer
 * Interfaces should be const
 *
 * Revision 1.2  2003/11/10 13:34:07  dueffert
 * checkerboard localization improved
 *
 * Revision 1.3  2003/09/26 15:27:49  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.2  2003/07/30 14:47:46  dueffert
 * SpecialPerceptSelfLocator for Checkboard added
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.7  2003/05/12 14:08:40  brunn
 * renamed selfLocationSampleSetProxy to selfLocatorSamples
 * "Ha, glad am I that no one knew that Rumpelstiltskin I am styled"
 *
 * Revision 1.6  2003/05/12 12:28:11  brunn
 * renamed sampleSetProxy to selfLocationSampleSetProxy
 * added selfLocationSampleSetProxy to BehaviourControl-Interfaces
 *
 * Revision 1.5  2003/05/08 23:52:24  roefer
 * SampleSet and SampleSetProxy added
 *
 * Revision 1.4  2003/01/15 13:46:34  roefer
 * SelfLocator has access to CameraMatrix now
 *
 * Revision 1.3  2002/09/17 23:55:22  loetzsch
 * - unraveled several datatypes
 * - changed the WATCH macro
 * - completed the process restructuring
 *
 * Revision 1.2  2002/09/12 12:24:09  juengel
 * continued change of module/solution mechanisms
 *
 * Revision 1.1  2002/09/10 15:36:16  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.3  2002/08/30 14:34:06  dueffert
 * removed unused includes
 *
 * Revision 1.2  2002/08/22 14:41:03  risler
 * added some doxygen comments
 *
 * Revision 1.1.1.1  2002/05/10 12:40:15  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.6  2002/04/02 13:10:20  dueffert
 * big change: odometryData and cameraMatrix in image now, old logfiles may be obsolete
 *
 * Revision 1.5  2002/02/06 10:30:11  AndySHB
 * MonteCarloLocalization First Draft
 *
 * Revision 1.4  2002/02/05 04:08:28  loetzsch
 * changed the execution of the SelfLocator. Parameter
 * const PerceptCollection& perceptCollection became
 * const LandmarksPercept& landmarksPercept, const LinesPercept& linesPercept.
 *
 * Revision 1.3  2001/12/21 14:09:39  roefer
 * Added several destructors
 *
 * Revision 1.2  2001/12/10 17:47:07  risler
 * change log added
 *
 */
