/**
* @file SingleLandmarkSelfLocator.h
* 
* This file contains a class for self-localization based on measurements to a single landmark
* @author <a href=mailto:mkunz@sim.tu-darmstadt.de>Michael Kunz</a>
* @author <a href=mailto:brunn@sim.tu-darmstadt.de>Ronnie Brunn</a>
*/

#ifndef __MRSingleLandmarkSelfLocator_h_
#define __MRSingleLandmarkSelfLocator_h_

#include "SelfLocator.h"

/**
* This class implements self-localization based on measurements to a single landmark.
*/
class MRSingleLandmarkSelfLocator : public SelfLocator
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the SelfLocator module.
  */
  MRSingleLandmarkSelfLocator(SelfLocatorInterfaces& interfaces);

  /** Executes the module */
  virtual void execute();

private:

  Pose2D lastOdometry; /**< The state of the odometry at the previous call of this module. */

  /** 
   * The last position
   */
  RobotPose lastPose;

  double lastPositionValidity; /**< reliability of last postition */
  double lastRotationValidity; /**< reliability of last rotation */
  
  /**
   * nextPose computes a corrected Pose using distance and bearing to flag according to its validity and the oldPose of the Robot
   */
  RobotPose nextPose(const Flag& flag, RobotPose oldPose);
  /**
   * nextPose computes a corrected Pose using distance and bearing to goal according to its validity and the oldPose of the Robot
   */
  RobotPose nextPose(const Goal& goal, RobotPose oldPose);

  /**
   * getValidity computes validity from distance difference
   */
  double getValidityDistance(double difference);

  /**
   * getValidity computes validity from angle difference
   */
  double getValidityAngle(double difference);

  
};

#endif// __MRSingleLandmarkSelfLocator_h_

/*
 * Change log :
 *
 */
