/**
* @file ObstaclesLocatorSelector.h
* 
* Definition of class ObstaclesLocatorSelector
*
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Juengel</a>
*/

#ifndef __ObstaclesLocatorSelector_h_
#define __ObstaclesLocatorSelector_h_

#include "Tools/Module/ModuleSelector.h"
#include "DefaultObstaclesLocator.h"

/**
*/
class ObstaclesLocatorSelector : public ModuleSelector, public ObstaclesLocatorInterfaces
{
public:
/**
* Constructor.
* @param handler The module handler of the process.
* @param interfaces The paramters of the PlayersLocator module.
  */
  ObstaclesLocatorSelector(ModuleHandler &handler,const ObstaclesLocatorInterfaces& interfaces)
    : ModuleSelector(SolutionRequest::obstaclesLocator),
    ObstaclesLocatorInterfaces(interfaces)
  {
    handler.setModuleSelector(SolutionRequest::obstaclesLocator, this);
  }
  
  /** 
  * Is called on start and when the selected solution changes
  * to create a specific solution.
  * @param id The id of the solution to create
  * @return The created solution or 0
  */
  virtual Module* createSolution(SolutionRequest::ModuleSolutionID id)
  {
    switch(id)
    {
    case SolutionRequest::defaultObstaclesLocator:
      return new DefaultObstaclesLocator(*this);
    default:
      return 0;
    }
  }
};

#endif //__ObstaclesLocatorSelector_h_

/*
* Change log:
*
* $Log: ObstaclesLocatorSelector.h,v $
* Revision 1.3  2004/03/08 01:39:04  roefer
* Interfaces should be const
*
* Revision 1.2  2004/01/21 14:31:58  loetzsch
* Module Selectors create only the selected solution.
* When the solution changes, the old solution is erased and the new
* one ist created using createSolution(..)
*
* Revision 1.1  2003/10/06 14:10:14  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.3  2003/05/14 13:08:38  risler
* removed DefaultObstaclesLocator
* renamed MicroSectorsObstaclesLocator to DefaultObstaclesLocator
* ObstaclesModel contains increased number of sectors
* DefaultObstaclesLocator clean up
*
* Revision 1.2  2003/04/04 09:35:09  jhoffman
* added obstacle locator
*
* Revision 1.1  2003/03/10 13:53:59  juengel
* ObstaclesLocator
*
*
*/

