/**
* @file WakeUpEngine.h
* 
* Definition of class WakeUpEngine
*
* @author Andreas Heinze
*/

#ifndef __WakeUpEngine_h_
#define __WakeUpEngine_h_


#include "Representations/Perception/SensorDataBuffer.h"
#include "Representations/Motion/JointData.h"
#include "Representations/Motion/PIDData.h"

/** 
* @class WakeUpEngine
*
*
* 
*/
class WakeUpEngine
{
public:
/** 
* Constructor 
* @param interfaces The paramters of the MotionControl module.
* @param moduleHandler A reference to the ModuleHandler of the Process.
  */
  WakeUpEngine();
  
  /** Destructor */
  ~WakeUpEngine();
  
  void start(const SensorData& sensorData, PIDData& pidData);

  bool step(JointData& jointData, PIDData& pidData);
  
private:
  int counter;
  enum {numberOfKeyFrames = 4};
  long int position[JointData::numOfJoint][numberOfKeyFrames];
  long int stepSize[JointData::numOfJoint][numberOfKeyFrames-1];
  int frameNumberOfKeyFrame[numberOfKeyFrames];
  int frameNumberWhenDefaultPidDataIsReached;
  int currentKeyFrame;
  PIDData beginPid;
  double diffP[JointData::numOfJoint];
  double diffI[JointData::numOfJoint];
  double diffD[JointData::numOfJoint];
};

#endif// __WakeUpEngine_h_

/*
* Change log :
* 
* $Log: WakeUpEngine.h,v $
* Revision 1.3  2004/05/22 14:28:13  juengel
* First working version.
*
* Revision 1.2  2004/05/19 13:32:39  heinze
* worked at the engine
*
* Revision 1.1  2004/05/03 09:45:01  heinze
* Added WakeUpEngine.
*
*/
