/**
* @file LEDControl.h
* 
* Definition of class LEDControlInterfaces
*/

#ifndef __LEDControl_h_
#define __LEDControl_h_

#include "Tools/Module/Module.h"

#include "Representations/Motion/LEDRequest.h"
#include "Representations/Motion/LEDValue.h"

/**
* @class LEDControlInterfaces
*
* Interfaces of the LEDControl Module.
*/
class LEDControlInterfaces
{
public:
/** Constructor 
* @param ledRequest A request how to set the leds from the behavior
* @param wLanStatus1 The status of the WLan connection 1 to be displayed with the green leds
* @param wLanStatus2 The status of the WLan connection 2 to be displayed with the green leds
* @param wLanStatus3 The status of the WLan connection 3 to be displayed with the green leds
* @param ledValue The value of the led to be filled
  */
  LEDControlInterfaces(
    const LEDRequest& ledRequest,
    const int& wLanStatus,
    LEDValue& ledValue)
    : ledRequest(ledRequest),
    wLanStatus(wLanStatus),
    ledValue(ledValue)
  {}
protected:    
  /** A request how to set the leds from the behavior */
  const LEDRequest& ledRequest;
  
  /** The status of the WLan connection to be displayed with the green leds */
  const int& wLanStatus;
  
  /** The value of the led to be filled */
  LEDValue& ledValue;
};

/** 
* @class LEDControl
* 
* A generic class for LED control modules 
*/
class LEDControl : public Module, public LEDControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the LEDControl module.
  */
  LEDControl(const LEDControlInterfaces& interfaces)
    : LEDControlInterfaces(interfaces)
  {}

  /** Destructor */
  virtual ~LEDControl() {}
};

#endif //__LEDControl_h_

/*
* Change log :
* 
* $Log: LEDControl.h,v $
* Revision 1.3  2004/05/14 14:12:08  wachter
* - Added communication support for 5 robots
* - rewrote parts of team-communication to be faster and more stable
*
* Revision 1.2  2004/03/08 01:39:02  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/06 14:10:14  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/26 15:27:49  juengel
* Renamed DataTypes to representations.
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.5  2003/02/04 14:11:20  wachter
* fixed initialisation of wLanStatus 1..3
*
* Revision 1.4  2002/10/14 13:14:25  dueffert
* doxygen comments corrected
*
* Revision 1.3  2002/09/12 13:17:27  loetzsch
* made member variables of module interfaces protected
*
* Revision 1.2  2002/09/11 20:06:19  loetzsch
* continued experiments with modules/solutions
*
* Revision 1.1  2002/09/10 15:36:15  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.2  2002/05/16 22:36:11  roefer
* Team communication and GTMath bugs fixed
*
* Revision 1.4  2002/05/04 17:47:44  loetzsch
* LEDControl now has access to an instance of WLanStatus
* (which shall be displayed then with the green leds. follows next)
*
* Revision 1.3  2001/12/21 14:09:39  roefer
* Added several destructors
*
* Revision 1.2  2001/12/10 17:47:06  risler
* change log added
*
*/
