// RasterStrategy.h: Schnittstelle fr die Klasse RasterStrategy.
//
//////////////////////////////////////////////////////////////////////

#ifndef RASTERSTRATEGY_H
#define RASTERSTRATEGY_H

class RasterStrategy;

#include "RasterImageProcessor.h"
#include "Representations/Perception/ColorTableTSL.h"
#include <vector>

///////////////////////////////////////////////////////////////////////////////////
//
//      Makros for the RasterStrategies and RasterSpecialists                  
///////////////////////////////////////////////////////////////////////////////////

//const int	Y_VALUE = 0, /**< Relative offset of Y component. */
//			U_VALUE = cameraResolutionWidth, /**< Relative offset of U component. */
//			V_VALUE = 2 * cameraResolutionWidth; /**< Relative offset of V component. */

// This is a hack to speed up color table access. It obviously only works with ColorTable64
//#define COLOR_CLASS_HACK(y,u,v) (colorClass)((ColorTable64&) rip->colorTable).colorClasses[(y) >> 2][(u) >> 2][(v) >> 3]
//#define COLOR_CLASS(y,u,v) colorTable.getColorClass(y,u,v)

////////////////////////////////////////////////////////////////////////////////////////
//TSL-COLOR-Makros

#define GET_COLOR(p) RasterStrategy::getColor(p)

#define CHECK_COLOR(p,color) RasterStrategy::checkColor(p,color)


#define IS_ORANGE(p) CHECK_COLOR(p,orange)

#define IS_GREEN(p) CHECK_COLOR(p,green)

#define IS_WHITE(p) CHECK_COLOR(p,white)

#define IS_YELLOW(p) CHECK_COLOR(p,yellow)

#define IS_SKYBLUE(p) CHECK_COLOR(p,skyblue)

//Templates for color changes (usage with colorclasses)


#define IS_GB_CHANGE(color1,color2) RasterStrategy::isGoalBallChange(color1,color2)

#define IS_BALL_CHANGE(color1,color2) RasterStrategy::isBallChange(color1,color2)

#define IS_FB_CHANGE(color1,color2) RasterStrategy::isFieldBallChange(color1,color2)	


/////////////////////////////////////////////////////////////////////////////
//Geometrische Makros







///////////////////////////////////////////////////////////////////////////////

//#if _MSC_VER > 1000
//#pragma once
//#endif // _MSC_VER > 1000
//////////////////////////////////////////////////////////////////////////////7

class RasterStrategy  
{
public:

	enum ActivationKeys{
		preScan = 0,
		postScan,
		ball,
		flag,
		goal,
		lines,
		foes,
		numberOfActivationKeys
	};

	typedef const unsigned char* I_Pin;

	bool isEdge[100][100];

	bool insideBall;

	bool insideBox;

	bool insideBridge;

	bool insidePlayer;

	bool insideShirt;

	bool insideField;
	
	bool insideLM;

	bool horFalls;

	bool horRises;

	bool horConst;

	int bottomHorY;

	int topHorY;

	Geometry::Line horizon;

	colorClass enemyColor; 

	colorClass teamColor;

	RasterStrategy(RasterImageProcessor &iProcessor);
	virtual ~RasterStrategy();
	
	virtual void init() = 0;
	
	virtual void execute() = 0;

	
	//inline Funktionen, fr farbklassen-test
	//man knnte auch ein array mit
	//den farbklassen berechnen (durch bergangs-funktion)
	//und auch hier mit table-look-ups arbeiten!
	//dann knnten die gesuchten farbkombinationen
	//als parameterliste bergeben werden
	//(z.B array und grssenangabe)
	//dies ist aber erst mal nur eine idee!

	

	inline static bool isDogChange(int color1,int color2){
		return (((color1 == gray)||(color1 == blue)||(color1 == red)) && 
				(color2 == green || color2 == white 
				|| color2 == yellow || color2 == skyblue || color2 == orange)
				
				|| ((color2 == gray) || (color2 == blue)||(color2 == red)) &&
				(color1 == green || color1 == white || 
				color1 == yellow || color1 == skyblue || color1 == orange));
	}
	
	inline static bool isBallChange(int color1,int color2){
		return (color1 == orange && 
			(color2 == green || color2 == white 
			|| color2 == yellow || color2 == skyblue || color2 == gray)
			
			|| color2 == orange && 
			(color1 == green || color1 == white || 
			color1 == yellow || color1 == skyblue || color2 == gray)); //1?
	}

	inline static bool isGoalBallChange(int color1,int color2){
		return (color1 == orange &&(color2 == yellow || color2 == skyblue)
			|| color2 == orange && (color1 == yellow || color1 == skyblue));
	}

	inline static bool isFieldBallChange(int color1,int color2){
		return (color1 == orange &&
				(color2 == green || color2 == white || color2 == gray)
			|| color2 == orange && 
				(color1 == green || color1 == white || color1 == gray));
	}

	inline static bool isFieldChange(int color1,int color2){
		return (color2 == green && color1 == white)
			|| (color2 == white && color1 == green);
	}

/*	ColorTableTSL *colorTable;

	inline static colorClass getColor(I_Pin p){
		//return COLOR_CLASS_HACK(p[Y_VALUE],p[U_VALUE],p[V_VALUE]);
		return (colorClass) colorTable->
			colorClasses[p[Y_VALUE >> 3]][p[U_VALUE >> 2]][p[V_VALUE >> 2]];
	}

	inline static bool checkColor(I_Pin p,colorClass color){
		return (colorClass) colorTable->
			colorClasses[p[Y_VALUE >> 3]][p[U_VALUE >> 2]][p[V_VALUE >> 2]] == color;
	}

*/	//inline static I_Pin getImagePin(int x,int y){
	//	return &(image[x][0][y]);
	//}

	//static const int Y,U,V;
	

	protected:
	
	RasterImageProcessor *rip;
	//static const unsigned char *image;

		/* Zurzeit mit ColorTable64 implementiert */
//	inline colorClass getColor(I_Pin p){
//		return rip->colorTable.
//			getColorClass(p[Y_VALUE >> 2],p[U_VALUE >> 2],p[V_VALUE >> 2]);
		
		//return (colorClass) ((ColorTable64&)rip->colorTable).
		//	colorClasses[p[Y_VALUE >> 2]][p[U_VALUE >> 2]][p[V_VALUE >> 2]];
//	};

	/* Is giving the color from an quantized coordinate on the raster */
	inline colorClass getColorFromRaster(int x,int y){
		return getColor(getVecFromRaster(x,y));	
	};

	/* Returns the colorClass of one pixel via LUT */
	inline colorClass getColor(Vector2<int> v){
		return getColor(v.x,v.y);	
	};

	/* Returns the colorClass of one pixel via LUT */
	inline colorClass getColor(int x,int y){
		//return rip->colorTable.getColorClass(
		//	rip->image.image[y][0][x], rip->image.image[y][1][x], rip->image.image[y][2][x]);
		unsigned char cy = rip->image.image[y][0][x];
		unsigned char cu = rip->image.image[y][1][x];
		unsigned char cv = rip->image.image[y][2][x];
		rip->corrector.getCorrectedPixel(x,y,cy,cu,cv);
		return rip->colorTable.getColorClass(cy,cu,cv);	
	};
	
	/* Returns the colorClass with executing color-correction for this pixel*/
	inline colorClass getCorrectedColor(int x,int y){
		unsigned char cy = rip->image.image[y][0][x];
		unsigned char cu = rip->image.image[y][1][x];
		unsigned char cv = rip->image.image[y][2][x];
		rip->corrector.getCorrectedPixel(x,y,cy,cu,cv);
		return rip->colorTable.getColorClass(cy,cu,cv);	
	};

	/* Zurzeit mit ColorTable64 implementiert */
	inline bool checkColor(int x,int y,colorClass color){
		return	color ==  
			rip->colorTable.getColorClass(
				rip->image.image[y][0][x], 
				rip->image.image[y][1][x], 
				rip->image.image[y][2][x]);
	};

/* Returns if the colorClass of one pixel via LUT equals color */
	inline bool checkColor(Vector2<int> v,colorClass color){
		return	color ==  
			rip->colorTable.getColorClass(
				rip->image.image[v.y][0][v.x], 
				rip->image.image[v.y][1][v.x], 
				rip->image.image[v.y][2][v.x]);
	};
	


	
	/** Gibt einen Vector2 aus dem Raster zurck, 
		der aber die Bildkoordinaten enthlt! */
	inline Vector2<int> getVecFromRaster(int x,int y){
		return Vector2<int>(x*rip->marginX,y*rip->marginY);
	};

	/** Gives a number between 0 and 360 with the same order as v.angle()*/
	inline double theta(int dx,int dy){
		double t = 0;
		int ax = abs(dx);
		int ay = abs(dy);
		if (dx == 0 && dy == 0) t = 0;
		else t = (double)dy /(double)(ax + ay);
		if (dx < 0) t = 2 - t;
		else if (dy < 0) t = 4 + t;
		return t*90; // multiplication with 90 is not really needed for correct ordering
	}


	private :
		const int Y_VALUE,U_VALUE,V_VALUE;

};

#endif // !defined(AFX_RASTERSTRATEGY_H__E73419DC_85CE_4D73_87C1_DEBCEC21740B__INCLUDED_)



/*
* Change log :
* 
* $Log: RasterStrategy.h,v $
* Revision 1.16  2004/05/27 11:18:48  schmidtb
* new version with further work for open challenge
*
* Revision 1.15  2004/05/25 13:27:34  schmidtb
* modified version of rip for open-challenge
*
* Revision 1.16  2004/05/22 16:01:49  pg_besc
* -modified version of rip for bridge-recognition
*
* Revision 1.15  2004/05/18 10:52:14  pg_besc
* version of the last game at US-Open
*
* Revision 1.14  2004/04/15 19:09:02  pg_besc
* merged code
*
* Revision 1.13  2004/03/17 17:06:09  koh
* added enemyOnlySpecialist;
* added enemySpecialist2;
* added some int and bool variables
*
* Revision 1.12  2004/03/11 20:34:01  schmidtb
* new version of rip
*
* Revision 1.11  2004/03/04 09:54:52  schmidtb
* color correction integrated
*
* Revision 1.10  2004/03/03 12:53:22  schmidtb
* color correction integrated
*
* Revision 1.9  2004/03/01 14:17:26  koh
* added new strategy "RFlexibleStrategy" + new specialist "EnemyOnlySpecialist";
* changed references to "RDefaultStrategy" to references to "RasterStrategy" in RFieldSpecialist
* added Geometry::Line horizon to "RasterStrategy"
*
* Revision 1.8  2004/02/02 13:42:12  schmidtb
* merged sources of RIP. added som functions.
*
* Revision 1.7  2004/01/23 15:44:01  deom
* New specialist :: BoxSpecialist
* Recognizes both landmarks and goals
*
* Revision 1.6  2003/12/15 13:55:33  schmidtb
* Merged and patched new version of RasterImageProcessor.
*
* Revision 1.5  2003/12/02 21:59:02  schmidtb
* New version of RasterImageProcessor
*
* Revision 1.4  2003/12/02 12:45:44  neubach
* new EnemySpecialist added
*
* Revision 1.3  2003/11/20 10:26:56  schmidtb
* Ball Detection added
*
* Revision 1.2  2003/11/13 10:41:29  schmidtb
* renewed RBallSpeciaslist and Strategy
*
* Revision 1.1  2003/11/12 13:13:20  schmidtb
* new RasterImageProcessor added
*
*
*/
