// RasterImageProcessor.h: Schnittstelle fr die Klasse RasterImageProcessor.
//
//////////////////////////////////////////////////////////////////////


#ifndef RASTERIMAGEPROCESSOR_H
#define RASTERIMAGEPROCESSOR_H

#include "Modules/ImageProcessor/ImageProcessorTools/SUSANEdgeDetectionLite.h"
#include "Modules/ImageProcessor/ImageProcessor.h"
#include "Tools/Debugging/DebugDrawings.h"
#include "Tools/Math/Geometry.h"
#include "Tools/Debugging/DebugImages.h"
#include "Modules/ImageProcessor/ImageProcessorTools/MSH2004ColorCorrector.h"


/** A specialist for collecting information about the Scene */
class RasterSpecialist;

/** This class defines a strategy to walk over the raster */
class RasterStrategy;

/** The ImageProcessor */
class RasterImageProcessor;



//#include "./RasterSpecialist.h"
//#include "./RasterStrategy.h"


//Specialist-types for the RasterImageProcessor. 
enum RasterSpecTypes{
	__RBallSpecialist,
	__RFieldSpecialist,
	__RFlagSpecialist,
	__RGoalSpecialist,
	__REnemySpecialist,
	__REnemyOnlySpecialist,
	__RBoxSpecialist,
	__REnemySpecialist2,
	__RBridgeSpecialist,
  maxRasterSpecialists
};



class RasterImageProcessor : public ImageProcessor  
{
public:
	
	SUSANEdgeDetectionLite edgeDetector;

	MSH2004ColorCorrector corrector;

	RasterImageProcessor(const ImageProcessorInterfaces& interfaces);
	virtual ~RasterImageProcessor();
	
	/** Executes the module */
	virtual void execute();
	
	virtual bool handleMessage(InMessage& message);
	
	RasterSpecialist *getSpecialist(int type);
	
	void setSpecialist(RasterSpecialist *spec);
	
	void removeSpecialist(int type);

	inline Geometry::Line getHorizon(){return horizon;}

	inline void addFieldPoint(int x,int y,LinesPercept::LineType type){
		Vector2<int> p;
		Geometry::calculatePointOnField(x,y,cameraMatrix,
			image.cameraInfo,p);
		linesPercept.add(type,p);
	}

	inline void addObstaclePoints(
		Vector2<int>& nearPointInImage,
		Vector2<int>& farPointInImage,
		ObstaclesPercept::ObstacleType type)
	{
		Vector2<int> nearPoint;
		Vector2<int> farPoint;
		Geometry::calculatePointOnField(
			nearPointInImage.x,nearPointInImage.y,cameraMatrix,image.cameraInfo,nearPoint);
		Geometry::calculatePointOnField(
			farPointInImage.x,farPointInImage.y,cameraMatrix,image.cameraInfo,farPoint);
		
		bool farOnBorder = 
			(farPointInImage.x>image.cameraInfo.resolutionWidth-3 
			|| farPointInImage.x < 2 
			|| farPointInImage.y < 2 
			|| farPointInImage.y>image.cameraInfo.resolutionHeight-3);

		obstaclesPercept.add(nearPoint,farPoint,farOnBorder,type);
	}

	inline bool isValidPoint(Vector2<double>& p){
		if (p.x >= image.cameraInfo.resolutionWidth -2 || p.x <= 1) return false;
		if (p.y >= image.cameraInfo.resolutionHeight - 2 || p.y <= 1) return false;
		return true;
	}

	void addFlag(Vector2<double>& left,Vector2<double>& right,
		Vector2<double>& top, Vector2<double>& bottom,
		Vector2<int> center,Flag::FlagType type);

	/** changes the strategy. the old one will be deleted ! */
	void changeStrategy(RasterStrategy &newStrategy);

	//TODO: Array anpassen 
	Vector2<int>  raster[210][180];

	int rasterHeight;
	
	int rasterWidth;

	int minX;

	int maxX;

	int minY;

	int maxY;
	
	int marginX;

	int marginY;

  DECLARE_DEBUG_COLOR_CLASS_IMAGE(segmentedImage1);

private:
  
	void init();
	
	RasterSpecialist *specials[maxRasterSpecialists];

	RasterStrategy *strategy;

	RasterStrategy *waitingStrategy;

	Geometry::Line horizon; /**< The horizon. */

  DECLARE_DEBUG_IMAGE(imageProcessorGeneral);
  /*DECLARE_DEBUG_IMAGE(imageProcessorScanLines);
  DECLARE_DEBUG_IMAGE(imageProcessorGradients);*/
  DECLARE_DEBUG_IMAGE(imageProcessorBall);
  DECLARE_DEBUG_IMAGE(imageProcessorObstacles);
  DECLARE_DEBUG_IMAGE(imageProcessorFlagsAndGoals);
  DECLARE_DEBUG_IMAGE(imageProcessorGround);
  /*DECLARE_DEBUG_COLOR_CLASS_IMAGE(segmentedImage3);
  DECLARE_DEBUG_COLOR_CLASS_IMAGE(segmentedImage2);
  DECLARE_DEBUG_IMAGE(classificationY);
  DECLARE_DEBUG_IMAGE(classificationU);
  DECLARE_DEBUG_IMAGE(classificationV);
  DECLARE_DEBUG_IMAGE(colorFrequency);
	*/
};


#endif


/*
* Change log :
* 
* $Log: RasterImageProcessor.h,v $
* Revision 1.17  2004/05/25 13:27:33  schmidtb
* modified version of rip for open-challenge
*
* Revision 1.16  2004/04/08 17:14:26  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.16  2004/03/25 15:21:19  pg_besc
* made some changes
*
* Revision 1.15  2004/03/17 18:27:45  koh
* warnings and errors removed
*
* Revision 1.14  2004/03/11 20:32:36  schmidtb
* new version of rip
*
* Revision 1.13  2004/03/08 01:39:02  roefer
* Interfaces should be const
*
* Revision 1.12  2004/03/03 12:53:21  schmidtb
* color correction integrated
*
* Revision 1.11  2004/03/01 14:17:26  koh
* added new strategy "RFlexibleStrategy" + new specialist "EnemyOnlySpecialist";
* changed references to "RDefaultStrategy" to references to "RasterStrategy" in RFieldSpecialist
* added Geometry::Line horizon to "RasterStrategy"
*
* Revision 1.10  2004/02/28 17:16:47  schmidtb
* debugged and made some changes
*
* Revision 1.9  2004/02/04 13:12:23  nistico
* Removed unneeded references in RasterImageProcessor to ManualCalibration, which were binding it
* to ColorTable64
*
* Revision 1.8  2004/02/02 13:42:12  schmidtb
* merged sources of RIP. added som functions.
*
* Revision 1.7  2004/01/23 15:44:01  deom
* New specialist :: BoxSpecialist
* Recognizes both landmarks and goals
*
* Revision 1.6  2003/12/15 13:55:32  schmidtb
* Merged and patched new version of RasterImageProcessor.
*
* Revision 1.5  2003/12/08 15:02:55  schmidtb
* new version of RIP
*
* Revision 1.4  2003/12/04 09:51:23  schmidtb
* better BallSpecialist
*
* Revision 1.3  2003/11/20 10:26:56  schmidtb
* Ball Detection added
*
* Revision 1.2  2003/11/13 10:41:29  schmidtb
* renewed RBallSpeciaslist and Strategy
*
* Revision 1.1  2003/11/12 13:13:20  schmidtb
* new RasterImageProcessor added
*
*
*/
