
#include "RGoalSpecialist.h"
#include <algorithm>


typedef Geometry::Line Line;
typedef vector<list<RasterSpecialist::LinePair> > SVector;

float dist (Vector2 <int> v1,Vector2 <int> v2) {
	return sqrt((float)sqr(v2.x-v1.x)+(float)sqr(v2.y-v1.y));
}


Vector2 <int> mil(Vector2 <int> v1,Vector2 <int> v2) {
	return Vector2 <int> ((v1.x+v2.x) / 2,v1.y);
}



RGoalSpecialist::RGoalSpecialist(RasterImageProcessor &processor,RasterStrategy &strat):
	RasterSpecialist(processor) {

	strategy = &strat;
	preScanNeeded = true;
	postScanNeeded = false;


}

RGoalSpecialist::~RGoalSpecialist()
{
}


int RGoalSpecialist::getType() {


	return __RGoalSpecialist;
}
	

void RGoalSpecialist::init() {

}


void RGoalSpecialist::createInfos(std::vector<list<LinePair> >& v, std::list<SegmentInfo>& infos){

	SVector::iterator sit;
	list<LinePair>::iterator l_it;
	
	double dist, p_dist;

	for (sit = v.begin();sit != v.end();sit++){

		OUTPUT(idText,text,"size of Goal-Seg: "<<  sit->size());

		if (sit->size() > 1){
			infos.push_back(SegmentInfo());
			infos.back().segment = &(*sit);
			double min_dist = 20000, max_dist = -20000, min_p_dist = 20000, max_p_dist = -20000;

			for (l_it = sit->begin();l_it!=sit->end();++l_it) {

				dist = getDistanceToLine(horizon,l_it->v1);
				p_dist = getDistanceToLine(pHorizon,l_it->v1);

				if (dist < min_dist) {
					min_dist = dist;
					infos.back().minHor = l_it->v1;

				}
				if (dist > max_dist) {
					max_dist = dist;
					infos.back().maxHor = l_it->v1;
				}

				if (p_dist < min_p_dist) {
					min_p_dist = p_dist;
					infos.back().minPHor = l_it->v1;
				}
				if (p_dist > max_p_dist) {
					max_p_dist = p_dist;
					infos.back().maxPHor = l_it->v1;

				}

				dist = getDistanceToLine(horizon,l_it->v2);
				p_dist = getDistanceToLine(pHorizon,l_it->v2);

				if (dist < min_dist) {
					min_dist = dist;
					infos.back().minHor = l_it->v2;

				}
				if (dist > max_dist) {
					max_dist = dist;
					infos.back().maxHor = l_it->v2;
				}

				if (p_dist < min_p_dist) {
					min_p_dist = p_dist;
					infos.back().minPHor = l_it->v2;
				}
				if (p_dist > max_p_dist) {
					max_p_dist = p_dist;
					infos.back().maxPHor = l_it->v2;

				}

			}

		}
		

	}

}


void RGoalSpecialist::createRectangles(std::list<SegmentInfo>& infos,std::vector<Rectangle>& rects){


	Geometry::Line top,bottom,left,right;
	list<SegmentInfo>::iterator it;

	for(it=infos.begin();it!=infos.end();++it) {

		top.base = Vector2<double>(
			(double)it->maxHor.x,
			(double)it->maxHor.y);
		top.direction = horizon.direction;
		
		bottom.base = Vector2<double>(
			(double)it->minHor.x,
			(double)it->minHor.y);
		bottom.direction = horizon.direction;
		
		left.base = Vector2<double>(
			(double)it->minPHor.x,
			(double)it->minPHor.y);
		left.direction = pHorizon.direction;
		
		right.base = Vector2<double>(
			(double)it->maxPHor.x,
			(double)it->maxPHor.y);
		right.direction = pHorizon.direction;

		Rectangle rect;
		
		Geometry::getIntersectionOfLines(top,left,rect.upperLeft);
		Geometry::getIntersectionOfLines(top,right,rect.upperRight);
		Geometry::getIntersectionOfLines(bottom,left,rect.bottomLeft);
		Geometry::getIntersectionOfLines(bottom,right,rect.bottomRight);
		
		rects.push_back(rect);
		it->rect = &rect;


	}

}

void RGoalSpecialist::executePostProcessing() {

	horizon = rip->getHorizon();

	pHorizon.base = horizon.base;
	pHorizon.direction = horizon.direction;
	pHorizon.direction.rotateLeft();

	
	SVector segments;

#define DORTMUND_SUCKS	
#ifndef DORTMUND_SUCKS
    createSegmentsFromLines(lst_pts,segments);
#endif
    sort<SVector::iterator>(segments.begin(),segments.end(),ListSizeOrder());
	

	int seg_size = segments.size();


	SVector::iterator it_v;

	vector<int> vect_col;
	list<RasterSpecialist::LinePair>::iterator it_v_l;

	bool make_fusion = false;

	for (it_v = segments.begin();it_v!=segments.end();++it_v) {


		//OUTPUT(idText,text,"taille lst " << it_v->size());

		int col_amnt = 0;

		for(it_v_l = it_v->begin();it_v_l != it_v->end();++it_v_l) {

			colorClass cur_col = getColorFromRaster(it_v_l->v1.x+1,it_v_l->v1.y);			
			colorClass cur_col2 = getColorFromRaster(it_v_l->v2.x-1,it_v_l->v2.y);

			if(cur_col==yellow && cur_col2==yellow) col_amnt+=(it_v_l->v2.x - it_v_l->v1.x);
			else if (cur_col==blue && cur_col2==blue) col_amnt-=(it_v_l->v2.x - it_v_l->v1.x);


			//OUTPUT(idText,text,"col        " << col_amnt);
		}

		vect_col.push_back(col_amnt);

	}

	if (seg_size>1) {

		float size_fact;;

	
		size_fact = (float)segments[seg_size-1].size()/(float)segments[seg_size-2].size();

		OUTPUT(idText,text,"size fact" << size_fact);
		OUTPUT(idText,text,"col fact" << vect_col[0]*vect_col[1]);


		if(vect_col[0]*vect_col[1]>=0 && size_fact<=2,2) {  // die beide teile verschmelsen

			OUTPUT(idText,text,"make fusion");
			
			make_fusion = true;
			


		}


	}



	list<SegmentInfo> infos;

	createInfos(segments, infos);


	/*
	list<SegmentInfo>::iterator it ;

	for(it = infos.begin();it!=infos.end();++it) {
		DOT(imageProcessor_general, it->minPHor.x,it->minPHor.y, 
			Drawings::red, Drawings::red);

		DOT(imageProcessor_general, it->maxPHor.x,it->maxPHor.y, 
			Drawings::red, Drawings::black);

		DOT(imageProcessor_general, it->minHor.x,it->minHor.y, 
			Drawings::red, Drawings::green);

		DOT(imageProcessor_general, it->maxHor.x,it->maxHor.y, 
			Drawings::red, Drawings::gray);



	}
	*/

	vector<Rectangle> result;
	vector<Rectangle>::iterator r_it;

	createRectangles(infos,result);



	if (make_fusion) {

		Geometry::Line a,b,c,d;

		a.base = result[seg_size-1].upperRight;
		b.base = result[seg_size-1].bottomRight;
		c.base = result[seg_size-2].upperLeft;
		d.base = result[seg_size-2].bottomLeft;


		DOT(imageProcessor_general, a.base.x,a.base.y, 
				Drawings::white, Drawings::white);

		DOT(imageProcessor_general, b.base.x,b.base.y, 
				Drawings::black, Drawings::white);

		DOT(imageProcessor_general, c.base.x,c.base.y, 
				Drawings::red, Drawings::white);

		DOT(imageProcessor_general, d.base.x,d.base.y, 
				Drawings::blue, Drawings::white);

		Rectangle r;


		if (d.base.y<b.base.y) {


			OUTPUT(idText,text,"cas 2");

			a.direction = pHorizon.direction;
			b.direction = horizon.direction;
			c.direction = horizon.direction;
			d.direction = pHorizon.direction;


			r.bottomRight = b.base;
			r.upperLeft = c.base;


			Geometry::getIntersectionOfLines(a,c,r.upperRight);
			Geometry::getIntersectionOfLines(b,d,r.bottomLeft);

		} else {

			OUTPUT(idText,text,"cas 1");

			a.direction = horizon.direction;
			b.direction = pHorizon.direction;
			c.direction = pHorizon.direction;
			d.direction = horizon.direction;

			r.upperRight = a.base;
			r.bottomLeft = d.base;

			Geometry::getIntersectionOfLines(a,c,r.upperLeft);
			Geometry::getIntersectionOfLines(b,d,r.bottomRight);

		}


		result.pop_back();


		result[seg_size-2] = r;

	}



	for(r_it = result.begin();r_it!=result.end();++r_it) {

	LINE(imageProcessor_general,
			r_it->upperLeft.x,r_it->upperLeft.y,r_it->upperRight.x,r_it->upperRight.y,
			0.6, Drawings::ps_solid, Drawings::white);
	LINE(imageProcessor_general,
			r_it->bottomLeft.x,r_it->bottomLeft.y,r_it->bottomRight.x,r_it->bottomRight.y,
			0.6, Drawings::ps_solid, Drawings::green);
	LINE(imageProcessor_general,
			r_it->upperLeft.x,r_it->upperLeft.y,r_it->bottomLeft.x,r_it->bottomLeft.y,
			0.6, Drawings::ps_solid, Drawings::yellow);
	LINE(imageProcessor_general,
			r_it->upperRight.x,r_it->upperRight.y,r_it->bottomRight.x,r_it->bottomRight.y,
			0.6, Drawings::ps_solid, Drawings::blue);

	}

}

//noch nicht gebraucht!!
void RGoalSpecialist::invokeOnPostScan(int x,int y) {

}




void RGoalSpecialist::invokeOnPreScan(int x, int y){

	Vector2 <int> cur_pt = getVecFromRaster(x,y);

#define DORTMUND_SUCKS
#ifndef DORTMUND_SUCKS
	if (!strategy->insideGoal) left_border = cur_pt;
	else
	{

		LinePair lp(scanWest(left_border.x,left_border.y),
					scanEast(cur_pt.x,cur_pt.y));
		if ((lp.v2.x-lp.v1.x)>4) {
			lst_pts.push_back(lp);
		
/*
			DOT(imageProcessor_general, left_border.x,left_border.y, 
				Drawings::ps_solid, Drawings::white);
			DOT(imageProcessor_general, cur_pt.x,cur_pt.y, 
				Drawings::ps_solid, Drawings::blue);
			LINE(imageProcessor_general,
				left_border.x,left_border.y, 
				cur_pt.x,cur_pt.y, 
				0.5, Drawings::ps_solid, Drawings::red);

  */
		}
			

	}
#endif
}

double RGoalSpecialist::getDistanceToLine
(
 const Geometry::Line line,
 const Vector2<int>& point
 )
{
	Vector2<double> pd((double)point.x,(double)point.y);

	if (line.direction.x == 0 && line.direction.y == 0) 
		return Geometry::distance(pd, line.base);

	Vector2<double> normal;
	normal.x = line.direction.y;
	normal.y = -line.direction.x;
	normal.normalize();

	double c = normal * line.base;

	return normal * pd - c;
}

void RGoalSpecialist::calculateValidities(std::list<SegmentInfo>& rects){
	
	
}

void RGoalSpecialist::mergeSegments(SegmentInfo& seg1,SegmentInfo& seg2){
	Geometry::Line top,bottom,left,right;


	seg1.segment->merge(*(seg2.segment));

	if (getDistanceToLine(horizon,seg1.maxHor) <
		getDistanceToLine(horizon,seg2.maxHor))
		seg1.maxHor = seg2.maxHor;

	if (getDistanceToLine(horizon,seg1.minHor) >
		getDistanceToLine(horizon,seg2.minHor))
		seg1.minHor = seg2.minHor;

	if (getDistanceToLine(horizon,seg1.maxPHor) <
		getDistanceToLine(horizon,seg2.maxPHor))
		seg1.maxPHor = seg2.maxPHor;

	if (getDistanceToLine(horizon,seg1.minPHor) >
		getDistanceToLine(horizon,seg2.minPHor))
		seg1.minPHor = seg2.minPHor;

	top.direction = horizon.direction;
	bottom.direction = horizon.direction;
	left.direction = pHorizon.direction;
	right.direction = pHorizon.direction;

	top.base = Vector2<double>((double)seg1.maxHor.x,(double)seg1.maxHor.y);
	bottom.base = Vector2<double>((double)seg1.minHor.x,(double)seg1.minHor.y);
	right.base = Vector2<double>((double)seg1.maxPHor.x,(double)seg1.maxPHor.y);
	left.base = Vector2<double>((double)seg1.minPHor.x,(double)seg1.minPHor.y);

	Geometry::getIntersectionOfLines(bottom,left,seg1.rect->bottomLeft);
	Geometry::getIntersectionOfLines(top,left,seg1.rect->upperLeft);
	Geometry::getIntersectionOfLines(bottom,right,seg1.rect->bottomRight);
	Geometry::getIntersectionOfLines(top,right,seg1.rect->upperRight);

}


/*
* Change Log:
*
* $Log: RGoalSpecialist.cpp,v $
* Revision 1.27  2004/01/28 12:58:16  roefer
* DORTMUND SUCKS
*
* Revision 1.26  2004/01/26 20:37:56  schmidtb
* removed errors and warnings, merged versions of RGoalSpecialist
*
* Revision 1.25  2004/01/23 16:32:01  roefer
* DORTMUND SUCKS
*
* Revision 1.24  2004/01/22 16:34:36  deom
* fusion works
*
* Revision 1.23  2004/01/20 20:34:32  roefer
* Warnings removed
*
* Revision 1.22  2004/01/20 17:11:56  deom
* knows when to fusion, but bugs appears during the fusion
*
* Revision 1.21  2004/01/20 10:34:23  schmidtb
* removed error in executePostProcessing
*
* Revision 1.20  2004/01/20 10:23:58  schmidtb
* fixed bugs in RGoalSpecialist
*
* Revision 1.19  2004/01/19 16:28:21  schmidtb
* fixed warnings
*
* Revision 1.18  2004/01/19 16:18:45  schmidtb
* GoalSpecialist recognizes Landmarks
*
* Revision 1.17  2004/01/17 21:31:36  roefer
* PLEASE remove gcc-warnings BEFORE you check in!
*
* Revision 1.16  2004/01/17 13:59:31  schmidtb
* scan under horizon fixed
*
* Revision 1.15  2004/01/16 17:43:34  deom
* no message
*
* Revision 1.14  2004/01/15 23:12:34  roefer
* Warnings removed
*
* Revision 1.13  2004/01/15 16:44:44  schumann
* removed warnings
*
* Revision 1.12  2004/01/13 18:51:45  deom
* no message
*
* Revision 1.11  2004/01/13 13:33:52  deom
* no message
*
* Revision 1.10  2004/01/12 15:10:37  schmidtb
* new GoalSpecialist
*
* Revision 1.9  2003/12/18 17:44:46  hyung
* established new version of method checkGoal(int x,int y)
*
* Revision 1.7  2003/12/18 10:56:17  deom
* no message
*
* Revision 1.6  2003/12/16 23:07:02  roefer
* Many work-arounds to make it compile
*
* Revision 1.5  2003/12/16 21:58:09  deom
* *** empty log message ***
*
* Revision 1.4  2003/12/16 21:48:10  deom
* *** empty log message ***
*
* Revision 1.3  2003/12/15 13:55:32  schmidtb
* Merged and patched new version of RasterImageProcessor.
*
* Revision 1.2  2003/12/11 17:27:56  loetzsch
* did not compile
*
*/


