/**
 * @file RFlexibleStrategy.h
 * 
 * This file contains the interface of RFlexibleStrategy.h for the RasterImageProcessor
 *
 * @author <a href="mailto:rookie_rocksta@web.de">Hyung-Won Koh</a>
 */																									
//////////////////////////////////////////////////////////////////////

#ifndef RFLEXIBLESTRATEGY_H
#define RFLEXIBLESTRATEGY_H

class RFlexibleStrategy;

#include "RasterStrategy.h"
#include "REnemyOnlySpecialist.h"
#include "RBallSpecialist.h"
#include "RFieldSpecialist.h"
#include "BoxSpecialist.h"
#include <vector>
#include <deque>

#include "Tools/Math/Geometry.h"


class RFlexibleStrategy;
class RBallSpecialist;
class RBallSpecialist2;
class RFieldSpecialist;
class REnemyOnlySpecialist;
class RBoxSpecialist;


class RFlexibleStrategy : public RasterStrategy  
{
public:

	RFlexibleStrategy(RasterImageProcessor &processor);
	virtual ~RFlexibleStrategy();

	void execute();

	void init();

	bool lineChanged;

	bool columnChanged;

	bool wasRedOrBlue;
	
	bool redLp;

	colorClass get_currentColor() const {return currentColor;}
	
	int get_width() const {return width;}

private:
	
	void checkPlayer(int x,int y);

	void checkPlayerRisingHor(int x, int y);

	void preScan();
	
	void postScan();
	
	bool xPlayerFactor;

	bool yPlayerFactor;

	bool xBallFactor;

	bool yBallFactor;

	bool xGoalFactor;

	bool yGoalFactor;

	bool xLmFactor;

	bool yLmFactor;

	bool xFieldFactor;

	bool yFieldFactor;
	
	bool leftBallTested;

	bool inRedBall;

	bool orangeAgain;

	bool whiteAgain;
	
	int yIncAbove;	 

	int xIncAbove;

	int yIncBetween;

	int xIncUnderHor;

	int yIncBelow;	

	int xIncBelow;
	
	int enemyCtr;

	int whiteCtr;

	int orangeCtr;

	int orangeRedChange;

	int leftBall;

	int rightBall;

	int ballDepth;

	int lmCorAbove;
	
	int playerCorBetween;

	int ballCorBetween ;
	
	int goalCorBetween;		//	has to be destinguished if above or under horizon(if different xInc will be enabled)
	
	int lmCorBetween;	//	has to be destinguished if above or under horizon(if different xInc will be enabled)	

	int playerCorBelow;

	int ballCorBelow;

	int goalCorBelow;

	int lmCorBelow;

	int fieldCorBelow;
	
	void postProcessing();

	void checkBall(int x,int y,int prePost);

	void checkField(int x,int y,int prePost);

	void checkBox(int x, int y,int prePost);

	void checkLine(int x, int y);

	void checkLastLinePoint(int factor,colorClass color,
		int line,RasterSpecialist &spec);
	
	void checkLastColumnPoint(int factor,colorClass color,
		int column,RasterSpecialist &spec);

	RBallSpecialist* ballSpecialist;

	RFieldSpecialist* fieldSpecialist;

	REnemyOnlySpecialist* enemyOnlySpecialist;

	BoxSpecialist* boxSpecialist;

	colorClass lastColor; 

	colorClass currentColor;

	int linePattern;

	int lineXActive;

	int lineYActive;

	int width;
	
	int height;

	int ballFactor;

	int fieldFactor;

	int goalFactor;

	int playerFactor;

	int lmFactor;

	int distToHorizon;

	Geometry::Line horizon; 

	colorClass BoxColor;

};

#endif


/*
* Change log :
* 
* $Log: RFlexibleStrategy.h,v $
* Revision 1.5  2004/03/17 16:55:03  koh
* some minor changes
*
* Revision 1.4  2004/03/01 20:58:42  koh
* new strategy RFlexibleStrategy and new RasterSpecialist REnemyOnlySpecialist added
*
*
*
* commit log added
*
*
*/




