#ifndef _RFieldStateMachine_h_
#define _RFieldStateMachine_h_


#include "Modules/ImageProcessor/ImageProcessorTools/MSH2004EdgeDetection.h"

/**
* @class RFieldStateMachine
*
* This class represents a deterministic state machine.
* The machine has the ability to determine
* the object-type of an edge-point found on
* the field.
* The scans should go from the horizon to the ground.
* It is not really needed to scan perpendicular to the
* horizon.
* The machine is reading from the buffers of the edgeDetection
* and changes its states automaticly. For this the client should
* call reset() before every scan and then use a buffered scan to
* an edge to fill the buffer. After this call update() to update
* the state of the machine and continue the scan. So the client has
* to call update() after an edge is found or the scan is finished.
*
*
* @author <A href=mailto:sadprofessor@web.de>Bernd Schmidt</A>
*/
class RFieldStateMachine 
{
    
public:
	
	enum PointTypes {
		nothing = 0,
		blueRobot,
		redRobot,
		border,
		line,
		ball,
		skyblueGoal,
		yellowGoal,
		unknown,
		numberOfPointTypes
	};

	enum FIELD_STATES{
		START = 0,
		FOUND_WHITE,
		FOUND_FIELD,
		FOUND_BORDER,
		LINE_IN,
		LINE_OUT,
		YELLOW_GOAL,
		YELLOW_FINISHED,
		SKYBLUE_GOAL,
		SKYBLUE_FINISHED,
		FOUND_RED_ROBOT,
		FOUND_BLUE_ROBOT,
		FINISHED_BLUE_ROBOT,
		FINISHED_RED_ROBOT,
		FOUND_BALL,
		FINISHED_BALL,
		FOUND_UNKNOWN,
		FINISHED_UNKNOWN
	};
	
  /** Constructor */
  RFieldStateMachine();

  /** Destructor */
  ~RFieldStateMachine();

  void update(int x,int y,MSH2004EdgeDetection& scanner);

  void reset(int x,int y);

  inline Vector2<int> getEdge(int index){
	return edgeBuffer[index];
  }

  inline PointTypes getType(int index){
	return types[index];
  }

  inline int size(){
	return numberOfEdges;
  }

  inline bool foundObstacle(){
	return obstacleNearPoint != -1 && obstacleFarPoint != -1;
  }

  inline Vector2<int>& nearPoint(){
	return edgeBuffer[obstacleNearPoint];
  }

  inline Vector2<int>& farPoint(){
	return edgeBuffer[obstacleFarPoint];
  }

  inline ObstaclesPercept::ObstacleType getObstacleType(){
	  switch (types[obstacleFarPoint]){
	  case blueRobot: 
		  if(getPlayer().getTeamColor() == Player::blue) 
		      return ObstaclesPercept::teammate;
		  else
			  return ObstaclesPercept::opponent;
		  
	  case redRobot:
		  if(getPlayer().getTeamColor() == Player::red)
		      return ObstaclesPercept::teammate;
		  else
			  return ObstaclesPercept::opponent;
	  case border:    return ObstaclesPercept::border;
	  case yellowGoal: return ObstaclesPercept::goal;
	  case skyblueGoal: return ObstaclesPercept::goal;
	  case unknown: return ObstaclesPercept::unknown;
	  default: return ObstaclesPercept::unknown;		  
	  }
  }

private :

  void findNextState();
  void executeState();
	
/*
  PointTypes foundType;
  bool detectedObject;	 

  bool foundWhite;
  bool foundField;
  bool foundBorder;
  bool foundLine;
  bool foundBall;
  bool foundSkyblueGoal;
  bool foundYellowGoal;
  bool foundRedRobot;
  bool foundBlueRobot;
  bool foundFinalPoint;
  bool foundOtherThanGreen;
  bool greenThisTime;
*/

  colorClass color;

  int range;
  int rangeSum;
  int greenRange;
  int whiteRange;
  int grayRange;

  bool isUnknownBot;
/*  int determinedEdge;
  bool hasDeterminedEdge;
  bool lastEdgeBelongedToObject;*/

  Vector2<int> edgeBuffer[20];
  Vector2<int> start;
  PointTypes types[20];
  FIELD_STATES state;
  int numberOfEdges;

  int obstacleFarPoint;
  int obstacleNearPoint;

};

#endif   //  _RFieldStateMachine_h_

/*
* Change log :
* 
*	$Log: RFieldStateMachine.h,v $
*	Revision 1.3  2004/05/25 13:27:33  schmidtb
*	modified version of rip for open-challenge
*	
*	Revision 1.2  2004/03/25 15:29:04  pg_besc
*	made some changes
*	
*	Revision 1.1  2004/03/17 22:12:39  schmidtb
*	established RFieldStateMachine
*	
*
*/
