
// REnemySpecialist.h: Schnittstelle fr die Klasse REnemySpecialist.
//
//////////////////////////////////////////////////////////////////////

#ifndef RENEMYSPECIALIST_H
#define RENEMYSPECIALIST_H


#include "RasterSpecialist.h"
#include "Tools/Math/Geometry.h"
#include <vector>
#include "Tools/Math/Vector2.h"
#include "RasterStrategy.h"
#include "RasterImageProcessor.h"
#include "Modules/ImageProcessor/ImageProcessor.h"


class REnemySpecialist :public RasterSpecialist
{
typedef const unsigned char* I_Pin;

public:
	REnemySpecialist(RasterImageProcessor &processor,RasterStrategy &strat);
	virtual ~REnemySpecialist();
	void invokeOnPostScan(int x, int y);	
	void executePostProcessing();
	void invokeOnPreScan(int x,int y);
	virtual int getType();
	virtual void init();
	Vector2<int> calculateFarestPoint(std::list<LinePair> enemyLines);
	Vector2<int> calculateFarestPointCOG(int numberOfFootPoints,std::list<LinePair> enemyLines);
	Vector2<int> calculateFarestPointFastCOG(std::list<LinePair> enemyLines);
  	Vector2<int> calculatePointOnFieldFromSegment(std::list<LinePair> enemyLines);

	int   maximums[2];
	int   maxCountSum;
	int   countSum;
	int   max;
	int	  rasterWidth;
	int	  rasterHeight;
	
private:
	static void sort(int footPointDistance[], Vector2<double> footPoint[], const int& start, const int& end);
	inline bool isCross(const LinePair& horizontal,const LinePair vertical)
        {
		return horizontal.v1.x <= vertical.v1.x 
			&& horizontal.v2.x >= vertical.v1.x
			&& vertical.v2.y <= horizontal.v1.y 
			&& vertical.v1.y >= horizontal.v1.y;
	}
	RasterStrategy *strategy;	
	std::vector<RasterSpecialist::LinePair> columns;	
	std::vector<RasterSpecialist::LinePair> lines; 	
	Vector2< int> tempP;
        Geometry::Line horizon; /**< The horizon. */

	int leftBorderOfNewLp;	
};

#endif







/*
* Change log :
* 
* $Log: REnemySpecialist.h,v $
* Revision 1.17  2004/03/12 10:11:58  neubach
* - added alternative footpointCalculation
*
* Revision 1.16  2004/03/01 11:00:18  neubach
* - removed Debug-Outputs
* - beautified Code
* - faster 2 PointApproximation
*
* Revision 1.15  2004/02/10 17:01:50  koh
* removed #ifdef TrikotErkennung,
* enemySpecialist recognizes black color now
*
* Revision 1.14  2004/02/03 23:09:18  hyung
* Array based on rasterWidth now
*
* ! somehow it seems that my code produces warnings for which I'm
* very very sorry, but my compiler told me always 0 errors, 0 warnings....
* does somebody know the reason?
*
* Revision 1.13  2004/02/03 21:35:31  kerdels
* warnings removed
*
* Revision 1.12  2004/02/03 21:18:27  hyung
* some minor changes,
*
* size of Segmentborder-Array (TrikotErkennung) basically adaptive to rip-resolution
*
* Revision 1.11  2004/02/02 10:47:39  neubach
* - removed Warnings
* - added calculateFarestPointCOG-Method, which improves approximation of EnemyPositions via Center of Gravity Method for n footPoints
*
* Revision 1.10  2004/01/31 11:45:02  hyung
* modified enemyValidity-calculation;
* established basical enviroment for TrikotErkennung, based on Arrays and Lists, changes will take affect only #ifdef TrikotErkennung!
*
* Revision 1.9  2004/01/23 10:40:53  neubach
* - freezed alternative "Trikoterkennung" and other cosmetic changes
*
* Revision 1.8  2004/01/23 10:13:17  neubach
* - ball should no longer be misinterpreted as enemy
*
* Revision 1.7  2004/01/21 03:25:36  hyung
* TrikotErkennung update
*
* Revision 1.6  2004/01/16 09:08:42  neubach
* - support for processing >1 enemy-segments (buggy)
*
* Revision 1.5  2004/01/07 10:21:57  neubach
* - prepared code for processing >1 segments
*
* Revision 1.4  2003/12/16 10:29:17  neubach
* - added calculation of farest point (from horizon) for a playerSegment
* - added conversion point on cameraPicture -> point on Field
*
* Revision 1.3  2003/12/15 13:55:32  schmidtb
* Merged and patched new version of RasterImageProcessor.
*
* Revision 1.2  2003/12/08 15:02:55  schmidtb
* new version of RIP
*
*
*
*/


