// REnemySpecialist.cpp: Implementierung der Klasse REnemySpecialist.
//																														
//////////////////////////////////////////////////////////////////////      						
#include "REnemySpecialist.h"																				
#include <algorithm>																							
#include <stdlib.h>																								
#include <time.h>																								
#include <list>																											
#include <bitset>																							
#include "Tools/RingBuffer.h"														
using namespace std;

typedef list<list<RasterSpecialist::LinePair> > SegmentList;
																															
//////////////////////////////////////////////////////////////////////																
// Konstruktion/Destruktion																							
//////////////////////////////////////////////////////////////////////

REnemySpecialist::REnemySpecialist(RasterImageProcessor &processor,RasterStrategy &strat):
	RasterSpecialist(processor),lines(200),columns(30)
{
		strategy = &strat;
		preScanNeeded = true;
		postScanNeeded = true;
		rasterWidth = rip->rasterWidth;
		rasterHeight = rip->rasterHeight;
		// OUTPUT(idText,text,"RasterWidth = "<< rasterWidth << ", RasterHeight = " << rasterHeight);
}

REnemySpecialist::~REnemySpecialist()
{
}

void REnemySpecialist::executePostProcessing()
{
	if (lines.size()==0) // keine linePairs? => keine Gegner...
	return; // also auch keine Segmentierung ntig

	// segment image first (each segment is a list of LinePairs)
	// Konvertierung von vector<LinePair> nach list<LinePair>   
	vector<list<LinePair> > v;
	list<LinePair> linesList;

	vector<LinePair>::iterator ite = lines.begin();
	while(ite != lines.end()){
	  linesList.push_back(*ite);
	  ite++;
	}

	// list<LinePair> linesList jetzt gefllt mit Werten aus vector<LinePair> lines	
        createSegmentsFromLines2(linesList,v,-2,6);
	// in  vector<list<LinePair>> v stehen jetzt Segmente als Listen von LinePairs

      for (unsigned s = 0; s < v.size();s++) { // Schleife ber Segmente
	  //OUTPUT(idText,text,"processing segment number "<< s);
	  // calculateValidity
      int counterRed=0;
	  int counterBlue=0;
	  int counterGray=0;
	  int counterOrange=0;
	  
	  list <LinePair>::iterator it = v[s].begin();

	  
	  // Preprocessing zur spteren Berechnung der enemyValidity bzw. zur Entscheidung ob Daten berhaupt gut genug fr Percept
	  while(it != v[s].end())
	  {
         LinePair b = *it;
		 for (unsigned i=1;i<10;i++) {
	           if (getColorFromRaster(b.v1.x+((b.v2.x-b.v1.x)*i)/10,b.v1.y)==red)
			   {
			      //DOT(imageProcessor_obstacles,b.v1.x+((b.v2.x-b.v1.x)*i)/10,b.v1.y,Drawings::ps_solid, Drawings::pink);
			      counterRed++;
			   }
			   else
			   if (getColorFromRaster(b.v1.x+((b.v2.x-b.v1.x)*i)/10,b.v1.y)==gray)
			   {
			      counterGray++;
			   }
			   else
			   if (getColorFromRaster(b.v1.x+((b.v2.x-b.v1.x)*i)/10,b.v1.y)==blue)
			   {
			       //DOT(imageProcessor_obstacles,b.v1.x+((b.v2.x-b.v1.x)*i)/10,b.v1.y,Drawings::ps_solid, Drawings::skyblue);
				   counterBlue++;
			   }
			   else
			   if (getColorFromRaster(b.v1.x+((b.v2.x-b.v1.x)*i)/10,b.v1.y)==orange)
			   {
			       counterOrange++;
			   }
		 }
		 it++;
	  }
      // Entscheidung basierend auf counters, ob Daten gut genug fr ein PlayerPercept
	  if (((counterOrange<counterBlue)||(counterOrange<counterRed))&&((counterRed>=2)||(counterBlue>=2))&&(v[s].size()>3)) // zuviel Orange im Segment? oder berhaupt keine Trikots erkannt? => dann generiere auch keine Percepts
      {
    	 // calculateFarestPoint: berechnet entferntesten Punkt eines Segments zum Horizont
	     Vector2<int> pointOnField=calculateFarestPointFastCOG(v[s]);  // 2-Point Approximation via COG
    	 // Vector2<int> pointOnField=calculatePointOnFieldFromSegment(v[s]); // according to Ingo
		 // generate percept
         Vector2<int> np;
		 np.x=0;
		 np.y=0;
		 SinglePlayerPercept percept;
	     percept.offset.x=pointOnField.x;
	     percept.offset.y=pointOnField.y;
	     double enemyValidity;
		 double enemyValidity2;
	     if (counterRed>counterBlue)
		 {
	       enemyValidity=(double)(counterRed+counterGray)/((v[s].size()*9)+counterBlue);
		   if ((Geometry::distance(np,pointOnField)>2000)&&(Geometry::distance(np,pointOnField)<5500))
		   {
			 enemyValidity2=(double)((-1)*(Geometry::distance(np,pointOnField)-2000)/5500+0.64);
			 enemyValidity=(double)enemyValidity*enemyValidity2*enemyValidity2;

		   }
		   else 
		   if (Geometry::distance(np,pointOnField)<=2000)
			 enemyValidity=(double)(enemyValidity*((-1)*(Geometry::distance(np,pointOnField))/8000+1));
		   else
           if (Geometry::distance(np,pointOnField)>=5500)
             enemyValidity=(double)(enemyValidity/100);
           
		   //enemyValidity=(double)(enemyValidity*((counterRed-counterBlue)/counterRed)); // vermindere Validitt wenn viele Pixel mit Gegenfarbe im Segment gefunden werden
		   percept.validity=enemyValidity;
	       //OUTPUT(idText,text,"Distance to Player: "<< Geometry::distance(np,pointOnField));
		   //OUTPUT(idText,text,"CounterRed: "<< counterRed);
		   //OUTPUT(idText,text,"CounterGray: "<< counterGray);
           //OUTPUT(idText,text,"CounterBlue: "<< counterBlue);
		   //OUTPUT(idText,text,"CounterOrange: "<< counterOrange);
		   //OUTPUT(idText,text,"LinesSize: "<< v[s].size());
		   //OUTPUT(idText,text,"EnemyValidity: "<< enemyValidity);
		   rip->playersPercept.addRedPlayer(percept);

		 }
		 else
	     if (counterBlue>counterRed)	     
		 {
           enemyValidity=(double)(counterBlue+counterGray)/((v[s].size()*9)+counterRed);
		   if ((Geometry::distance(np,pointOnField)>2000)&&(Geometry::distance(np,pointOnField)<5500))
		   {
			 enemyValidity2=(double)((-1)*(Geometry::distance(np,pointOnField)-2000)/5500+0.64);
			 enemyValidity=(double)enemyValidity*enemyValidity2*enemyValidity2;

		   }
		   else 
		   if (Geometry::distance(np,pointOnField)<=2000)
			 enemyValidity=(double)(enemyValidity*((-1)*(Geometry::distance(np,pointOnField))/8000+1));
		   else
           if (Geometry::distance(np,pointOnField)>=5500)
             enemyValidity=(double)(enemyValidity/100);
           //enemyValidity=(double)(enemyValidity*((counterBlue-counterRed)/counterBlue)); // vermindere Validitt wenn viele Pixel mit Gegenfarbe im Segment gefunden werden
           percept.validity=enemyValidity;
		   //OUTPUT(idText,text,"Distance to Player: "<< Geometry::distance(np,pointOnField));
		   //OUTPUT(idText,text,"CounterRed: "<< counterRed);
		   //OUTPUT(idText,text,"CounterGray: "<< counterGray);
           //OUTPUT(idText,text,"CounterBlue: "<< counterBlue);
		   //OUTPUT(idText,text,"CounterOrange: "<< counterOrange);
		   //OUTPUT(idText,text,"LinesSize: "<< v[s].size());
		   //OUTPUT(idText,text,"EnemyValidity: "<< enemyValidity);
		   rip->playersPercept.addBluePlayer(percept);
		 }
		 else
	     if (counterBlue==counterRed)
		 {
			 // generiere keinen Percept (weil Daten zu ungenau)
		 }
	  }
	}
  
}


void REnemySpecialist::invokeOnPreScan(int x,int y){
	if (!strategy->insidePlayer) tempP = getVecFromRaster(x,y); //get BildKoordinate vom RasterPunkt x,y
	else{
		LinePair lp(tempP,getVecFromRaster(x,y));
		
		if ((lp.v2.x - lp.v1.x) < 5)
			return;

		lines.push_back(lp);			
		LINE(imageProcessor_obstacles,
			lp.v1.x,lp.v1.y, lp.v2.x,lp.v2.y, 
			0.5, Drawings::ps_solid, Drawings::white);
		DOT(imageProcessor_obstacles, lp.v2.x, lp.v2.y,
			Drawings::pink, Drawings::green);
	}
}


void REnemySpecialist::invokeOnPostScan(int x,int y)
{	
	if (!strategy->insidePlayer) tempP = getVecFromRaster(x,y);
	else{
		LinePair lp(tempP,getVecFromRaster(x,y));
		lines.push_back(lp);
			
		LINE(imageProcessor_obstacles,
			lp.v1.x,lp.v1.y, lp.v2.x,lp.v2.y, 
			0.5, Drawings::ps_solid, Drawings::white);			
		DOT(imageProcessor_obstacles, lp.v2.x, lp.v2.y, 
			Drawings::pink, Drawings::green);
	}
}

int REnemySpecialist::getType()
{
	return __REnemySpecialist;	
}

Vector2<int> REnemySpecialist::calculateFarestPoint(std::list<LinePair> enemyLines)
{	
        Vector2<int> pointOnField;
	horizon = rip->getHorizon();
	Vector2<double> iPoint, maxPoint;
	list <LinePair>::iterator itmax = enemyLines.begin();
	list <LinePair>::iterator it1 = enemyLines.begin();
	LinePair b=*it1;
	LinePair bmax=*itmax;
	if (horizon.direction.y>0)
        { // berechnet, ob Horizont steigt(/)<0 oder fllt(\)>0 als Fallunterscheidung zur Effizienzsteigerung
           //OUTPUT(idText,text,"Ascendency Awaits You: Horizon falls");
           while(it1 != enemyLines.end())
           {
	      b=*it1;
              bmax=*itmax;
	      iPoint.x=b.v1.x;
	      iPoint.y=b.v1.y;
              maxPoint.x=bmax.v1.x;
              maxPoint.y=bmax.v1.y;
              if (Geometry::getDistanceToLine(horizon,iPoint)<Geometry::getDistanceToLine(horizon, maxPoint))
              { // < weil Entfernungen unterhalb des Horizonts negativ, deshalb Punkte oberhalb des Horizonts hier nicht reingeben!
		 itmax=it1;
	         bmax=b;
              }
              it1++;
	   }
	   DOT(imageProcessor_obstacles, bmax.v1.x,bmax.v1.y,Drawings::ps_solid, Drawings::yellow);  // zeichnet den entferntesten Punkt pink ein
	   Geometry::calculatePointOnField(bmax.v1.x,bmax.v1.y,(rip->cameraMatrix),rip->image.cameraInfo,pointOnField); // der entfernteste Punkt vom Horizont im Kamerabild wird Punkt auf Spieldfeld relativ zum Robot zugeordnet 
	} 
	else
        { // Fall Horizont steigt (/)
           //OUTPUT(idText,text,"Horizon rises (/)");
	   while(it1 != enemyLines.end())
	   {
              b=*it1;
              bmax=*itmax;
	      iPoint.x=b.v2.x;
	      iPoint.y=b.v2.y;
              maxPoint.x=bmax.v2.x;
	      maxPoint.y=bmax.v2.y;
              if (Geometry::getDistanceToLine(horizon,iPoint)<Geometry::getDistanceToLine(horizon, maxPoint))
              { // < weil Entfernungen unterhalb des Horizonts negativ, deshalb Punkte oberhalb des Horizonts hier nicht reingeben!
		 itmax=it1;
		 bmax=b;
	      }
              it1++;
	   }
           DOT(imageProcessor_obstacles, bmax.v2.x,bmax.v2.y,Drawings::ps_solid, Drawings::yellow);  // zeichnet den entferntesten Punkt pink ein
	   Geometry::calculatePointOnField(bmax.v2.x,bmax.v2.y,(rip->cameraMatrix),rip->image.cameraInfo,pointOnField); // der entfernteste Punkt vom Horizont im Kamerabild wird Punkt auf Spieldfeld relativ zum Robot zugeordnet 
        }
        //OUTPUT(idText,text,"pointOnField: x: " << pointOnField.x << "y: " << pointOnField.y);
        // pointOnField ist nun eine Approximation des Punktes, wo der Gegner auf dem Spielfeld steht (relativ zum Robot)
        return (pointOnField);
}

void REnemySpecialist::sort(int footPointDistance[], Vector2<double> footPoint[], const int& start, const int& end)
{
  if (start == end)
  {
    return;
  }
  int pivot = footPointDistance[(start+end)/2];
  int left = start;
  int right = end;
  do
  {
    while (footPointDistance[left] < pivot)
    {
      left++;
    }
    while (footPointDistance[right] > pivot)
    {
      right--;
    }
    if (left < right)
    {
       int tmp = footPointDistance[left];
       Vector2<double> tmp2 = footPoint[left];
       footPointDistance[left] = footPointDistance[right];
       footPoint[left] = footPoint[right];
       footPointDistance[right] = tmp;
       footPoint[right] = tmp2;
    }
    if (left <= right)
    {
       left++;
       right--;
    }
  } while (left <= right);
  if (start < right)
  {
     sort(footPointDistance, footPoint, start, right);
  }
  if (end > left)
  {
     sort(footPointDistance, footPoint, left, end);
  }
}


Vector2<int> REnemySpecialist::calculateFarestPointFastCOG(std::list<LinePair> enemyLines)
{	
        int numberOfFootPoints=2;
	int footPointDistance [500];
        Vector2<double> footPoint[500]; // enemyLines.size()*2, bei erhhter Auflsung eventuell Array vergrern
	Vector2<int> pointsOnField[2]; // number of footpoints
	Vector2<int> pointOnField;
	horizon = rip->getHorizon();
	Vector2<double> point1,point2,maxPoint;
	list <LinePair>::iterator itmax = enemyLines.begin();
	list <LinePair>::iterator it1 = enemyLines.begin();
	LinePair b=*it1;
	LinePair bmax=*itmax;
	int i=0;
	// flle Arrays mit Daten
	while(it1 != enemyLines.end())
        {
          b=*it1;
          point1.x=b.v1.x;
	  point1.y=b.v1.y;
          point2.x=b.v2.x;
	  point2.y=b.v2.y;
	  footPoint[i]=point1;
	  footPointDistance[i]=(int)Geometry::getDistanceToLine(horizon,footPoint[i]);
	  i++;
          footPoint[i]=point2;
	  footPointDistance[i]=(int)Geometry::getDistanceToLine(horizon,footPoint[i]);
	  i++;
	  it1++;
	}
        // sucht 2 entfernteste Punkte
        for (unsigned l = 0; l < (unsigned)numberOfFootPoints;l++)
    	{
          for (unsigned m = l+1; m < (unsigned)(enemyLines.size()*2-1);m++)
          {
              if (footPointDistance[m]<footPointDistance[l])           
              { 
                // swap
                int tmp = footPointDistance[m];
                Vector2<double> tmp2 = footPoint[m];
                footPointDistance[m] = footPointDistance[l];
                footPoint[m] = footPoint[l];
                footPointDistance[l] = tmp;
                footPoint[l] = tmp2;
              }
          }
        }
        // 2 entfernteste footPoints stehen nun vorne im Array
        for (unsigned g = 0; g < (unsigned)numberOfFootPoints;g++)
	{
           DOT(imageProcessor_obstacles, footPoint[g].x,footPoint[g].y,Drawings::ps_solid, Drawings::yellow); // zeichnet Fupunkte ein
	   Geometry::calculatePointOnField((int)footPoint[g].x,(int)footPoint[g].y,(rip->cameraMatrix),rip->image.cameraInfo,pointOnField);
	   pointsOnField[g]=pointOnField;
	}
        // pointsOnFieldArray enthlt nun geordnet die FeldPunkte, die zu den entferntesten footPoints zum Horizont gehren
	// bestimme Approximation nach COG
	pointOnField.x=0;
	pointOnField.y=0;
	for (unsigned f = 0; f < (unsigned)(numberOfFootPoints);f++)
	{
	  pointOnField.x=pointOnField.x+pointsOnField[f].x;
	  pointOnField.y=pointOnField.y+pointsOnField[f].y;
	}
        pointOnField.x=pointOnField.x/numberOfFootPoints;
        pointOnField.y=pointOnField.y/numberOfFootPoints;
        //OUTPUT(idText,text,"pointOnField approximiert nach COG: x: " << pointOnField.x << "y: " << pointOnField.y);
	// pointOnField ist nun eine Approximation des Punktes, wo der Gegner auf dem Spielfeld steht (relativ zum Robot)
	return (pointOnField);
}

Vector2<int> REnemySpecialist::calculateFarestPointCOG(int numberOfFootPoints, std::list<LinePair> enemyLines)
{	
        if (enemyLines.size()<4) // besser weniger FootPoints bei kleinen Segmenten
	{   
          numberOfFootPoints=1;
          //OUTPUT(idText,text,"numberOfFootPoints angepasst!");
	}
	if ((unsigned)numberOfFootPoints>=enemyLines.size()) // fange Probleme durch zu viele Footpoints bei zu kleinen Segmenten ab
	{   
	  numberOfFootPoints=enemyLines.size();
          //OUTPUT(idText,text,"numberOfFootPoints zu hoch!");
	}
	int footPointDistance [500];
        Vector2<double> footPoint[500]; // enemyLines.size()*2
	Vector2<int> pointsOnField[20]; // number of footpoints
	Vector2<int> pointOnField;
	horizon = rip->getHorizon();
	Vector2<double> point1,point2,maxPoint;
	list <LinePair>::iterator itmax = enemyLines.begin();
	list <LinePair>::iterator it1 = enemyLines.begin();
	LinePair b=*it1;
	LinePair bmax=*itmax;
	int i=0;
	// flle Arrays mit Daten
	while(it1 != enemyLines.end())
        {
           b=*it1;
           point1.x=b.v1.x;
	   point1.y=b.v1.y;
           point2.x=b.v2.x;
	   point2.y=b.v2.y;
	   footPoint[i]=point1;
	   footPointDistance[i]=(int)Geometry::getDistanceToLine(horizon,footPoint[i]);
           i++;
           footPoint[i]=point2;
	   footPointDistance[i]=(int)Geometry::getDistanceToLine(horizon,footPoint[i]);
	   i++;
	   it1++;
	}
        // sortiert Punkte nach Abstand zum Horizont mittels QuickSort
	sort(footPointDistance,footPoint,0,enemyLines.size()*2-1);
        // footPoints nun geordnet nach Abstand zum Horizont
        for (unsigned g = 0; g < (unsigned)numberOfFootPoints;g++)
	{
           DOT(imageProcessor_obstacles, footPoint[g].x,footPoint[g].y,Drawings::ps_solid, Drawings::yellow); // zeichnet Fupunkte ein
	   Geometry::calculatePointOnField((int)footPoint[g].x,(int)footPoint[g].y,(rip->cameraMatrix),rip->image.cameraInfo,pointOnField);
	   pointsOnField[g]=pointOnField;
	}
        // pointsOnFieldArray enthlt nun geordnet die FeldPunkte, die zu den entferntesten footPoints zum Horizont gehren
    	// bestimme Approximation nach COG
	pointOnField.x=0;
	pointOnField.y=0;
	for (unsigned f = 0; f < (unsigned)(numberOfFootPoints);f++)
	{
           pointOnField.x=pointOnField.x+pointsOnField[f].x; 
           pointOnField.y=pointOnField.y+pointsOnField[f].y;
	}
        pointOnField.x=pointOnField.x/numberOfFootPoints;
        pointOnField.y=pointOnField.y/numberOfFootPoints;
        //OUTPUT(idText,text,"pointOnField approximiert nach COG: x: " << pointOnField.x << "y: " << pointOnField.y);
        // pointOnField ist nun eine Approximation des Punktes, wo der Gegner auf dem Spielfeld steht (relativ zum Robot)
	return (pointOnField);
}


Vector2<int> REnemySpecialist::calculatePointOnFieldFromSegment(std::list<LinePair> enemyLines)
{	
    Vector2<int> pointOnField;
	double maxY,maxY2,leftX,rightX,pointOnPictureX,pointOnPictureY;
	list <LinePair>::iterator it1 = enemyLines.begin();
	LinePair b=*it1;

        // Berechne leftX und rightX und maxY
        b=*it1;
        leftX=b.v1.x;
        rightX=b.v2.x;
        maxY=b.v1.y; // v1.y und v2.y sind sowieso gleich
        maxY2=b.v1.y;
        while(it1 != enemyLines.end())
        {
	      b=*it1;
	      if (leftX>b.v1.x)
              { 
		 leftX=b.v1.x;
              }
              if (rightX<b.v2.x)
              { 
		 rightX=b.v2.x;
              }
              if (maxY<b.v1.y)
              { 
                 maxY2=maxY;
		 maxY=b.v1.y;
              }
              it1++;
        }

        pointOnPictureX=(leftX+rightX)/2;
        //pointOnPictureY=(maxY+maxY2)/2; 
        pointOnPictureY=maxY; //alternative2
        DOT(imageProcessor_obstacles, pointOnPictureX,pointOnPictureY,Drawings::ps_solid, Drawings::yellow);  // zeichnet PointOnPicture ein
        // ordne PointOnPicture Punkt auf Spieldfeld relativ zum Robot zu
        Geometry::calculatePointOnField((int)pointOnPictureX,(int)pointOnPictureY,(rip->cameraMatrix),rip->image.cameraInfo,pointOnField);
        //OUTPUT(idText,text,"pointOnField: x: " << pointOnField.x << "y: " << pointOnField.y);
        // pointOnField ist nun eine Approximation des Punktes, wo der Gegner auf dem Spielfeld steht (relativ zum Robot)
        return (pointOnField);
}

void REnemySpecialist::init()
{	
        postScanNeeded = false;
	preScanNeeded = true;
	if (!columns.empty())columns.clear();
	if (!lines.empty())lines.clear();
}












/*
* Change log :
* 
* $Log: REnemySpecialist.cpp,v $
* Revision 1.50  2004/05/25 13:27:33  schmidtb
* modified version of rip for open-challenge
*
* Revision 1.49  2004/03/25 15:29:04  pg_besc
* made some changes
*
* Revision 1.47  2004/03/12 10:35:51  neubach
* - removed debug-outputs
* - approximation via 2 farest points active
*
* Revision 1.46  2004/03/12 10:11:58  neubach
* - added alternative footpointCalculation
*
* Revision 1.45  2004/03/11 13:01:14  neubach
* - FineTuning
*
* Revision 1.44  2004/03/09 09:43:47  neubach
* - fineTuning
*
* Revision 1.43  2004/03/08 10:45:08  neubach
* - removed debug-outputs
*
* Revision 1.42  2004/03/08 09:43:23  neubach
* - reintroduced old enemyValidity-Calculation
*
* Revision 1.41  2004/03/01 11:00:18  neubach
* - removed Debug-Outputs
* - beautified Code
* - faster 2 PointApproximation
*
* Revision 1.40  2004/02/26 14:31:32  schmidtb
* comment some outputs
*
* Revision 1.39  2004/02/18 14:56:19  neubach
* new Segmentation established, code not cleared at all
*
* Revision 1.38  2004/02/13 20:15:10  koh
* black Color also influences validation now
*
* Revision 1.37  2004/02/10 17:01:50  koh
* removed #ifdef TrikotErkennung,
* enemySpecialist recognizes black color now
*
* Revision 1.36  2004/02/04 23:19:38  schmidtb
* debugged and added calculation for angles to BoxSpecialist
*
* Revision 1.35  2004/02/03 23:09:18  hyung
* Array based on rasterWidth now
*
* ! somehow it seems that my code produces warnings for which I'm
* very very sorry, but my compiler told me always 0 errors, 0 warnings....
* does somebody know the reason?
*
* Revision 1.34  2004/02/03 21:28:47  hyung
* more minor changes
*
* Revision 1.33  2004/02/03 21:18:27  hyung
* some minor changes,
*
* size of Segmentborder-Array (TrikotErkennung) basically adaptive to rip-resolution
*
* Revision 1.32  2004/02/03 10:41:34  neubach
* - bug found (see diff)
*
* Revision 1.31  2004/02/03 10:17:33  neubach
* - minor changes
*
* Revision 1.30  2004/02/02 10:47:40  neubach
* - removed Warnings
* - added calculateFarestPointCOG-Method, which improves approximation of EnemyPositions via Center of Gravity Method for n footPoints
*
* Revision 1.29  2004/02/02 00:21:03  hyung
* some validity changes here and there
*
* Revision 1.28  2004/02/01 12:45:00  hyung
* modified Player Validity (creates obstacle percept now, if result of segment-preprocessing not sure)
*
* Revision 1.27  2004/02/01 02:53:48  hyung
* enemy Validity much faster and recognizes blue or red coherent areas now due to dynamical color count.
* new calculation of the perceptvalidity
* if ball fills screen totally and is segmented red due to low brightness it wont be recognized such as one yet!
*
* Revision 1.25  2004/01/31 13:46:13  hyung
* modified bluePlayerValidity-calculation;
*
* Revision 1.24  2004/01/31 11:45:02  hyung
* modified enemyValidity-calculation;
* established basical enviroment for TrikotErkennung, based on Arrays and Lists, changes will take affect only #ifdef TrikotErkennung!
*
* Revision 1.23  2004/01/27 11:12:10  neubach
* - enemyValidity also based on distances now
*
* Revision 1.21  2004/01/23 10:40:53  neubach
* - freezed alternative "Trikoterkennung" and other cosmetic changes
*
* Revision 1.20  2004/01/23 10:13:17  neubach
* - ball should no longer be misinterpreted as enemy
*
* Revision 1.19  2004/01/21 03:25:36  hyung
* TrikotErkennung update
*
* Revision 1.18  2004/01/20 12:12:25  neubach
* - dropped segments consisting of <=2 LinePairs
*
* Revision 1.17  2004/01/19 12:47:42  hyung
* #ifDef TrikotErkennung mit alternativem Einstiegspunkt fr Gegnererkennung
*
* Revision 1.16  2004/01/19 11:48:37  neubach
* - improved enemyValidity
*
* Revision 1.15  2004/01/16 09:17:56  neubach
* - removed bug, looks promising, but segmentation could be better in certain cases :(
*
* Revision 1.14  2004/01/16 09:08:42  neubach
* - support for processing >1 enemy-segments (buggy)
*
* Revision 1.13  2004/01/12 12:00:13  neubach
* - changed criteria for boolean isNewPoint, ERS 7 Aibos wont have gray color
*
* Revision 1.12  2004/01/12 11:39:33  neubach
* - improved enemyValidity
* - cut LinePairs above horizon
* - changed criteria for boolean isNewPoint
*
* Revision 1.11  2004/01/07 11:54:28  neubach
* - better debug info for validityCalculation
*
* Revision 1.10  2004/01/07 11:15:07  neubach
* - added enemyValidity
* - added recognition of red and blue players
*
* Revision 1.9  2004/01/07 10:21:57  neubach
* - prepared code for processing >1 segments
*
* Revision 1.8  2003/12/17 16:39:14  schmidtb
* New version
*
* Revision 1.7  2003/12/16 13:45:28  roefer
* Warnings removed
*
* Revision 1.6  2003/12/16 12:05:46  neubach
* - added perception of red player
*
* Revision 1.5  2003/12/16 10:29:17  neubach
* - added calculation of farest point (from horizon) for a playerSegment
* - added conversion point on cameraPicture -> point on Field
*
* Revision 1.4  2003/12/15 13:55:32  schmidtb
* Merged and patched new version of RasterImageProcessor.
*
* Revision 1.3  2003/12/08 15:02:55  schmidtb
* new version of RIP
*
*
*
*/



