/**
 * @file REnemyOnlySpecialist.h
 * 
 * This file contains the interface of REnemyOnlySpecialist.h for the RasterImageProcessor
 *
 * @author <a href="mailto:rookie_rocksta@web.de">Hyung-Won Koh</a>
 */																									
//////////////////////////////////////////////////////////////////////

#ifndef RENEMYONLYSPECIALIST_H
#define RENEMYONLYSPECIALIST_H

//#define fastestSegments

#include "RasterSpecialist.h"
#include "Tools/Math/Geometry.h"
#include <vector>
#include "Tools/Math/Vector2.h"
#include "RasterStrategy.h"
#include "RasterImageProcessor.h"
#include "Modules/ImageProcessor/ImageProcessor.h"


class REnemyOnlySpecialist :public RasterSpecialist
{
typedef const unsigned char* I_Pin;

public:
	int	  rasterWidth;
	int	  rasterHeight;	
	void executePostProcessing();	
	REnemyOnlySpecialist(RasterImageProcessor &processor,RasterStrategy &strat);
	virtual ~REnemyOnlySpecialist();
	//void invokeOnPostScan(int x, int y);	//not used for EnemyOnlySpecialist!
	void invokeOnPreScan(int x,int y, int enemyCtr);
	virtual int getType();
	virtual void init();
	/*
	//-------------------------------------------------------------------------------------------------
	//	nimmt k viele Lps aus dem Pool[50] zurck:
	inline void REnemyOnlySpecialist::removeLastLps(int k)
	{	
		if(k<=0)	{		return;	}
		else
		{
			lpCtr -=k;
			if(lpCtr <0)
				lpCtr =0;
		}
	}
	*/
private:
	RasterStrategy *strategy;	
	Geometry::Line horizon; /**< The horizon. */	
	//-------------------------------------------------------------------------------------------------
   // Vector2<int>  calculatePointOnFieldCOG(int numberOfFootPoints,Vector3<int> **segment, int seg, int *ctr);

	inline void adjustBorders(int start, int end, int seg)
	{
		if(start < end)
		{
			for(register int i = start; i<end; i++)
			{
				if(Borders[i] == 0)
					Borders[i] = seg;
				else
					break;				
				DOT(imageProcessor_obstacles, i*2,1, Drawings::black, Drawings::blue);
			}
			for(register int j = end; j> start; j--)
			{
				if(Borders[j] == 0)				
					Borders[j] = seg;
				else
					break;
				DOT(imageProcessor_obstacles, j*2,1, Drawings::black, Drawings::blue);
			}
		}
		else if(start > end)
		{
			for(register int i = start; i>end; i--)
			{
				if(Borders[i] ==0)
					Borders[i] = seg;
				else
					break;
				DOT(imageProcessor_obstacles, i*2,1, Drawings::black, Drawings::blue);
			}
			for(register int j = end; j < start; j++)
			{
				if(Borders[j] == 0)				
					Borders[j] = seg;
				else
					break;
				DOT(imageProcessor_obstacles, j*2,1, Drawings::black, Drawings::blue);
			}
		}		
	}
	//-------------------------------------------------------------------------------------------------
	inline void applyToBA(int left, int right)
		{
		Borders[left]++;
		Borders[right]--;
		}
	//-------------------------------------------------------------------------------------------------
	inline void initBA()
		{
		for(register int i = 0; i<=104; i++)	
			Borders[i]=0;	
		}

	//-------------------------------------------------------------------------------------------------
	//	adjusts an border-Borders if there were too many segments found!
	inline void format(int maxSegs)
		{
		for(register int i = 104; i>=0;i--)
		{
			if(Borders[i]==0)
				continue;
			else if (Borders[i]>maxSegs)
				Borders[i]=0;
			else if(Borders[i] <= maxSegs)
			{
				segCtr = Borders[i];
				return;
			}
		}
		}
	//-------------------------------------------------------------------------------------------------
	void finalize();
	//Vector2<int> getDualFootPoint(Vector2<int> **segment, int seg, int *ctr);

	bool inLp,
		*finished;

	int lpLength,
		left,
		borderCtr,
		segCtr,
		minSize,
		ignored,
		shadowThres,
		blackCtr,
		lpCtr,
		validFactor,
		minLpLength,
		Borders[105];


#ifdef fastestSegments	
	int *actualY;
#else 
	int *Ctr;
#endif

	Vector3<int> Segment[4][100];	
	Vector3<int> Pool[100];
	Vector3<int> Blacks[100];	
};

#endif

/*
* Change log :
* 
* $Log: REnemyOnlySpecialist.h,v $
* Revision 1.10  2004/03/17 17:01:14  koh
* calculating farest point to horizon now only by treating valid Line Pairs, others are ignored by now
* assuming y-value (height) of foot point by distance to horizon,
* x-value(width) of foot point by arithmetical middle of Line Pairs,
* introduced variables to modify percept-generating-behavior
*
* Revision 1.9  2004/03/05 12:48:10  neubach
* - multiple Point Approximation working with segment-arrays of type Vector3<int>[]
*
* Revision 1.8  2004/03/05 12:34:59  koh
* extended segment-arrays from Vector2<int>[] to Vector3<int>[]
* little changes in segmentation-method finalize();
* not final yet!
*
* Revision 1.7  2004/03/05 11:20:21  neubach
* - added PointOnField-Calculation via COG
*
* Revision 1.6  2004/03/03 18:59:48  koh
* changed adding blacks[p]
* not final yet!
*
* Revision 1.5  2004/03/02 13:14:22  roefer
* Warnings and errors removed
*
* Revision 1.4  2004/03/01 20:58:42  koh
* new strategy RFlexibleStrategy and new RasterSpecialist REnemyOnlySpecialist added
*
*
*
* commit log added
*
*
*/

