/**
 * @file REnemyOnlySpecialist.cpp
 * 
 * This file contains the implementation of REnemyOnlySpecialist.cpp for the RasterImageProcessor
 *
 * @author <a href="mailto:rookie_rocksta@web.de">Hyung-Won Koh</a>
 */																									
//////////////////////////////////////////////////////////////////////      						
#include "REnemyOnlySpecialist.h"																				
#include <algorithm>																							
#include <stdlib.h>																								
#include <time.h>																								
#include <list>																											
#include <bitset>																							
#include "Tools/RingBuffer.h"														
using namespace std;


//////////////////////////////////////////////////////////////////////																
// Konstruktion/Destruktion																							
//////////////////////////////////////////////////////////////////////

REnemyOnlySpecialist::REnemyOnlySpecialist(RasterImageProcessor &processor,RasterStrategy &strat):
	RasterSpecialist(processor)
{
		strategy = &strat;
		preScanNeeded = true;
		postScanNeeded = true;
		rasterWidth = rip->rasterWidth;
		rasterHeight = rip->rasterHeight;
		OUTPUT(idText,text,"RasterWidth = "<< rasterWidth << ", RasterHeight = " << rasterHeight);
		shadowThres = 2;
		minSize = 2;
		ignored = 1;
		validFactor = 2;	//	lpLength/ 2^(validFactor) = amount of needed enemyPixel to become a valid Lp
		minLpLength = 3;
}

REnemyOnlySpecialist::~REnemyOnlySpecialist()
{
}

void REnemyOnlySpecialist::executePostProcessing()
{
	if(lpCtr == 0)
	{
		OUTPUT(idText,text, "no enemy Lp found!");			
		return;
	}
	else
	{		
		
#ifndef fastestSegments

		OUTPUT(idText,text, " enemySpecialist-PostProcessing standart, get whole segment");			
		finalize();
		if(segCtr==0)
		{
			OUTPUT(idText,text, "no segments processed!");			
			return;
		}
		else if(segCtr>4)			//	there can be only 4
			format(4);

		lpCtr--;
		blackCtr--;			
		
		//to see finalized Borders[]
		for(register int a = 0; a<=104;a++)
		{
			if(Borders[a]==0)
			{
				DOT(imageProcessor_obstacles, a*2,1, Drawings::white, Drawings::black);
				continue;
			}
			if(Borders[a]==1)			
			{
				DOT(imageProcessor_obstacles, a*2,1, Drawings::white, Drawings::yellow);
				continue;
			}
			if(Borders[a]==2)
			{
				DOT(imageProcessor_obstacles, a*2,1, Drawings::white, Drawings::orange);
				continue;
			}
			if(Borders[a]==3)
			{
				DOT(imageProcessor_obstacles, a*2,1, Drawings::white, Drawings::red);
				continue;
			}
			if(Borders[a]==4)
			{
				DOT(imageProcessor_obstacles, a*2,1, Drawings::white, Drawings::pink);
				continue;
			}
			if(Borders[a]>4)
			{
				DOT(imageProcessor_obstacles, a*2,1, Drawings::white, Drawings::white);
				continue;
			}
			if(Borders[a]<0)
			{
				DOT(imageProcessor_obstacles, a*2,1, Drawings::black, Drawings::black);
				continue;
			}
		}
		
		/*
		Vector2<int> *segPointerArray[4];		//	array of Pointer to Vector2<int>-arrays
		for(register int s = 0; s < segCtr; s++)				//	init as much arrays as segments processed by finalize();
			segPointerArray[s] = new Vector2<int>[200];
		segment = segPointerArray;
		*/
		
		//	get first valid Lp
		while(Borders[Pool[lpCtr].x]==0 && lpCtr>0)
			lpCtr--;
				
		//init Ctr, Pointer...
		int ctr1=2;
		int ctr2=2;
		int ctr3=2;
		int ctr4=2;
		int segNo = Borders[Pool[lpCtr].x]-1;
		int actualY = Pool[lpCtr].y;
//	assigns the correct Lp-Counter of the segNo-th segment!
		if(segNo == 0)
			Ctr = &ctr1;
		else if(segNo == 1)
			Ctr = &ctr2;
		else if(segNo == 2)
			Ctr = &ctr3;
		else if(segNo == 3)
			Ctr = &ctr4;
		Segment[segNo][*Ctr].x=Pool[lpCtr].x;
		Segment[segNo][*Ctr].y= actualY;		
		DOT(imageProcessor_obstacles, Segment[segNo][*Ctr].x*rip->marginX,
			Segment[segNo][*Ctr].y*rip->marginY, Drawings::white, Drawings::red);
		(*Ctr)++;
		if(strategy->horFalls)		//	add only the most left LinePair of a Segment
		{				
			for(register int p = lpCtr-1;p>=0;p--)
			{
				if(Borders[Pool[p].x]==0)
				{
					OUTPUT(idText,text, "Borders[Pool["<<p<<"].x] = 0!, also wird dieses Lp nicht segmentiert");	
					continue;
				}
				else	//   1<= Borders[Pool[p].x <=4
				{
					if(	Borders[Pool[p].x]-1==segNo)	//	Point in same segment
					{
						if(Pool[p].y == actualY )						//	Point in same Line
						{
							Segment[segNo][*Ctr-1].x = Pool[p].x;								
							Segment[segNo][*Ctr-1].y = actualY;												
							DOT(imageProcessor_obstacles, Segment[segNo][*Ctr-1].x*rip->marginX,
								Segment[segNo][*Ctr-1].y*rip->marginY, Drawings::white, Drawings::red);
							continue;
						}
						else	//	Point in same segment but not same line
						{
							actualY = Pool[p].y;								
							Segment[segNo][*Ctr].x = Pool[p].x;								
							Segment[segNo][*Ctr].y = actualY;							
							DOT(imageProcessor_obstacles, Segment[segNo][*Ctr].x*rip->marginX,
								Segment[segNo][*Ctr].y*rip->marginY, Drawings::white, Drawings::red);
							(*Ctr)++;
							continue;
						}
					}		
					else		//	enter other segment on same Line
					{
						segNo = Borders[Pool[p].x]-1;
						if(segNo == 0)
							Ctr = &ctr1;
						else if(segNo == 1)
							Ctr = &ctr2;
						else if(segNo == 2)
							Ctr = &ctr3;
						else if(segNo == 3)
							Ctr = &ctr4;						
						Segment[segNo][*Ctr].x = Pool[p].x;
						Segment[segNo][*Ctr].y = actualY;						
						DOT(imageProcessor_obstacles, Segment[segNo][*Ctr].x*rip->marginX,
							Segment[segNo][*Ctr].y*rip->marginY, Drawings::white, Drawings::red);
						(*Ctr)++;
						continue;
					}
				}	//	close else Borders[]>0
			}	//	close for-cycle
		}
		else	//	if !strategy->horFalls..
		{
			for(register int p = lpCtr-1;p>=0;p--)
			{
				if(Borders[Pool[p].x]==0)
				{
					OUTPUT(idText,text, "Borders[Pool["<<p<<"].x] = 0!, also wird dieses Lp nicht segmentiert");	
					continue;
				}
				else	// Borders[Pool[p].x > 0
				{
					if(Borders[Pool[p].x]-1==segNo)							//	Point in same segment
					{
						if(Pool[p].y == actualY)												//	Point in same Line
						{
							continue;
						}
						else	//	Point in same segment but not same line
						{
							actualY = Pool[p].y;
							Segment[segNo][*Ctr].x= Pool[p].x;
							Segment[segNo][*Ctr].y= actualY;							
							DOT(imageProcessor_obstacles, Segment[segNo][*Ctr].x*rip->marginX,
								Segment[segNo][*Ctr].y*rip->marginY, Drawings::white, Drawings::red);
							(*Ctr)++;
							continue;
						}
					}
					else	//	enter other segment on same Line
					{
						segNo = Borders[Pool[p].x]-1;
						if(segNo == 0)
							Ctr = &ctr1;
						else if(segNo == 1)
							Ctr = &ctr2;
						else if(segNo == 2)
							Ctr = &ctr3;
						else if(segNo == 3)
							Ctr = &ctr4;							
						Segment[segNo][*Ctr].x = Pool[p].x;
						Segment[segNo][*Ctr].y = actualY;						
						DOT(imageProcessor_obstacles, Segment[segNo][*Ctr].x*rip->marginX,
							Segment[segNo][*Ctr].y*rip->marginY, Drawings::white, Drawings::red);
						(*Ctr)++;
						continue;
					}						
				}	//	close else Borders[]>0
			}	//	close for-cycle
		}	//	else !strategy-horFalls	

		//	colored-Lps are now assigned to segments here!***************************************************************		
		//	save special info like amount of assigned enemy-Color-Lps or allowed distance to first shadow Lp, 
		//	should be adaptive to horizon-distance..(not yet) or even check if green color between segment and Lp
		//	by now every black-Lp which is maximal 2 raster-lines below segment will be added!
		
		bool finished1 = true;
		bool finished2 = true;
		bool finished3 = true;
		bool finished4 = true;

		for(register int i = 0; i< segCtr; i++)
		{
			Segment[i][0].y = Segment[i][2].y;				//	deepest line for this segment
			OUTPUT(idText,text, "deepest Line for Segment " << (i+1)<<" = "<<Segment[i][2].y);			
			if(i== 0)
			{
				finished1 = false;
				Segment[i][0].x = ctr1-1;		//	position of last added colored Lp (= segment[segNo][segment[segNo][0].x]].x /.y)	and number of colored Lp +2 (may be needed for validation)					
				continue;
			}
			else if(i == 1)
			{
				finished2 = false;
				Segment[i][0].x = ctr2-1;
				continue;
			}
			else if(i == 2)
			{
				finished3 = false;
				Segment[i][0].y = ctr3-1;
				continue;
			}
			else if(i == 3)
			{
				finished4 = false;
				Segment[i][0].y = ctr4-1;
				continue;
			}
		}

		//add all found shadow Lp to segment-arrays now! *****************************************************************
		//	get first valid black-Lp
		while(Borders[Blacks[blackCtr].x]==0 && Borders[Blacks[blackCtr].z]==0 && blackCtr > 0 )		
			blackCtr--;
/*
		if(segCtr == 1)
		{
			finished2 = true;
			finished3 = true;
			finished4 = true;
		}
		else if(segCtr ==2)
		{
			finished3 = true;
			finished4 = true;
		}
		else if(segCtr ==3)
		{				
			finished4 = true;
		}
*/
		for(register int p = 0;p<=blackCtr;p++)				// top->bottom
		{
			int middle = (int)(Blacks[p].z + Blacks[p].x)/2;
			if(Borders[Blacks[p].z]==0 && Borders[Blacks[p].x]==0 && Borders[middle]==0)	//	is black Lp in segment?(left middle right checked)
			{
				OUTPUT(idText,text, "Borders[Blacks["<<p<<"].z] = 0, also wird dieses Lp nicht segmentiert");
				continue;										
			}
			else	//	Lp might be addable to segment, first get segNo
			{				
				if(Borders[Blacks[p].z]==0 && Borders[Blacks[p].x]==0)		//	only middle is in segment
				{
					segNo = Borders[middle]-1;
				}
				else if(Borders[Blacks[p].x]==0)
					segNo = Borders[Blacks[p].z]-1;		
				else 
					segNo = Borders[Blacks[p].x]-1;		
				
				if(segNo <0)
					break;				

				//	assign the correct Lp-Counter and finished-boolean of the segment!
				if(segNo == 0)					
				{
					if(finished1)
						continue;
					finished = &finished1;	
					Ctr = &ctr1;
				}
				else if(segNo == 1)
				{
					if(finished2)
						continue;
					finished = &finished2;
					Ctr = &ctr2;
				}
				else if(segNo == 2)
				{
					if(finished3)
						continue;
					finished = &finished3;
					Ctr = &ctr3;
				}
				else if(segNo == 3)
				{
					if(finished4)
						continue;
					finished = &finished4;					
					Ctr = &ctr4;
				}
			}			

			
			if(Blacks[p].y < Segment[segNo][0].y - (*Ctr)/3)
			{
				//too high yet, jump to next Point
				OUTPUT(idText,text, "~too high, continue blacks on  line "<<Blacks[p].y);
				continue;
			}
			else if(Blacks[p].y > Segment[segNo][0].y + shadowThres)
			{	
				*finished = true;
				OUTPUT(idText,text, "~~Segment " << (segNo+1)<<" completed in line "<<Blacks[p].y);						
				if(finished1 && finished2 && finished3 && finished4)
					break;
				continue;
			}						
			else			// in allowed line for black Pairs
			{
				int quarterAdd = (int)(Blacks[p].x + middle)/2 - middle;				
				if(getColorFromRaster(Blacks[p].z,Blacks[p].y-1)==green 
					&& getColorFromRaster(middle + quarterAdd,Blacks[p].y-1)==green 
					&& getColorFromRaster(middle,Blacks[p].y-1)==green 
					&& getColorFromRaster(middle - quarterAdd,Blacks[p].y-1)==green 
					&& getColorFromRaster(Blacks[p].x,Blacks[p].y-1)== green
					&& Blacks[p].y > Segment[segNo][0].y
					/*&& (getColorFromRaster(Blacks[p].z+1,Blacks[p].y)== green
						|| getColorFromRaster(Blacks[p].z-1,Blacks[p].y)== green)
					&& (getColorFromRaster(Blacks[p].x+1,Blacks[p].y)== green
						|| getColorFromRaster(Blacks[p].x-1,Blacks[p].y)== green)*/)						
				{

					// Segment finished!
					*finished = true;
					OUTPUT(idText,text, "~~Segment " << (segNo+1)<<" completed in line "<<Blacks[p].y);						
					if(finished1 && finished2 && finished3 && finished4)
						break;
					continue;
				}									
				//Segment[segNo][0].y = Blacks[p].y;	
				Segment[segNo][*Ctr].x = Blacks[p].x;
				Segment[segNo][*Ctr].y = Blacks[p].y;				
				//adjust Segment Borders to applied Lp
				adjustBorders(Blacks[p].x,Blacks[p].z,segNo+1);
				DOT(imageProcessor_obstacles, Segment[segNo][*Ctr].x*rip->marginX,
					Segment[segNo][*Ctr].y*rip->marginY, Drawings::black, Drawings::white);
				(*Ctr)++;
				continue;
			}	//
		}	//	close for-cycle
		
		/////////////////////////////////////////////////
		//	here the whole Segment arrays are processed, now validation starts! 				


		for(int seg = 0; seg< segCtr; seg++)
		{			
			if(seg== 0)
			{				
				Ctr = &ctr1;
			}
			else if(seg == 1)
			{
				Ctr = &ctr2;
			}
			else if(seg == 2)
			{
				Ctr = &ctr3;
			}
			else if(seg == 3)
			{
				Ctr = &ctr4;
			}
			
			Vector2<double> pt;			
			horizon = rip->getHorizon();
			pt.x = (double)(Segment[seg][2].x * rip->marginX);			
			pt.y = (double)(Segment[seg][2].y * rip->marginY);
			int defDist = (int)Geometry::getDistanceToLine(horizon, pt);
			Segment[seg][1] = Segment[seg][2];
			Segment[seg][1].y += (defDist >>5);		//	just a try to get height of point in middle of aibo						
			for(int z = 3; z <(*Ctr);z++)
			{
				Segment[seg][1].x += Pool[z].z;
			}
			Segment[seg][1].x /= (*Ctr)-2;
			/*	assume maximum y = farest Point to horizon, save time of calculating every Lp-Point
			double tmpDist = 0;
			Vector2<double> tmp;
			
			
			for(int ptCtr = 3; ptCtr < *Ctr; ptCtr++)
			{	
				DOT(imageProcessor_obstacles, Segment[seg][ptCtr].x*rip->marginX,Segment[seg][ptCtr].y*rip->marginY, 
					Drawings::blue, Drawings::orange);
				tmp.x = (double)(Segment[seg][ptCtr].x * rip->marginX);
				tmp.y = (double)(Segment[seg][ptCtr].y * rip->marginY);
				tmpDist = Geometry::getDistanceToLine(horizon, tmp);
				if(tmpDist > defDist)	
				{
					continue;				
				}
				else
				{
					
				DOT(imageProcessor_obstacles, Segment[seg][ptCtr].x*rip->marginX,Segment[seg][ptCtr].y*rip->marginY, 
					Drawings::blue, Drawings::red);
					defDist = tmpDist;
					Segment[seg][1].x = Segment[seg][ptCtr].x;
					Segment[seg][1].y = Segment[seg][ptCtr].y;
				}
			}
			*/
			
			//this is the assumed farest point to horizon!
			DOT(imageProcessor_obstacles, Segment[seg][1].x*rip->marginX,Segment[seg][1].y*rip->marginY, 
				Drawings::red, Drawings::yellow);

			Vector2<int> pointOnField;
			Geometry::calculatePointOnField(Segment[seg][1].x*rip->marginX,Segment[seg][1].y*rip->marginY,(rip->cameraMatrix),rip->image.cameraInfo,pointOnField);
       
			// generate enemy percept
      SinglePlayerPercept percept;
			percept.offset.x=pointOnField.x;
			percept.offset.y=pointOnField.y;
			percept.validity=0.9876;
			OUTPUT(idText,text,"EnemyValidity: "<< percept.validity);
			 			 
			if(strategy->enemyColor == red)
			 rip->playersPercept.addRedPlayer(percept);
			else 
			 rip->playersPercept.addBluePlayer(percept);		



			/*
            Vector2<int> pointOnField;
            pointOnField=calculatePointOnFieldCOG(3,Segment,seg,Ctr);
			
            // generate enemy percept
            SinglePlayerPercept percept;
			percept.offset.x=pointOnField.x;
			percept.offset.y=pointOnField.y;
			percept.validity=0.999;
			OUTPUT(idText,text,"EnemyValidity: "<< percept.validity);
			 			 
			if(strategy->enemyColor == red)
			 rip->playersPercept.addRedPlayer(percept);
			else 
			 rip->playersPercept.addBluePlayer(percept);		



								
			//	validate first Segment:		validation not final, only experimental idea
			int segmentHeight = Segment[seg][tempCtr].y - Segment[seg][Segment[0][0].x].y;
			if(segmentHeight ==0)
				segmentHeight = tempCtr-2;

			if(tempCtr==Segment[seg][0].x)
			{
				//	no shadow Lp added...			
				Segment[seg][1].x = Segment[seg][2].x;
				Segment[seg][1].y = Segment[seg][2].y;
				vali = 0.50;
			}
			else
			{
				Segment[seg][1].x = Segment[seg][tempCtr].x;
				Segment[seg][1].y = Segment[seg][tempCtr].y;
				vali = 0.60;
			}						
			//this is the deepest color-Lp-point to y-axis, not to horizon yet!
			DOT(imageProcessor_obstacles, Segment[seg][2].x*rip->marginX,Segment[seg][2].y*rip->marginY, 
				Drawings::yellow, Drawings::yellow);

			//this is the deepest point to y-axis, not to horizon yet!
			DOT(imageProcessor_obstacles, Segment[seg][1].x*rip->marginX,Segment[seg][1].y*rip->marginY, 
				Drawings::red, Drawings::yellow);

			Vector2<int> pointOnField;
			Geometry::calculatePointOnField(Segment[seg][1].x*rip->marginX,Segment[seg][1].y*rip->marginY,(rip->cameraMatrix),rip->image.cameraInfo,pointOnField);
			 // generate enemy percept
			 SinglePlayerPercept percept;
			 percept.offset.x=pointOnField.x;
			 percept.offset.y=pointOnField.y;
			 percept.validity=vali;
			 OUTPUT(idText,text,"EnemyValidity: "<< vali);
			 //if(enemyValidity >= 0.01)

			 //	by now there will be added a percept to the highest y-value, has to be changed to farestPointFromHorizon!!!
			 if(strategy->enemyColor == red)
				 rip->playersPercept.addRedPlayer(percept);
			 else 
				 rip->playersPercept.addBluePlayer(percept);		
				 */
		}
		 
#else
//		this is another idea, add only deepest color-point, farestColor-Point (not done) and farest shadow-Point(not done)
//		might be faster than ever!
		OUTPUT(idText,text, " EnemyOnlySpecialist-PostProcessing...");					
		Vector2<int> *segPointerArray[4];		//	array of Pointer to Vector2<int>-arrays
		for(register int s = 0; s < 4; s++)				//	init as much arrays as Segments found
		{
			segPointerArray[s] = new Vector2<int>[3];	//	only 1 colored Point but more black points per line			
			segPointerArray[s][0].x = 0;	//	farest Point
			segPointerArray[s][0].y = 0;
			segPointerArray[s][1].x = 0;	//	farest color-Point
			segPointerArray[s][1].y = 0;
			segPointerArray[s][2].x = 0;	//	deepest color-Point
			segPointerArray[s][2].y = 0;	
			segPointerArray[s][3].x = 0;	//	other info (might be written by finalize());
			segPointerArray[s][3].y = 0;	
		}
		Vector2<int> **segment;
		segment = segPointerArray;	//	array of segment-arrays, first and second field of each segment-array reserved for deepest point and validation				
		finalize();	//	adjust finalize(), so that number of colored Lp (=max. of countBorder for each segment) might be stored in segment[segNo][3].x,.y, 
		int completed = 0;
		if(segCtr==0)
		{
			OUTPUT(idText,text, "no segments processed!");			
			return;
		}
		else if(segCtr>4)			//	there can only be 4
			format(4);
		
		lpCtr--;
		blackCtr--;	
			
			//to see finalized array Borders[]
			for(register int b = 0; b<=104;b++)
			{
				if(Borders[b]==0)
				{
					DOT(imageProcessor_obstacles, b*rip->marginX,rip->marginY*rasterHeight-1, 
						Drawings::white, Drawings::black);
					continue;
				}
				if(Borders[b]==1)			
				{
					DOT(imageProcessor_obstacles,b*rip->marginX,rip->marginY*rasterHeight-1, 
						Drawings::white, Drawings::red);
					continue;
				}
				if(Borders[b]==2)
				{
					DOT(imageProcessor_obstacles, b*rip->marginX,rip->marginY*rasterHeight-1, 
						Drawings::white, Drawings::orange);
					continue;
				}
				if(Borders[b]==3)
				{
					DOT(imageProcessor_obstacles,b*rip->marginX,rip->marginY*rasterHeight-1, 
						Drawings::white, Drawings::yellow);
					continue;
				}
				if(Borders[b]==4)
				{
					DOT(imageProcessor_obstacles,b*rip->marginX,rip->marginY*rasterHeight-1, 
						Drawings::white, Drawings::pink);
					continue;
				}
				if(Borders[b]>4)
				{
					DOT(imageProcessor_obstacles, b*rip->marginX,rip->marginY*rasterHeight-1, 
						Drawings::white, Drawings::white);
					continue;
				}
				if(Borders[b]<0)
				{
					DOT(imageProcessor_obstacles, b*rip->marginX,rip->marginY*rasterHeight-1, 
						Drawings::black, Drawings::black);
					continue;
				}
			}
			
			//	get first valid Lp
			while(Borders[Pool[lpCtr].x]==0 && lpCtr >0)
				lpCtr--;					

	
			bool finished1 = false;
			bool finished2 = false;
			bool finished3 = false;
			bool finished4 = false;
			if(segCtr == 1)
			{
				finished2 = true;
				finished3 = true;
				finished4 = true;
			}
			else if(segCtr ==2)
			{
				finished3 = true;
				finished4 = true;
			}
			else if(segCtr ==3)
			{				
				finished4 = true;
			}

			int segNo = Borders[Pool[lpCtr].x]-1;
			int actualY1 = 0;
			int actualY2 = 0;
			int actualY3 = 0;
			int actualY4 = 0;
			if(segNo == 0)
			{
				actualY = &actualY1;
				finished = &finished1;
			}
			else if(segNo == 1)
			{
				actualY = &actualY2;
				finished = &finished2;
			}
			else if(segNo == 2)
			{
				actualY = &actualY3;
				finished = &finished3;
			}
			else if(segNo == 3)
			{
				actualY = &actualY4;
				finished = &finished4;
			}
			*actualY = Pool[lpCtr].y;
			segment[segNo][2].x=Pool[lpCtr].x;
			segment[segNo][2].y= Pool[lpCtr].y;
			DOT(imageProcessor_obstacles, segment[segNo][2].x*rip->marginX,segment[segNo][2].y*rip->marginY, Drawings::red, Drawings::white);				
			if(strategy->horFalls)		//	add only the most left LinePair of a segment
			{				
				for(register int p = lpCtr-1;p>=0;p--)	//	bottom -> top
				{
					if(Borders[Pool[p].x]==0)
					{
						OUTPUT(idText,text, "Borders[Pool["<<p<<"].x] = 0!, also wird dieses Lp nicht segmentiert");	
						continue;
					}
					else	//   1<= Borders[Pool[p].x <=4
					{
						if(	Borders[Pool[p].x]-1==segNo)	//	Point in same segment like Pool[p-1]
						{							
							if(Pool[p].y == *actualY )						//	another Point in deepest Line from same segment
							{
								segment[segNo][2].x=Pool[lpCtr].x;
								segment[segNo][2].y= Pool[lpCtr].y;
								DOT(imageProcessor_obstacles, segment[segNo][2].x*rip->marginX,segment[segNo][2].y*rip->marginY, Drawings::red, Drawings::white);				
								continue;
							}
							else		//	same segment point in higher line found,
							{
								*finished = true;
								if(finished1 && finished2 && finished3 && finished4)
									break;
								continue;
							}																
						}
						else		//	other segment
						{
							segNo = Borders[Pool[p].x]-1;
							if(segNo == 0)
							{
								actualY = &actualY1;
								finished = &finished1;
							}
							else if(segNo == 1)
							{
								actualY = &actualY2;
								finished = &finished2;
							}
							else if(segNo == 2)
							{
								actualY = &actualY3;
								finished = &finished3;
							}
							else if(segNo == 3)
							{
								actualY = &actualY4;
								finished = &finished4;
							}
							if(segment[segNo][2].x==0)	//	first deepest Point in segment found
							{
								*actualY = Pool[lpCtr].y;
								segment[segNo][2].x=Pool[lpCtr].x;
								segment[segNo][2].y= Pool[lpCtr].y;
								DOT(imageProcessor_obstacles, segment[segNo][2].x*rip->marginX,segment[segNo][2].y*rip->marginY, Drawings::red, Drawings::white);				
								continue;
							}
							else	//	another deepest point in segment found
							{
								if(Pool[p].y == *actualY )						//	Point in deepest Line
								{
									segment[segNo][2].x=Pool[lpCtr].x;
									segment[segNo][2].y= Pool[lpCtr].y;
									DOT(imageProcessor_obstacles, segment[segNo][2].x*rip->marginX,segment[segNo][2].y*rip->marginY, Drawings::red, Drawings::white);								
									continue;
								}
								else		//	point in same segment but higher line -> segment finished
								{
									*finished = true;
									if(finished1 && finished2 && finished3 && finished4)
										break;
									continue;
								}							
							}	//	close else "another deepest point in segment found"	
						}	//	close else "other segment"
					}	//	close else Borders[]>0
				}	//	close for-cycle
			}
			else		//	horizon falls not, add only the most right LinePair of a segment
			{				
				*finished = true;
				if(!(finished1 && finished2 && finished3 && finished4))
				{
				for(register int p = lpCtr-1;p>=0;p--)	//	bottom -> top
				{
					if(Borders[Pool[p].x]==0)
					{
						OUTPUT(idText,text, "Borders[Pool["<<p<<"].x] = 0!, also wird dieses Lp nicht segmentiert");	
						continue;
					}
					else	//   1<= Borders[Pool[p].x <=4
					{
						if(	Borders[Pool[p].x]-1==segNo)	//	Point in same segment like Pool[p-1]
						{	
							continue;										
						}
						else		//	other segment
						{
							segNo = Borders[Pool[p].x]-1;
							if(segNo == 0)							
								finished = &finished1;
							else if(segNo == 1)
								finished = &finished2;
							else if(segNo == 2)
								finished = &finished3;
							else if(segNo == 3)
								finished = &finished4;
							if(segment[segNo][2].x==0)	//	first deepest Point in segment found
							{
								segment[segNo][2].x=Pool[lpCtr].x;
								segment[segNo][2].y= Pool[lpCtr].y;
								DOT(imageProcessor_obstacles, segment[segNo][2].x*rip->marginX,segment[segNo][2].y*rip->marginY, Drawings::red, Drawings::white);														
								*finished = true;
								if(finished1 && finished2 && finished3 && finished4)
									break;
								continue;											
							}
							else	//	another deepest point in segment found
							{
								continue;
							}	//	close else "another deepest point in segment found"	
						}	//	close else "other segment"
					}	//	close else Borders[]>0
				}	//	close for-cycle
				}	//	finished, cause only 1 segment has to be processed
			}	//	else !strategy falls
#endif				
			
	}	//	lpCtr !=0
}
			
			

void REnemyOnlySpecialist::invokeOnPreScan(int x,int y, int enemyCtr){

	if (!strategy->insidePlayer)
		left = x;
	else{
		lpLength = x - left;
		if ( lpLength < minLpLength)		//	Lp too short
		{
			OUTPUT(idText,text, "Lp too short!");
			return;	
		}

		if(strategy->horFalls)				//	hor Falls, save only left x-values!
		{
			if(enemyCtr ==0 || (enemyCtr<<validFactor) < lpLength)
			{
				return;
				/*
				if( y < strategy->horizon.base.y || lpCtr <2)		//	not adaptive to horizon...yet ;)
					return;

				if(lpLength > (y>>3))
					return;
				
				if(blackCtr < 100)
				{					
					Blacks[blackCtr].x = left;
					Blacks[blackCtr].y = y;
					Blacks[blackCtr].z = x;
					blackCtr++;		
					//DOT(imageProcessor_obstacles, left*2,y*2, Drawings::black, Drawings::black);
					LINE(imageProcessor_obstacles,left*rip->marginX,y*rip->marginY, x*rip->marginX,y*rip->marginY,  0.5, Drawings::ps_solid, Drawings::gray);
				}*/

			}
			else	//	colored Lp
			{		
				if(lpCtr<100)
				{
					applyToBA(left, x);
					Pool[lpCtr].x = left;
					Pool[lpCtr].y = y;			
					Pool[lpCtr].z = (left+x)>>1;
					lpCtr++;
					LINE(imageProcessor_obstacles,left*rip->marginX,y*rip->marginY, x*rip->marginX,y*rip->marginY, 0.5, Drawings::ps_solid, Drawings::white);
					DOT(imageProcessor_obstacles, x*rip->marginX,y*rip->marginY, Drawings::pink, Drawings::green);
				}
				else 
				{					
					LINE(imageProcessor_obstacles,left*rip->marginX,y*rip->marginY, x*rip->marginX,y*rip->marginY,  0.5, Drawings::ps_solid, Drawings::yellow);
					return;
				}
			}
		}
		else	//	!horFalls, save only right x-Values!
		{
			if(enemyCtr ==0 || (enemyCtr<<validFactor) < lpLength)
			{
				return;
				/*
				if(y < strategy->horizon.base.y || lpCtr <2)
					return;								
				
				if(lpLength > (y>>3))
					return;

				if(blackCtr < 100)
				{					
					Blacks[blackCtr].x = x;
					Blacks[blackCtr].y = y;
					Blacks[blackCtr].z = left;
					blackCtr++;		
					//DOT(imageProcessor_obstacles, x*2,y*2, Drawings::black, Drawings::black);
					LINE(imageProcessor_obstacles,left*rip->marginX,y*rip->marginY, x*rip->marginX,y*rip->marginY,  0.5, Drawings::ps_solid, Drawings::gray);
				}*/
			}
			else	//	colored Lp
			{		
				if(lpCtr<100)
				{
					applyToBA(left, x);
					Pool[lpCtr].x = x;
					Pool[lpCtr].y = y;
					Pool[lpCtr].z = (x+left)>>1;
					lpCtr++;
					LINE(imageProcessor_obstacles,left*rip->marginX,y*rip->marginY, x*rip->marginX,y*rip->marginY, 0.5, Drawings::ps_solid, Drawings::white);
					DOT(imageProcessor_obstacles, x*rip->marginX,y*rip->marginY, Drawings::pink, Drawings::green);
				}
				else 
				{
					LINE(imageProcessor_obstacles,left*rip->marginX,y*rip->marginY, x*rip->marginX,y*rip->marginY,  0.5, Drawings::ps_solid, Drawings::yellow);
					return;
				}
			}
		}
	}
}



/**
*		finalizes the x-axis-shadow-array with lp-borders and marks array[i] = 0 for no segment area 
*		and array[i] = k as an x-value for the k-th segment!; 
*		after calling this method array[i] becomes a look-up-table which relates every LinePair to it's destinated segment!
*		this enables segmentation in constant(!) time to the number of LinePairs!
*		a segment border is caught after 2 LinePair-beginnings and has at least 3 Lps in his Body. It ends if only 2 open Lp resist!
*		so 2 failure-Lp are guaranteed (this might be useful because white is not closing color!)
*		this method can be adjusted for bad light conditions, yet static calculation of segment borders might become dynamical to the 
*		relation distance of firstly recieved borders <-> value of later added border-values!!
to the number of beginning LinePairs
**/

void REnemyOnlySpecialist::finalize()
{
	bool inLp = false;		//	false, if Borders[i] ==0;	
//	int tmpBorder = 0;
	int countBorder = 0;	//	counts the Lp-openings and closings
	segCtr=0;							//	counts the segments				
	for(int i = 0; i <=104; i++)
	{
		if(!inLp)
		{
			if(Borders[i]==0)
				continue;
			else if(Borders[i] > 0 && Borders[i] < minSize)
			{
				countBorder += Borders[i];
				if(countBorder >minSize)
				{
					inLp = true;
					segCtr++;
					Borders[i] = segCtr;
					continue;
				}
				else		// countBorder <=minSize
				{
				Borders[i] = 0;
				continue;
				}
			}
			else if(Borders[i] <0)
			{
				countBorder +=Borders[i];
				Borders[i] = 0;
				continue;
			}
			else	//	Borders[i] >minSize
			{
				inLp = true;
				segCtr++;
				countBorder += Borders[i];
				Borders[i] = segCtr;
				continue;
			}
		}
		else		//	inLp == true, means that we are in segment area with min. minSize Lp
		{
			if(Borders[i]==0)
			{
				Borders[i] = segCtr;
				continue;
			}
			else if(Borders[i]>0)
			{
				countBorder += Borders[i];
				Borders[i]=segCtr;
				continue;
			}
			else	//	Borders[i] <0
			{				
				countBorder+=Borders[i];
				if(countBorder <= ignored)	//	out of segment found!
				{
					inLp = false;
					Borders[i] = segCtr;
					continue;								
				}				
				
				else if(countBorder <0)
				{
					OUTPUT(idText,text,  "Error in finalize(), countBorder went negative!!");	
					continue;
				}
				
				else	//countBorder stays > minSize, set Borders[i] to segmentnumber, getBorder to true and go on
				{
					Borders[i] = segCtr;
					continue;
				}
			}//	else Borders[i] <0
		}	//	else if(isClear)
	}	//	close for-Cyle
	OUTPUT(idText,text, segCtr << " segments processed!");			
}

/*
*		@method finalize
*		@param Borders:	the border array Borders to finalize
*		@param minSize:	minimal size of segment 
*		@param ignored: amount of ignored Lp ( shirts totally consisting (ignored +1) Lps)
*		merges potential shirt-Lps to shirts, a shirt consists at least of 3 Lps!
*		basic version, to do: segmentation parallel to horizon
*/
/*
void REnemyOnlySpecialist::finalize()
{
	inLp = false;		//	false, if Borders[i] ==0;	
	borderCtr = 0;	//	counts the Lp-openings and closings		
	bool isShirt = false;
	int bTag = 0;	
	for(int i = 0; i <=rasterWidth; i++)
	{
		if(!inLp)
		{
			if(Borders[i]==0)
			{				
				continue;
			}			
			else	//	Borders[i] >0
			{
				borderCtr += Borders[i];
				if(borderCtr <= ignored)
				{
					Borders[i] = 0;
					continue;
				}
				else
				{
					bTag = i;
					inLp = true;
					segCtr++;
					isShirt = (borderCtr >= minSize);		
					Borders[i] = segCtr;
					continue;
				}
			}
		}
		else		// in segment area
		{
			if(Borders[i]==0)
			{
				Borders[i] = segCtr;
				continue;
			}
			else if(Borders[i]>0)
			{
				borderCtr += Borders[i];
				if(!isShirt)
					isShirt = (borderCtr >= minSize);
				Borders[i]=segCtr;
				continue;
			}
			else	//	Borders[i] <0
			{
				borderCtr+=Borders[i];				
				if(borderCtr <= ignored)	//	out of segment found!
				{
					if(!isShirt)
					{
						for(int j = bTag; j <= i; j++)
						{
							Borders[j] = 0;
						}
						segCtr--;
						inLp = false;
						continue;
					}
					else	//Shirt found
					{
						inLp = false;
						isShirt = false;
						Borders[i] = segCtr;
						continue;
					}
				}
				else if(borderCtr <0)
				{
					OUTPUT(idText,text,  "Error in finalize(), borderCtr went negative!!");	
					continue;
				}
				else	//	borderCtr > ignored
				{
					Borders[i] = segCtr;
					continue;
				}				
			}//	else array[i] <0
		}	//	else inLp == true
	}	//	close for-Cyle
	OUTPUT(idText,text, segCtr << " segments processed_#");
}*/

/*
Vector2<int> REnemyOnlySpecialist::getDualFootPoint(Vector2<int> **segment, int seg, int *ctr)
{
	Vector2<double> foot2((double)segment[seg][2].x,(double)segment[seg][2].y);
	Vector2<double> foot1 = foot2;
	for(register int count = 3; count <=*ctr; count++)
		{
		Vector2<double> tempFoot((double)segment[seg][count].x,(double)segment[seg][count].y); 
		if(Geometry::getDistanceToLine(horizon,tempFoot) > Geometry::getDistanceToLine(horizon, foot1))
		{
			foot2 = foot1;
			foot1.x = (double)segment[seg][count].x;
			foot1.y = (double)segment[seg][count].y;
		}
		}
	Vector2<int> result((int)(foot1.x + foot2.x)/2 + 0.5,(int)(foot1.y + foot2.y)/2 + 0.5);
	return result;
}
*/
int REnemyOnlySpecialist::getType()
{
	return __REnemyOnlySpecialist;	
}

/*

Vector2<int> REnemyOnlySpecialist::calculatePointOnFieldCOG(int numberOfFootPoints, Vector3<int> **segment, int seg, int *ctr)
{	
    if (numberOfFootPoints>10) 
		numberOfFootPoints=10;
	int footPointDistance [400];
    Vector2<double> footPoint[400]; // enemyLines.size()*2, bei erhhter Auflsung eventuell Array vergrern
	Vector2<int> pointsOnField[10]; // number of footpoints
	Vector2<int> pointOnField;
	horizon = rip->getHorizon();
	Vector2<double> point1,point2,maxPoint;
        for (unsigned i = 0; i < (unsigned)*ctr-2; i=i+2)
    	{
          point1.x=segment[seg][i+2].x*rip->marginX;
	      point1.y=segment[seg][i+2].y*rip->marginY;
	      footPoint[i]=point1;
		  footPointDistance[i]=(int)Geometry::getDistanceToLine(horizon,footPoint[i]);
          point2.x=segment[seg][i+2].z*rip->marginX;
	      point2.y=segment[seg][i+2].y*rip->marginY;
	      footPoint[i+1]=point2;
          footPointDistance[i+1]=(int)Geometry::getDistanceToLine(horizon,footPoint[i+1]);
        }
        // suche numberOfFootPoints entfernteste Punkte
        for (unsigned l = 0; l < (unsigned)numberOfFootPoints;l++)
    	{
          for (unsigned m = l+1; m < (unsigned)*ctr-2;m++)
          {
              if (footPointDistance[m]<footPointDistance[l])           
              { 
                // swap
                int tmp = footPointDistance[m];
                Vector2<double> tmp2 = footPoint[m];
                footPointDistance[m] = footPointDistance[l];
                footPoint[m] = footPoint[l];
                footPointDistance[l] = tmp;
                footPoint[l] = tmp2;
              }
          }
        }
        // numberOfFootpoints entfernteste footPoints stehen nun vorne im Array
        for (unsigned g = 0; g < (unsigned)numberOfFootPoints;g++)
	{
           DOT(imageProcessor_obstacles, footPoint[g].x,footPoint[g].y,Drawings::ps_solid, Drawings::yellow); // zeichnet Fupunkte ein
	   Geometry::calculatePointOnField((int)footPoint[g].x,(int)footPoint[g].y,(rip->cameraMatrix),rip->image.cameraInfo,pointOnField);
	   pointsOnField[g]=pointOnField;
	}
        // pointsOnFieldArray enthlt nun geordnet die FeldPunkte, die zu den entferntesten footPoints zum Horizont gehren
	// bestimme Approximation nach COG
	pointOnField.x=0;
	pointOnField.y=0;
	for (unsigned f = 0; f < (unsigned)(numberOfFootPoints);f++)
	{
	  pointOnField.x=pointOnField.x+pointsOnField[f].x;
	  pointOnField.y=pointOnField.y+pointsOnField[f].y;
	}
        pointOnField.x=pointOnField.x/numberOfFootPoints;
        pointOnField.y=pointOnField.y/numberOfFootPoints;
        //OUTPUT(idText,text,"pointOnField approximiert nach COG: x: " << pointOnField.x << "y: " << pointOnField.y);
	// pointOnField ist nun eine Approximation des Punktes, wo der Gegner auf dem Spielfeld steht (relativ zum Robot)
	return (pointOnField);
}

*/

void REnemyOnlySpecialist::init()
{	
	postScanNeeded = false;
	preScanNeeded = true;
	initBA();
	lpCtr = 0;
	blackCtr = 0;	
	Pool[lpCtr].y = 0;
}


/*
* Change log :
* 
* $Log: REnemyOnlySpecialist.cpp,v $
* Revision 1.13  2004/03/17 22:30:16  schmidtb
* removed warnings
*
* Revision 1.12  2004/03/17 18:27:45  koh
* warnings and errors removed
*
* Revision 1.11  2004/03/17 17:01:14  koh
* calculating farest point to horizon now only by treating valid Line Pairs, others are ignored by now
* assuming y-value (height) of foot point by distance to horizon,
* x-value(width) of foot point by arithmetical middle of Line Pairs,
* introduced variables to modify percept-generating-behavior
*
* Revision 1.10  2004/03/05 12:48:14  neubach
* - multiple Point Approximation working with segment-arrays of type Vector3<int>[]
*
* Revision 1.9  2004/03/05 12:35:01  koh
* extended segment-arrays from Vector2<int>[] to Vector3<int>[]
* little changes in segmentation-method finalize();
* not final yet!
*
* Revision 1.8  2004/03/05 11:20:25  neubach
* - added PointOnField-Calculation via COG
*
* Revision 1.7  2004/03/04 14:49:05  koh
* farest Point calculation added
*
* Revision 1.6  2004/03/03 18:59:49  koh
* changed adding blacks[p]
* not final yet!
*
* Revision 1.5  2004/03/02 13:14:21  roefer
* Warnings and errors removed
*
* Revision 1.4  2004/03/01 20:58:41  koh
* new strategy RFlexibleStrategy and new RasterSpecialist REnemyOnlySpecialist added
*
*
* commit log added
*
*/
