// RDefaultStrategy2.h: Schnittstelle fr die Klasse RDefaultStrategy2.
//
//////////////////////////////////////////////////////////////////////

#ifndef RDefaultStrategy2_H
#define RDefaultStrategy2_H

class RDefaultStrategy2;

#include "RasterStrategy.h"
#include "REnemySpecialist.h"
#include "RBallSpecialist2.h"
#include "RFieldSpecialist.h"
#include "BoxSpecialist.h"
#include "RFieldStateMachine.h"
#include "REnemyOnlySpecialist.h"
#include "EnemySpecialist2.h"
#include "RBridgeSpecialist.h"
#include "Modules/ImageProcessor/ImageProcessorTools/MSH2004EdgeDetection.h"
#include <vector>
#include <deque>

#include "Tools/Math/Geometry.h"


class RDefaultStrategy2;
class RBallSpecialist;
class RBallSpecialist2;
class RFieldSpecialist;
class REnemySpecialist;
class RBoxSpecialist;
class REnemyOnlySpecilist;
class EnemySpecialist2;




class RDefaultStrategy2 : public RasterStrategy  
{
public:
	RDefaultStrategy2(RasterImageProcessor &processor);
	virtual ~RDefaultStrategy2();

	void execute();

	void init();

	bool lineChanged;

	bool columnChanged;

	bool wasRedOrBlue;
	
	bool redLp;

	colorClass get_currentColor() const {return currentColor;}
	
	int get_width() const {return width;}

private: 

	
	typedef void(RDefaultStrategy2::*tab_fct)(int, int, bool , bool);

	tab_fct color_check[numOfColors];

	inline void doNothing(int, int, bool, bool);
    inline void checkOrange(int, int, bool, bool); 
    inline void checkYellow(int, int, bool, bool); 
    inline void checkSkyblue(int, int, bool, bool);
    inline void checkPink(int, int, bool, bool);
    inline void checkRed(int, int, bool, bool);
    inline void checkBlue(int, int, bool, bool);
    inline void checkGreen(int, int, bool, bool);
    inline void checkGray(int, int, bool, bool);
    inline void checkWhite(int, int, bool, bool);
    inline void checkBlack(int, int, bool, bool);
    inline void checkYellowOrange(int, int, bool, bool);


	void preScan();

	void postScan();

	void postProcessing();

	RBallSpecialist2* ballSpecialist;

	RFieldSpecialist* fieldSpecialist;

	REnemySpecialist* enemySpecialist;

	BoxSpecialist* boxSpecialist;

	RBridgeSpecialist* bridgeSpecialist;

	MSH2004EdgeDetection edgeScanner;

	RFieldStateMachine fieldDSA;

	colorClass lastColor; 

	colorClass currentColor;

	int linePattern;

	int lineXActive;

	int lineYActive;

	int width;
	
	int height;

	int ballFactor;

	int fieldFactor;

	int goalFactor;

	int playerFactor;

	int lmFactor;

	int distToHorizon;

	int enemyCtr;

	double diffBuffer[5];

	Geometry::Line horizon; 

	bool active[7];

	int postThreshold;
};

#endif

/*
* Change log :
* 
* $Log: RDefaultStrategy2.h,v $
* Revision 1.3  2004/06/03 16:52:31  deom
* *** empty log message ***
*
* Revision 1.2  2004/06/03 14:22:51  deom
* debugged
*
* Revision 1.1  2004/06/02 10:15:49  deom
* speed and function calls significantly improved
*
* Revision 1.31  2004/05/25 13:27:33  schmidtb
* modified version of rip for open-challenge
*
* Revision 1.30  2004/05/24 14:45:04  deom
* commented out bridgeSpecialist
*
* Revision 1.29  2004/05/22 19:03:40  deom
* -now recognizes the red line
* -all the data required for the positionning are computed
*
* Revision 1.31  2004/05/22 16:01:50  pg_besc
* -modified version of rip for bridge-recognition
*
* Revision 1.30  2004/04/20 07:50:27  pg_besc
* new version of pre scan
*
* Revision 1.29  2004/04/15 19:09:17  pg_besc
* merged code
*
* Revision 1.28  2004/03/17 22:31:34  schmidtb
* integrated RFieldStateMachine and horizonal grid scan
*
* Revision 1.27  2004/03/17 17:05:18  koh
* added enemyOnlySpecialist to strategy;
* added enemySpecialist2 to strategy;
*
* Revision 1.26  2004/03/11 20:49:39  schmidtb
* new version of rip , merged code
*
* Revision 1.25  2004/03/03 12:53:21  schmidtb
* color correction integrated
*
* Revision 1.24  2004/03/01 14:17:25  koh
* added new strategy "RFlexibleStrategy" + new specialist "EnemyOnlySpecialist";
* changed references to "RDefaultStrategy2" to references to "RasterStrategy" in RFieldSpecialist
* added Geometry::Line horizon to "RasterStrategy"
*
* Revision 1.23  2004/02/18 14:56:19  neubach
* new Segmentation established, code not cleared at all
*
* Revision 1.21  2004/02/04 15:05:20  schmidtb
* warnings removed
*
* Revision 1.20  2004/02/04 13:00:49  schmidtb
* new version of BoxSpecialist
*
* Revision 1.19  2004/02/03 23:09:18  hyung
* Array based on rasterWidth now
*
* ! somehow it seems that my code produces warnings for which I'm
* very very sorry, but my compiler told me always 0 errors, 0 warnings....
* does somebody know the reason?
*
* Revision 1.18  2004/02/03 21:18:27  hyung
* some minor changes,
*
* size of Segmentborder-Array (TrikotErkennung) basically adaptive to rip-resolution
*
* Revision 1.17  2004/02/02 13:42:12  schmidtb
* merged sources of RIP. added som functions.
*
* Revision 1.16  2004/01/31 11:45:02  hyung
* modified enemyValidity-calculation;
* established basical enviroment for TrikotErkennung, based on Arrays and Lists, changes will take affect only #ifdef TrikotErkennung!
*
* Revision 1.15  2004/01/23 15:44:01  deom
* New specialist :: BoxSpecialist
* Recognizes both landmarks and goals
*
* Revision 1.14  2004/01/23 10:13:17  neubach
* - ball should no longer be misinterpreted as enemy
*
* Revision 1.13  2004/01/21 03:25:36  hyung
* TrikotErkennung update
*
* Revision 1.12  2004/01/19 12:47:42  hyung
* #ifDef TrikotErkennung mit alternativem Einstiegspunkt fr Gegnererkennung
*
* Revision 1.11  2004/01/16 17:24:57  deom
* no message
*
* Revision 1.10  2003/12/18 17:44:46  hyung
* established new version of method checkGoal(int x,int y)
*
* Revision 1.9  2003/12/15 13:55:32  schmidtb
* Merged and patched new version of RasterImageProcessor.
*
* Revision 1.8  2003/12/09 13:55:16  schumann
* added missing include causing unresolved externals
*
* Revision 1.7  2003/12/08 15:02:55  schmidtb
* new version of RIP
*
* Revision 1.6  2003/12/04 09:51:23  schmidtb
* better BallSpecialist
*
* Revision 1.5  2003/12/02 21:59:02  schmidtb
* New version of RasterImageProcessor
*
* Revision 1.4  2003/11/28 14:50:01  dueffert
* bugs and warnings fixed
*
* Revision 1.3  2003/11/20 10:26:56  schmidtb
* Ball Detection added
*
* Revision 1.2  2003/11/13 10:41:29  schmidtb
* renewed RBallSpeciaslist and Strategy
*
* Revision 1.1  2003/11/12 13:13:20  schmidtb
* new RasterImageProcessor added
*
*
*/
