// RBallSpecialist2.h: Schnittstelle fr die Klasse RBallSpecialist.
//
//////////////////////////////////////////////////////////////////////

#ifndef RBALLSPECIALIST2_H
#define RBALLSPECIALIST2_H




#include "RasterSpecialist.h"
#include "Tools/Math/Geometry.h"
#include <vector>
#include <list>
#include "Tools/Math/Vector2.h"
#include "RasterStrategy.h"
#include "Modules/ImageProcessor/ImageProcessorTools/MSH2004EdgeDetection.h"



class RBallSpecialist2 :public RasterSpecialist  
{
	enum{MAX_EDGE_POINTS = 30,MAX_CIRCLE_DIST = 2,EDGE_THR = 30,SCAN_THR = 30};
public:
	RBallSpecialist2(RasterImageProcessor &processor,RasterStrategy &strategy);
	virtual ~RBallSpecialist2();
	void invokeOnPostScan(int x, int y);
	void executePostProcessing();
	void invokeOnPreScan(int x,int y);
	virtual int getType();
	virtual void init();
	double validateCircle(Geometry::Circle &circle);
 
	
	/** Calculates middled difference of the circle and an edge-point. */ 
	double validateEdgePoints(Geometry::Circle &circle);

	int   maximums[2];
	int   maxCountSum;
	int   countSum;

	inline void getCoordinatesByAngle(double angle,double& x,double& y){
		x = 20*cos(angle);
		y = 20*sin(angle);
	}

	inline void in(int x,int y){
		temp = getVecFromRaster(x,y);
		
	}

	inline void out(int x,int y){
		Vector2<int> out = getVecFromRaster(x,y);
		LinePair lp(scanEast(temp.x,temp.y),scanWest(out.x,out.y));
		rows.push_back(lp);
		//OUTPUT(idText,text,"pair accepted: " << x << " " << y);
		LINE(imageProcessor_ball1,
			lp.v1.x,lp.v1.y, 
			lp.v2.x,lp.v2.y, 
			0.5, Drawings::ps_solid, Drawings::red); 
	}
	
	Vector2<int> temp;
	std::list<LinePair> rows;
	std::list<GridLP> gridPoints;

private:
	
	RasterStrategy *strategy;

	//SUSANEdgeDetectionLite edgeDetector;

	MSH2004EdgeDetection edgeScanner;

	int threshold;

	int minEdgeThreshold;
	
	void addBallPercept(Geometry::Circle &circle,double validity);
	
	double calculateCircle(Geometry::Circle& circle);

	double calculateSmallCircle(Geometry::Circle& circle);

	double calculateCircleByEdges(Geometry::Circle& circle);

	double calculateLargeCircle(const Box& input,Geometry::Circle& circle);

	bool filterBallPoints(std::list<LinePair>& segment);

	bool createBox(std::list<LinePair>& segment,Box& box);

	double middleEdgePointDist(Geometry::Circle &circle);

	inline bool isCross(const LinePair& horizontal,const LinePair vertical){
		return horizontal.v1.x <= vertical.v1.x 
			&& horizontal.v2.x >= vertical.v1.x
			&& vertical.v2.y <= horizontal.v1.y 
			&& vertical.v1.y >= horizontal.v1.y;
	}
	
	Vector2<int> p[4];

	Geometry::Line horizon;

	Vector2<double> south;

	Vector2<double> north;

	std::vector<Vector2<int> > points;

	int numberOfEdgePoints;

	int pointsInSegment;

	double roundness;


	inline bool isEdge(int x,int y){
	//	return edgeDetector.isEdgePoint(rip->image,x,y,
	//		SUSANEdgeDetectionLite::componentA);
		return edgeScanner.isHorizontalEdge(x,y) || edgeScanner.isVerticalEdge(x,y);
	}

	void setThreshold(int threshold);
};

#endif

/*
* Change log :
* 
* $Log: RBallSpecialist2.h,v $
* Revision 1.3  2004/05/25 13:27:34  schmidtb
* modified version of rip for open-challenge
*
* Revision 1.5  2004/04/22 16:57:26  pg_besc
* new version of RBallSpecialist2, now omidirectional scans for detection
*
* Revision 1.4  2004/04/20 08:12:38  pg_besc
* fixed bug
*
* Revision 1.3  2004/04/20 07:50:27  pg_besc
* new version of pre scan
*
* Revision 1.2  2004/03/25 15:26:10  pg_besc
* made some changes
*
*
*
*/
