

// landmark 1 : (from top to bottom) yelloy, pink
// landmark 2 : (from top to bottom) pink, yellow
// landmark 3 : (from top to bottom) blue, pink
// landmark 4 : (from top to bottom) pink, blue


#ifndef BOXSPECIALIST_H
#define BOXSPECIALIST_H


#include "RasterSpecialist.h"
#include "Tools/Math/Geometry.h"
#include "Tools/Math/Vector2.h"
#include "RasterStrategy.h"
#include "Tools/Math/Vector3.h"
#include <list>
#include <vector>
#include <algorithm>
#include "Representations/Perception/LandmarksPercept.h"
#include "Modules/ImageProcessor/ImageProcessorTools/MSH2004EdgeDetection.h"

using namespace std;





float getDistanceToLine(const Geometry::Line,const Vector2<int>&);



class BoxSpecialist :public RasterSpecialist

{

public:
	
	struct Rectangle {
		Vector2<double> upperLeft;
		Vector2<double> upperRight;
		Vector2<double> bottomLeft;
		Vector2<double> bottomRight;
		Vector2<double> center;
	};

	struct SegmentInfo {
		SegmentInfo();
		
	/*	Vector2<int> maxHor;
		Vector2<int> minHor;
		Vector2<int> maxPHor;
		Vector2<int> minPHor;*/
		double lmValidityYellow;
		double lmValiditySkyblue;
		double goalValidity;
		Rectangle rect;
		int yellow;
		int skyblue;
		int pink;
		int size;
		colorClass bottomColor;
		colorClass topColor;
		list<LinePair>* segment;
	};

	typedef Geometry::Line Line;
	typedef vector<list<RasterSpecialist::LinePair> > SVector;



	BoxSpecialist(RasterImageProcessor &processor,RasterStrategy &strategy);
	virtual ~BoxSpecialist();
	void invokeOnPostScan(int x, int y);
	void executePostProcessing();
	void invokeOnPreScan(int x,int y);
	virtual int getType();
	virtual void init();

	colorClass ownGoalColor;

private:

	RasterStrategy *strategy;
	
	MSH2004EdgeDetection edgeScanner;
	
	std::list<LinePair> lst_pts;

	Geometry::Line horizon;
	Geometry::Line pHorizon;
	int foundFlags;
	int flagThreshold;
	int goalThreshold;

	Vector2 <int> left_border;

	std::vector<list<LinePair> > segments_img;
	std::vector<SegmentInfo> infos_img;
	std::vector<Rectangle> BBox_img;
	std::vector<Vector2<int> > bottomPoints;

	void createBBox();

	bool searchGoal(SegmentInfo& goal);     
	bool searchLandmark(SegmentInfo& flag);
	void fitLandmark(SegmentInfo &flag);
	void detectFreePartOfGoal();	

	inline int getColorID(colorClass&);
	inline colorClass getColorName(int id);

	void fusionGoal();
	inline int nbColors(int i);
	inline bool same_color(int i, int j);

	inline bool BBoxIsValid(int);

	void mergeBoxes(SegmentInfo& seg1,SegmentInfo& seg2);

	void countColors(SegmentInfo& si, list<LinePair>& segment);
	void validate();
	
	inline bool upperLeftOnCorner(int);
	inline bool upperRightOnCorner(int);
	inline bool bottomRightOnCorner(int);
	inline bool bottomLeftOnCorner(int);

	inline bool missingData(bool ulc, bool urc, bool brc, bool blc, int i);

	void calculateAnglesForPoint
	(
		const Vector2<double>& point, 
		const CameraMatrix& cameraMatrix, 
		const CameraInfo& cameraInfo, 
		Vector2<double>& angles
	);

	bool calculatePointOnField
	(
		const double x,
		const double y,
		const CameraMatrix& cameraMatrix,
		const CameraInfo& cameraInfo,
		Vector2<int>& pointOnField
	);

	void createValidities(SegmentInfo& info);

	inline bool isValidPoint(Vector2<double>& p){
		if (p.x >= imageWidth || p.x <= 0) return false;
		if (p.y >= imageHeight || p.y <= 0) return false;
		return true;
	}

};

#endif
