/**
* @file MSH2004FlagSpecialist.h
* 
* This file contains a class for Image Processing.
* @author <a href="mailto:walter.nistico@uni-dortmund.de">Walter Nistico</a>
* @author <A href=mailto:juengel@informatik.hu-berlin.de>Matthias Juengel</A>
*/

#ifndef __MSH2004FlagSpecialist_h_
#define __MSH2004FlagSpecialist_h_

#include "Tools/Debugging/DebugImages.h"

#include "MSH2004PixelFilter.h"
#include "Representations/Perception/ColorTable.h"
#include "Representations/Perception/LandmarksPercept.h"
#include "Representations/Perception/CameraMatrix.h"
#include "Tools/Math/Geometry.h"

/**
* 
* This is a (slightly) modified version of GT2003FlagSpecialist which supports MSH stuff
*
* As part of the MSH2004ImageProcessor the MSH2004FlagSpecialist searches for
* flag landmarks starting at a point in an Image determined before
*/
class MSH2004FlagSpecialist  
{
public:
  MSH2004FlagSpecialist();
  
  /** Initializes the flag specialist.*/
  void init(const Image& image);
  
  /** Searches for the ball in the image, starting from the specified point. */
  void searchFlags(
    const Image& image,
    const ColorTable& colorTable,
    const CameraMatrix& cameraMatrix,
    MSH2004PixelFilter& advPixFilter,
    colorClass color,
    bool pinkIsTop,
    const Geometry::Line horizonLine,
    int x, int y);
  
  void getFlagPercept(
    const CameraMatrix& cameraMatrix, 
    const CameraInfo& cameraInfo, 
    const Geometry::Line horizonLine,
    LandmarksPercept& landmarksPercept
    );


private:
  int imageWidth;
  int imageHeight;

// search for flags variables
  Vector2<int> north;
  Vector2<int> east;
  Vector2<int> south;
  Vector2<int> west;

  Vector2<int>start;
  Vector2<int>destination;

  void estimateOffsetForFlags(
   LandmarksPercept& landmarksPercept,
   const Vector2<double>& cameraOffset
   );

  enum {maxNumberOfBoundingBoxes = 6};
  double boundingBoxTop[maxNumberOfBoundingBoxes][6];
  double boundingBoxBottom[maxNumberOfBoundingBoxes][6];
  double boundingBoxLeft[maxNumberOfBoundingBoxes][6];
  double boundingBoxRight[maxNumberOfBoundingBoxes][6];

  bool boundingBoxTopValid[maxNumberOfBoundingBoxes][6];
  bool boundingBoxBottomValid[maxNumberOfBoundingBoxes][6];
  bool boundingBoxLeftValid[maxNumberOfBoundingBoxes][6];
  bool boundingBoxRightValid[maxNumberOfBoundingBoxes][6];

  int numberOfBoundingBoxes[6];

  int bestBoundingBox[6];

  enum Direction{up, down, left, right};

  bool findEndOfFlag(
    const Image& image,
    const ColorTable& colorTable,
    MSH2004PixelFilter& advPixFilter,
    const Vector2<int> start,
    Vector2<double> horizonDirection,
    Direction direction,
    Vector2<int>& destination,
    colorClass color,
    bool pinkIsTop,
    bool startIsInTop
    );

public:  
  /** Used for visualization of the flag scans*/
  DECLARE_DEBUG_IMAGE(imageProcessorFlags);
};

#endif// __MSH2004FlagSpecialist_h_

/*
* Change log :
* 
* $Log: MSH2004FlagSpecialist.h,v $
* Revision 1.3  2004/04/18 11:57:46  nistico
* Removed MSH2004ImageProcessor2 (integrated all changes into MSH2004ImageProcessor)
*
* Revision 1.1  2004/04/08 16:21:03  wachter
* GT04 checkin of Microsoft-Hellounds
*
*/
