/**
* @file GridImageProcessorTSL.h
* 
* This file contains a class for Image Processing.
* @author <a href=mailto:sebastian.deutsch@gmx.de>Sebastian Deutsch</a>
*
*/

#ifndef __GridImageProcessorTSL_h_
#define __GridImageProcessorTSL_h_

#include "Modules/ImageProcessor/ImageProcessor.h"
#include "Tools/Math/Geometry.h"
#include "Tools/Debugging/Debugging.h"
#include "Tools/Debugging/DebugDrawings.h"
#include "Tools/Debugging/DebugImages.h"

/**
* @class GridImageProcessorTSL
*
* A solution of the ImageProcessor module.
*
* @author Sebastian Deutsch
* @author Andr Osterhues
*
*/
class GridImageProcessorTSL : public ImageProcessor
{
public:
  GridImageProcessorTSL(const ImageProcessorInterfaces& interfaces);
  ~GridImageProcessorTSL();
  
  /** Executes the module */
  virtual void execute();

private:
  /** 
  * Calculates the position of the horizon in the image. 
  */
  Geometry::Line calculateHorizon(double& horizonAngle);

  bool calculateScanLine(int x1, int y1, int x2, int y2);

  void scanLine(const Image& image, const Geometry::Line horizonLine);

  /**calculates the horizon */
  void calculateHorizon(const CameraMatrix & cameraMatrix, double& x1, double& y1, double& x2, double& y2);
	
  enum{maxNumberOfPointsInScanLine = 228};

  char overWriteMe1[1000];

  int scanLineX[maxNumberOfPointsInScanLine]; 
  
  char overWriteMe2[1000];

  int scanLineY[maxNumberOfPointsInScanLine];
  
  char overWriteMe3[1000];
  
  int numberOfPointsInScanLine;

  int indexOfHorizonInScanLine;

  colorClass enemyColor;
  bool enemyFound;
  bool enemyStopScanning;
  int enemyScanlinesWithoutEnemyPixels;
  int enemyPixels;
  Vector2<int> enemyMostTop;
  Vector2<int> enemyMostLeft;
  Vector2<int> enemyMostRight;
  Vector2<int> enemyMostBottom;

  
  enum{justUP, greenAndUP, downY} state;
  enum{outsidePink, insidePink} flagState;
  enum{outsideGoalColor, insideGoalColor} goalState;

  /** Used for visualization of the scan lines and the "up" and "down" pixels*/
  DECLARE_DEBUG_IMAGE(imageProcessorGeneral);
  DECLARE_DEBUG_IMAGE(segmentedImage1);
};
#endif// __GridImageProcessorTSL_h_

/*
* Change log :
* 
* $Log: GridImageProcessorTSL.h,v $
* Revision 1.2  2004/03/08 01:39:01  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/06 14:10:15  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/09/01 10:16:17  juengel
* DebugDrawings clean-up 2
* DebugImages clean-up
* MessageIDs clean-up
* Stopwatch clean-up
*
* Revision 1.2  2003/07/29 12:41:51  juengel
* Removed getSizeByDistance
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2003/05/20 15:52:14  deutsch
* A TSL optimized grid image processor.
* not working yet.
*
* Revision 1.9  2003/04/09 04:40:53  deutsch
* now just one enemy is percept per frame to avoid very long enemys (scan 2 for 1).
*
* Revision 1.8  2003/04/02 00:06:51  deutsch
* Added X distance calculation for enemy detection.
*
* Revision 1.7  2003/04/01 04:27:09  deutsch
* Added enemy cognition.
*
* Revision 1.6  2003/03/31 16:30:31  osterhues
* Copied Ball-, Flag- and GoalSpecialist from GridImageProcessor
*
* Revision 1.5  2003/03/31 04:16:32  osterhues
* Added support for segmented image
*
* Revision 1.4  2003/03/27 03:21:53  deutsch
* no message
*
* Revision 1.3  2003/03/25 18:42:03  osterhues
* Imported code from GridImageProcessor
* Small optimizations
*
* Revision 1.2  2003/03/19 14:23:53  osterhues
* no message
*
* Revision 1.1  2003/03/04 15:41:55  osterhues
* no message
*
* Revision 1.3  2003/03/04 15:38:15  osterhues
* no message
*
* Revision 1.1  2003/03/04 15:02:21  osterhues
* Changed GridImageProcessorDo to GridImageProcessorTSL
*
* Revision 1.3  2003/02/17 16:36:02  deutsch
* no message
*
* Revision 1.2  2003/01/06 21:19:08  deutsch
* Horizon calculation added.
*
* Revision 1.1  2003/01/03 17:22:42  deutsch
* added class GridmageProcesserDo
*
*
*/
