/**
* @file GridImageProcessor2Parameters.h
* 
* Declaration of class GridImageProcessor2Parameters.
*
*/ 

#ifndef __GridImageProcessor2Parameters_h_
#define __GridImageProcessor2Parameters_h_

#include "Tools/Streams/InOut.h"
#include "Tools/MessageQueue/MessageIDs.h"

/**
* 
*/
class GridImageProcessor2Parameters
{
public:
  /** Constructor */ 
  GridImageProcessor2Parameters();

  /** Destructor */ 
  ~GridImageProcessor2Parameters();

  /** the distance between two vertical scan lines */
  int scanLineSpacing;
  
  /** The number of scan lines that is desired */
  int desiredNumberOfScanLines;

  /** */
  int threshold[3];

  bool enableAutoColorCalibration;

  bool enableThresholdCalibration;

  bool useFixedHorizon;

  bool useLongScanLinesOnly;

  bool resetAutoCalibration;

  bool setColorTableToDefault;
};

/**
 * Streaming operator that reads GridImageProcessor2Parameters from a stream.
 * @param stream The stream from which is read.
 * @param parameters The GridImageProcessor2Parameters object.
 * @return The stream.
 */ 
In& operator>>(In& stream, GridImageProcessor2Parameters& parameters);
 
/**
 * Streaming operator that writes GridImageProcessor2Parameters to a stream.
 * @param stream The stream to write on.
 * @param parameters The GridImageProcessor2Parameters object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const GridImageProcessor2Parameters& parameters);

#endif //__GridImageProcessor2Parameters_h_

/*
* Change log :
*
* $Log: GridImageProcessor2Parameters.h,v $
* Revision 1.2  2003/11/07 11:21:19  juengel
* GridImageProcessor2 has more parameters now.
*
* Revision 1.1  2003/10/06 14:10:15  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/08/18 12:08:19  juengel
* Removed some parameters.
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2003/05/05 12:02:45  juengel
* Moved GridImageProcessor2Parameters from DataTypes
*
* Revision 1.4  2003/04/03 18:50:46  juengel
* Added calibrationIsTolerant.
*
* Revision 1.3  2003/03/11 11:29:45  juengel
* Added useColorTable
*
* Revision 1.2  2003/03/05 12:35:29  dueffert
* bugs fixed
*
* 
*/
