/**
* @file DDD2004ImageProcessorTools.h
*
* Tools and Definitons for DDD2004ImageProcessor
*
* @author Max Risler
*/

#ifndef __DDD2004ImageProcessorTools_h_
#define __DDD2004ImageProcessorTools_h_

#include "Representations/Perception/ColorTable64.h"
#include "DDD2004ColorCorrector.h"

//#define COLOR_CLASS(y,u,v) colorTable.getColorClass(y,u,v)

// This is a hack to speed up color table access. It obviously only works with ColorTable64
#define COLOR_CLASS(y,u,v) (colorClass)((ColorTable64&) colorTable).colorClasses[(y) >> 2][(u) >> 2][(v) >> 2]
#define CORRECTED_COLOR_CLASS(px,py,y,u,v) (colorClass)((ColorTable64&) colorTable).colorClasses[colorCorrector.correctY(px,py,(y)) >> 2][colorCorrector.correctU(px,py,(u)) >> 2][colorCorrector.correctV(px,py,(v)) >> 2]

#endif // __DDD2004ImageProcessorTools_h_
/*
* Change log :
* 
* $Log: DDD2004ImageProcessorTools.h,v $
* Revision 1.2  2004/03/26 09:12:43  risler
* added DDD2004BallSpecialist
* moved ball related stuff from ImageProcessor to BallSpecialist
*
* Revision 1.1  2004/03/17 15:31:16  risler
* added DDD2004ColorCorrector
*
*
*/
