/**
* @file DDD2004FlagSpecialist.h
* 
* This file contains a class for Image Processing.
* @author <A href=mailto:juengel@informatik.hu-berlin.de>Matthias Juengel</A>
*/

#ifndef __DDD2004FlagSpecialist_h_
#define __DDD2004FlagSpecialist_h_

#include "Tools/Debugging/DebugImages.h"

#include "Representations/Perception/ColorTable.h"
#include "Representations/Perception/LandmarksPercept.h"
#include "Representations/Perception/CameraMatrix.h"
#include "Tools/Math/Geometry.h"
#include "DDD2004ColorCorrector.h"


/**
* As part of the GridImageProcessor the DDD2004FlagSpecialist searches for
* flag landmarks starting at a point in an Image determined before
*/
class DDD2004FlagSpecialist  
{
public:
  DDD2004FlagSpecialist(const DDD2004ColorCorrector&);
  
  /** Initializes the flag specialist.*/
  void init(const Image& image);
  
  /** Searches for the ball in the image, starting from the specified point. */
  void searchFlags(
    const Image& image,
    const ColorTable& colorTable,
    const CameraMatrix& cameraMatrix,
    colorClass color,
    bool pinkIsTop,
    const Geometry::Line horizonLine,
    int x, int y);
  
  void getFlagPercept(
    const CameraMatrix& cameraMatrix, 
    const CameraInfo& cameraInfo, 
    const Geometry::Line horizonLine,
    LandmarksPercept& landmarksPercept
    );

/*  LandmarksPercept calculateLandmarksPercept(
    const CameraMatrix& cameraMatrix,
    Geometry::Circle& circle);
    */

private:

  const DDD2004ColorCorrector& colorCorrector;

  int imageWidth;
  int imageHeight;

// search for flags variables
  Vector2<int> north;
  Vector2<int> east;
  Vector2<int> south;
  Vector2<int> west;

  /*
  Vector2<double> north;
  Vector2<double> east;
  Vector2<double> south;
  Vector2<double> west;
*/
  Vector2<int>start;
  Vector2<int>destination;

  void estimateOffsetForFlags(
   LandmarksPercept& landmarksPercept,
   const Vector2<double>& cameraOffset
   );

  enum {maxNumberOfBoundingBoxes = 6};
  enum {numberOfHorizontalScans = 5, numberOfVerticalScans = 3};
/*
  enum FlagType {
    pinkYellow, //pink is top
    pinkGreen,
    pinkSkyblue,
    yellowPink,
    greenPink, //pink is bottom
    skybluePink,
    numberOfFlagTypes};
*/
  double boundingBoxTop[maxNumberOfBoundingBoxes][6];
  double boundingBoxBottom[maxNumberOfBoundingBoxes][6];
  double boundingBoxLeft[maxNumberOfBoundingBoxes][6];
  double boundingBoxRight[maxNumberOfBoundingBoxes][6];

  bool boundingBoxTopValid[maxNumberOfBoundingBoxes][6];
  bool boundingBoxBottomValid[maxNumberOfBoundingBoxes][6];
  bool boundingBoxLeftValid[maxNumberOfBoundingBoxes][6];
  bool boundingBoxRightValid[maxNumberOfBoundingBoxes][6];

  int numberOfBoundingBoxes[6];

  int bestBoundingBox[6];

  enum Direction{up, down, left, right};
  enum DebugType{initial, vertical, horizontal};

  bool findEndOfFlag(
    const Image& image,
	const CameraInfo& bwCameraInfo, 
    const ColorTable& colorTable,
    const Vector2<int> start,
    Vector2<double> horizonDirection,
    Direction direction,
    Vector2<int>& destination,
    colorClass color,
    bool pinkIsTop,
    bool startIsInTop,
    DebugType type,
    int& countPixel,
    int& countTop,
    int& countBottom
    );

public:  
  /** Used for visualization of the flag scans*/
  DECLARE_DEBUG_IMAGE(imageProcessorFlags);
};


#endif// __DDD2004FlagSpecialist_h_

/*
* Change log :
* 
* $Log: DDD2004FlagSpecialist.h,v $
* Revision 1.5  2004/05/04 13:55:50  tim
* changed include statements
*
* Revision 1.4  2004/04/07 12:28:57  risler
* ddd checkin after go04 - first part
*
* Revision 1.3  2004/03/31 12:24:00  park
* works now woth BW Images
*
* Revision 1.2  2004/03/29 13:48:48  Charlie
* added pixel ratio
*
* Revision 1.3  2004/03/27 18:40:45  petters
* improved flag detection - using average values instead of min/max
*
* Revision 1.2  2004/03/17 15:31:16  risler
* added DDD2004ColorCorrector
*
* Revision 1.1  2004/03/16 14:16:06  risler
* cloned GT2003ImageProcessor to DDD2004ImageProcessor
*
* Revision 1.2  2003/12/15 11:47:04  juengel
* Introduced CameraInfo
*
* Revision 1.1  2003/10/06 14:10:15  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.4  2003/09/26 15:27:49  juengel
* Renamed DataTypes to representations.
*
* Revision 1.3  2003/09/01 10:05:08  juengel
* DebugDrawings clean-up 2
* DebugImages clean-up
* MessageIDs clean-up
* Stopwatch clean-up
*
* Revision 1.2  2003/07/29 12:44:56  juengel
* Removed getDistanceBySize
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2003/05/04 17:31:52  roefer
* Flag and goal specialists added to GT2003IP
*
* Revision 1.10  2003/04/15 17:19:43  risler
* moved DDDGO2003 ImageProcessor to own module
* removed ContinuousBasicBehaviorTester
*
* Revision 1.8  2003/02/19 14:59:55  roefer
* pColorTable -> colorTable
*
* Revision 1.7  2003/02/18 21:29:16  osterhues
* Changed all instances of ColorTable64 to new base class ColorTable
*
* Revision 1.6  2002/11/26 12:25:12  dueffert
* doxygen docu added
*
* Revision 1.5  2002/09/22 18:40:51  risler
* added new math functions, removed GTMath library
*
* Revision 1.4  2002/09/22 09:15:33  risler
* Geometry.h moved to directory Math
*
* Revision 1.3  2002/09/19 23:38:53  juengel
* Changed debug image mechanisms.
*
* Revision 1.2  2002/09/17 23:55:21  loetzsch
* - unraveled several datatypes
* - changed the WATCH macro
* - completed the process restructuring
*
* Revision 1.1  2002/09/10 15:36:15  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.1  2002/09/07 13:36:57  loetzsch
* unified the vision modules into one module "ImageProcessor"
* - FloodFillRLEImageProcessor, BallPerceptor, LandmarksPerceptor
*   and PlayersPerceptor were are combined to the new solution
*   "BlobImageProcessor"
* - The GridImageProcessor and the SubPixelGradientCalculator became
*   a solution of "ImageProcessor"
*
* Revision 1.4  2002/09/03 16:01:41  juengel
* Some comments added.
*
* Revision 1.3  2002/07/23 13:33:39  loetzsch
* new streaming classes
*
* removed many #include statements
*
* Revision 1.2  2002/06/01 10:14:43  juengel
* Improved recognition of flags close to the border of the image.
*
* Revision 1.1.1.1  2002/05/10 12:40:14  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.5  2002/04/08 19:49:54  juengel
* goals added.
*
* Revision 1.4  2002/04/05 18:30:47  juengel
* no message
*
* Revision 1.3  2002/04/05 13:42:03  juengel
* Step by step ...
*
* Revision 1.2  2002/04/04 18:43:58  juengel
* GT2003FlagSpecialist improved.
*
* Revision 1.1  2002/04/02 10:30:34  juengel
* GridImageProcessor enhanced.
*
*/
