/**
* @file Xabsl2HeadControl.h
* 
* Implementation of class Xabsl2HeadControl.
*
* @author Martin Ltzsch
*/

#ifndef __Xabsl2HeadControl_h_
#define __Xabsl2HeadControl_h_

#include "HeadControl.h"
#include "Tools/Xabsl2/GT/GTXabsl2EngineExecutor.h"


/**
* @class Xabsl2HeadControl
*
* Base class for all HeadControl solutions that use a Xabsl2Engine
*
* @author Martin Ltzsch
*/ 
class Xabsl2HeadControl : public HeadControl, public GTXabsl2EngineExecutor
{
public:
/** 
* Constructor.
* @param interfaces The paramters of the HeadControl module.
* @param id The id of the Xabsl2Engine.
  */
  Xabsl2HeadControl(const HeadControlInterfaces& interfaces, 
    SolutionRequest::xabsl2EngineID id);
  
  /** destructor */
  ~Xabsl2HeadControl() {};

  /** 
  * Is called for every incoming debug message.
  * @param message An interface to read the message from the queue
  * @return if the messag was read
  */
  virtual bool handleMessage(InMessage& message);
  
protected:

  /** Is called if the engine could not be created */
  virtual void executeIfEngineCouldNotBeCreated();

  /** 
  * Prints the main action that was generated by the execution of the engine to a string
  * @param buf the string where to print the action
  */
  virtual void printGeneratedMainActionToString(char* buf);

};

/**
* Allows to register the same Xabsl2HeadControl instance more than once
* at a ModuleHandler to be able to switch between different agents using the
* GT Module mechanism.
*/
class Xabsl2HeadControlAgentInterface : public HeadControl, public Xabsl2NamedItem
{
public:
/**
* Constructor
* @param name The name of the agent
* @param headControl A newly created Xabsl2HeadControl can contains the agent.
* @param interfaces The paramters of the HeadControl module.
  */
  Xabsl2HeadControlAgentInterface(const char* name,
    Xabsl2HeadControl* headControl,
    const HeadControlInterfaces& interfaces);
  
  /** Destructor. Deletes the Xabsl2HeadControl */
  ~Xabsl2HeadControlAgentInterface();

  /** Executes the agent */
  virtual void execute();
  
  /** 
  * Is called for every incoming debug message.
  * @param message An interface to read the message from the queue
  * @return if the messag was read
  */
  virtual bool handleMessage(InMessage& message);
  
private:
  /** A pointer to the Xabsl2HeadControl can contains the agent. */
  Xabsl2HeadControl* headControl;
};

#endif// __Xabsl2HeadControl_h_

/*
* Change log :
* 
* $Log: Xabsl2HeadControl.h,v $
* Revision 1.1  2004/05/14 11:37:08  loetzsch
* support for multiple xabsl2engines in different modules
* preliminary GT2004HeadControl (does not work at all)
*
*/
