/**
* @file Xabsl2HeadControl.cpp
* 
* Implementation of class Xabsl2HeadControl.
*
* @author Martin Ltzsch
*/

#include "Xabsl2HeadControl.h"
#include "Platform/GTAssert.h"

Xabsl2HeadControl::Xabsl2HeadControl
(const HeadControlInterfaces& interfaces,
 SolutionRequest::xabsl2EngineID id
 ) : 
HeadControl(interfaces), GTXabsl2EngineExecutor(id,SolutionRequest::headControl)
{
}

void Xabsl2HeadControl::executeIfEngineCouldNotBeCreated()
{
  headMotionRequest.pan = 1500000;
  headMotionRequest.tilt = 1000000;
  headMotionRequest.roll = 0;
  headMotionRequest.mouth = -700000;
}

void Xabsl2HeadControl::printGeneratedMainActionToString(char* buf)
{
  sprintf(buf, "%li, %li, %li",
    headMotionRequest.pan, 
    headMotionRequest.tilt, 
    headMotionRequest.roll);
}

bool Xabsl2HeadControl::handleMessage(InMessage& message)
{
  return GTXabsl2EngineExecutor::handleMessage(message);
}

Xabsl2HeadControlAgentInterface::Xabsl2HeadControlAgentInterface
(const char* name,
 Xabsl2HeadControl* headControl,
 const HeadControlInterfaces& interfaces
 ) : 
HeadControl(interfaces), Xabsl2NamedItem(name), headControl(headControl)
{
  ASSERT(headControl != 0);
}

Xabsl2HeadControlAgentInterface::~Xabsl2HeadControlAgentInterface()
{
  if (headControl != 0) delete headControl;
}

void Xabsl2HeadControlAgentInterface::execute()
{
  ASSERT(headControl != 0);
  headControl->setSelectedAgent(n);
  headControl->execute();
}

bool Xabsl2HeadControlAgentInterface::handleMessage(InMessage& message)
{
  ASSERT(headControl != 0);
  return headControl->handleMessage(message);
}

/*
* Change log :
* 
* $Log: Xabsl2HeadControl.cpp,v $
* Revision 1.3  2004/05/17 18:35:22  loetzsch
* continued support for multiple Xabsl engines in different modules
*
* Revision 1.2  2004/05/14 22:53:07  roefer
* Warnings removed
*
* Revision 1.1  2004/05/14 11:37:08  loetzsch
* support for multiple xabsl2engines in different modules
* preliminary GT2004HeadControl (does not work at all)
*
*/

