/**
* @file CollisionDetectorSelector.h
*
* Definition of class CollisionDetectorSelector
*
* @author Daniel Ghring
*/

#ifndef __CollisionDetectorSelector_h_
#define __CollisionDetectorSelector_h_

#include "Tools/Module/ModuleSelector.h"

#include "DefaultCollisionDetector.h"

/**
* CollisionDetector selection module.
*
* A selector for collision detector modules.
*/
class CollisionDetectorSelector : public ModuleSelector, public CollisionDetectorInterfaces
{
public:
/**
* Constructor.
* @param handler The module handler of the process.
* @param interfaces The paramters of the CollisionDetector module.
  */
  CollisionDetectorSelector(ModuleHandler &handler, const CollisionDetectorInterfaces& interfaces)
    : ModuleSelector(SolutionRequest::collisionDetector),
    CollisionDetectorInterfaces(interfaces)
  {
    handler.setModuleSelector(SolutionRequest::collisionDetector, this);
  }
  
  /** 
  * Is called on start and when the selected solution changes
  * to create a specific solution.
  * @param id The id of the solution to create
  * @return The created solution or 0
  */
  virtual Module* createSolution(SolutionRequest::ModuleSolutionID id)
  {
    switch(id)
    {
    case SolutionRequest::defaultCollisionDetector:
      return new DefaultCollisionDetector(*this);
      
    default:
      return 0;
    }
  }
};

#endif // CollisionDetectorSelector_h_

/*
* Change log :
* 
* $Log: CollisionDetectorSelector.h,v $
* Revision 1.3  2004/03/08 01:38:48  roefer
* Interfaces should be const
*
* Revision 1.2  2004/01/21 14:31:58  loetzsch
* Module Selectors create only the selected solution.
* When the solution changes, the old solution is erased and the new
* one ist created using createSolution(..)
*
* Revision 1.1  2003/10/06 14:10:14  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2003/04/25 19:48:08  goehring
* Added new module CollisionDetector
*
* 
*/
