/**
* @file Xabsl2BehaviorControl.cpp
* 
* Implementation of class Xabsl2BehaviorControl.
*
* @author Uwe Dffert
* @author Jan Hoffmann
* @author Matthias Jngel
* @author Martin Ltzsch
*/

#include "Xabsl2BehaviorControl.h"
#include "Platform/GTAssert.h"

Xabsl2BehaviorControl::Xabsl2BehaviorControl
(const BehaviorControlInterfaces& interfaces,
 SolutionRequest::xabsl2EngineID id
 ) : 
BehaviorControl(interfaces), GTXabsl2EngineExecutor(id,SolutionRequest::behaviorControl)
{
}

void Xabsl2BehaviorControl::executeIfEngineCouldNotBeCreated()
{
    motionRequest.motionType = MotionRequest::specialAction;
    motionRequest.specialActionType = MotionRequest::scratchHead;
}

void Xabsl2BehaviorControl::printGeneratedMainActionToString(char* buf)
{
  executedMotionRequest.printOut(buf);
}

bool Xabsl2BehaviorControl::handleMessage(InMessage& message)
{
  return GTXabsl2EngineExecutor::handleMessage(message);
}

Xabsl2BehaviorControlAgentInterface::Xabsl2BehaviorControlAgentInterface
(const char* name,
 Xabsl2BehaviorControl* behaviorControl,
 const BehaviorControlInterfaces& interfaces
 ) : 
BehaviorControl(interfaces), Xabsl2NamedItem(name), behaviorControl(behaviorControl)
{
  ASSERT(behaviorControl != 0);
}

Xabsl2BehaviorControlAgentInterface::~Xabsl2BehaviorControlAgentInterface()
{
  if (behaviorControl != 0) delete behaviorControl;
}

void Xabsl2BehaviorControlAgentInterface::execute()
{
  ASSERT(behaviorControl != 0);
  behaviorControl->setSelectedAgent(n);
  behaviorControl->execute();
}

bool Xabsl2BehaviorControlAgentInterface::handleMessage(InMessage& message)
{
  ASSERT(behaviorControl != 0);
  return behaviorControl->handleMessage(message);
}

/*
* Change log :
* 
* $Log: Xabsl2BehaviorControl.cpp,v $
* Revision 1.11  2004/05/17 18:35:22  loetzsch
* continued support for multiple Xabsl engines in different modules
*
* Revision 1.10  2004/05/14 11:37:08  loetzsch
* support for multiple xabsl2engines in different modules
* preliminary GT2004HeadControl (does not work at all)
*
* Revision 1.9  2004/03/08 00:58:52  roefer
* Interfaces should be const
*
* Revision 1.8  2004/01/21 14:31:58  loetzsch
* Module Selectors create only the selected solution.
* When the solution changes, the old solution is erased and the new
* one ist created using createSolution(..)
*
* Revision 1.7  2003/12/16 18:54:06  loetzsch
* the message "created a new engine ......" is only displayed when no errors occured
*
* Revision 1.6  2003/10/26 22:49:34  loetzsch
* created ATH2004BehaviorControl from GT2003BehaviorControl
*  - strongly simplified option graph
*  - moved some symbols from GT2003 to CommonXabsl2Symbols
*  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
*
* cloned ATH2004 three times (BB2004, DDD2004, MSH2004)
*
* Revision 1.5  2003/10/08 11:50:09  loetzsch
* made the Xabsl2Engine really platform independent
* (removed inclusion of Platform/SystemCall.h)
* A time function is given to the engine by parameter.
*
* Revision 1.4  2003/09/30 10:51:13  dueffert
* typos fixed
*
* Revision 1.3  2003/09/20 16:34:13  loetzsch
* renamed "following-option-..." to "subsequent-option-.." and
* "following-basic-behavior-.." to "subsequent-basic-behavior-.."
* for consistency with publications
*
* Revision 1.2  2003/09/16 13:27:20  loetzsch
* changed all occurrences of "option tree" to "option graph"
*
* Revision 1.1  2003/07/21 19:18:05  loetzsch
* - Xabsl2 AND and OR operators now can contain more than 2 operands
* - speed improvements and cleanup
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.31  2003/06/20 15:32:32  dueffert
* getting from down from wall by rolling added
*
* Revision 1.30  2003/05/25 22:36:32  loetzsch
* only when an output symbol was set during the execution of the graph,
* coresponding function is invoked or the coresponding variable is changed.
*
* Revision 1.29  2003/03/31 17:42:03  risler
* no message
*
* Revision 1.28  2003/03/06 11:45:30  dueffert
* re-order warning removed
*
* Revision 1.27  2003/03/03 11:56:48  dueffert
* getup if crashed improved
*
* Revision 1.26  2003/03/03 10:45:15  dueffert
* getup if crashed added
*
* Revision 1.25  2003/02/27 15:23:58  juengel
* Debug messages are only sent, if the debug key sendXabsl2DebugMessages is active.
*
* Revision 1.24  2003/02/01 14:41:10  risler
* missing input source was not detected correctly
*
* Revision 1.23  2003/01/29 11:53:47  loetzsch
* Added setting of changed output symbols in handleMessage
*
* Revision 1.22  2003/01/29 10:36:07  juengel
* Xabsl2Dialog sends the selected option/basic behavior, the parameters,
* and the output symbols to be changed.
*
* Revision 1.21  2003/01/28 18:07:47  loetzsch
* no message
*
* Revision 1.20  2003/01/28 17:38:22  loetzsch
* executeRootOption is called for debug mode executeRootOption.
*
* Revision 1.19  2003/01/22 18:09:23  loetzsch
* continued implementation of sending of intermediate code from xabsl2 dialog
* to a xabsl2 behavior control
*
* Revision 1.18  2003/01/21 21:02:09  loetzsch
* xabsl2 intermediate code now can be handled by Xabsl2BehaviorControl
*
* Revision 1.17  2003/01/21 20:36:14  loetzsch
* xabsl2 intermediate code now can be handled by Xabsl2BehaviorControl
*
* Revision 1.16  2003/01/20 08:14:16  loetzsch
* added xabsl2BehaviorControlID to the solutionRequest to distinct between the
* different Xabsl2BehaviorControls
*
* Revision 1.15  2003/01/19 13:04:51  loetzsch
* xabsl2 agents now can be changed by using the Module and SolutionRequest
* mechanism
*
* Revision 1.14  2003/01/18 21:46:11  loetzsch
* fixed a bug in sendDebugMessage
*
* Revision 1.13  2003/01/15 14:53:50  juengel
* Watched enumerated input symbols and watched output symbols are sent.
*
* Revision 1.12  2003/01/13 22:39:38  loetzsch
* implemented the execution of the engine.
*
* Revision 1.11  2003/01/13 18:28:01  juengel
* Option parameters are sent.
*
* Revision 1.10  2003/01/13 10:31:43  juengel
* XabslDebugMessage extended. Xabsl2Dialog shows option activation path.
*
* Revision 1.9  2003/01/12 14:54:05  loetzsch
* continued creation of option tree: Xabsl2Statement and derivates added
*
* Revision 1.8  2003/01/11 21:58:11  roefer
* Unused variables removed
*
* Revision 1.7  2003/01/11 18:38:38  juengel
* Xabsl2ehavior sends Xabsl2DebugMessages now.
*
* Revision 1.6  2003/01/11 14:41:42  loetzsch
* continued creation of the option tree
*
* Revision 1.5  2003/01/11 13:29:55  juengel
* Xabsl2Dialog sends Xabsl2DebugRequest now.
*
* Revision 1.4  2003/01/09 17:28:33  loetzsch
* introduced Xabsl2Agent, continued Xabsl2Option
*
* Revision 1.3  2003/01/09 10:01:20  loetzsch
* added interfaces to the Xabsl2 Dialog in the RobotControl application
*
* Revision 1.2  2003/01/08 15:22:34  loetzsch
* - started implementation of the option tree
* - started the reading of the intermediate code
*
* Revision 1.1  2002/12/18 11:02:02  loetzsch
* - moved common parts of Humboldt2003BehaviorControl to new base class Xabsl2BehaviorControl
* - Xabsl2BehaviorControl shall become the base class for all BehaviorControl solutions based on the Xabsl2Engine
*
*/

