/**
* @file MotionRatingBehaviorMessage.cpp
* 
* Implementation of class MotionRatingBehaviorMessage
*
* @author Sebastian Petters
* @author Dirk Thomas
*/

#include "MotionRatingBehaviorMessage.h"

MotionRatingBehaviorMessage::MotionRatingBehaviorMessage()
{
  // nothing to do so far
}

In& operator>>(In& stream,MotionRatingBehaviorMessage& message)
{
  int temp;
  stream >> temp;
  message.type = (MotionRatingBehaviorMessage::MessageType)temp;
  stream >> temp;
  message.state = (MotionRatingBehaviorMessage::States)temp;
  stream >> message.paramSetId;
  stream >> message.data;
  stream >> message.currentSpeed;
  stream >> message.averageSpeed;
  stream >> message.currentWalk;
  stream >> message.walkCount;
  stream >> message.distance;
  stream >> message.time;
  stream >> temp;
  message.finished = (temp==1) ? true : false;
  stream >> message.remainingPower;
  
  return stream;
}
 
Out& operator<<(Out& stream, const MotionRatingBehaviorMessage& message)
{
  stream << (int)message.type;
  stream << (int)message.state;
  stream << message.paramSetId;
  stream << message.data;
  stream << message.currentSpeed;
  stream << message.averageSpeed;
  stream << message.currentWalk;
  stream << message.walkCount;
  stream << message.distance;
  stream << message.time;
  stream << (int)(message.finished ? 1 : 0);
  stream << message.remainingPower;
  
  return stream;
}

/*
* Change log :
* 
* $Log: MotionRatingBehaviorMessage.cpp,v $
* Revision 1.1  2004/03/17 16:18:49  thomas
* added preversion of motion optimisation with behaviour, selflocator, headcontrol and robotcontrol dialog
*
*
*/
