/**
* @file MotionRatingBehaviorControl.h
* 
* Implementation of class MotionRatingBehaviorControl.
*
* @author Dimitri Idessis
* @author Eduardo Tsen
* @author Sebastian Petters
* @author Dirk Thomas
*/

#ifndef __MotionRatingBehaviorControl_h_
#define __MotionRatingBehaviorControl_h_

#include "../BehaviorControl.h"
#include "Tools/Module/SolutionRequest.h"

#include "MotionRatingBehaviorMessage.h"

/**
* @class MotionRatingBehaviorControl
*
* A Behavior that is used by the Darmstadt Dribbling Dackels
* for the RoboCup German Open 2004.
*
* Praktikum-Group: determine walk-speed and valuate stability of walk-type
*
*/ 
class MotionRatingBehaviorControl : public BehaviorControl
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the BehaviorControl module.
  */
  MotionRatingBehaviorControl(BehaviorControlInterfaces& interfaces);
  
  /** destructor */
  ~MotionRatingBehaviorControl();
  
  virtual bool handleMessage(InMessage& message);
  virtual void execute();

protected:
  enum { sleep, prepare, wait, localisepre, walk, stop, localiseaft, report };

  unsigned long pingTimeout;
  unsigned long lastMessage;

  int path;
  int state;
  int paramSetId;
  int walkCount;
  int currentWalk;
  bool paused;

  double distTolerance;
  double angleTolerance;

  struct Path {
    Pose2D start;
    Pose2D end;
  };

  int pathOffset;

  Path paths[3];

  Pose2D startpoint, endpoint;

  unsigned long starttime;
  unsigned long endtime;
  unsigned long startlocalise;

  double totalDistance;
  unsigned long totalTime;

  Vector2<double> p1, p2;

private:
  
  void reset();
  void setPoints();

  bool gotoPoint ( Pose2D );
  bool gotoPoint ( Vector2<double> );
  void setWalkMotionRequest ( double distance, double phi, double theta );

  void stand();
  void playDead();
  
  bool localise();

  MotionRatingBehaviorMessage::States encodeState();


};

#endif// __MotionRatingBehaviorControl_h_

/*
* Change log :
* 
* $Log: MotionRatingBehaviorControl.h,v $
* Revision 1.1  2004/03/17 16:18:49  thomas
* added preversion of motion optimisation with behaviour, selflocator, headcontrol and robotcontrol dialog
*
*
*/
