/** 
* @file MSH2004KickEngineSymbols.h
*
* Declaration of class MSH2004KickEngineSymbols.
*
* @author Carsten Schumann
*/

#ifndef __OpenChallengeSymbols_h_
#define __OpenChallengeSymbols_h_

#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"
#include "../../BehaviorControl.h"
#include "Tools/SlidingAverageValue.h"

/**
 *  Imported from WM-Repository
 *  BEGIN
 */

typedef struct OC
{
  double type;
  double x;
  double y;
  double rotation;
} OC;

/**
 *  END
 *  Imported from WM-Repository
 */


class OpenChallengeSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
  /*
  * Constructor.
  * @param interfaces The paramters of the BehaviorControl module.
  */
  OpenChallengeSymbols(const BehaviorControlInterfaces& interfaces);
  void registerSymbols(Xabsl2Engine& engine);
  enum CRIP{
      unchanged,
      rip
  };
  void setRIP(int t);

  double redLineInImageAngle();
  double redLineAngle();
  bool redLineKnown();

  /** sensor data */
  double getSensorPSDNear();
  double getSensorPSDFar();
  double getSensorAccelerationX();
  double getSensorAccelerationY();
  double getSensorAccelerationZ();

  /** Ramp Symbols */
  double getAiboOnRamp();
  double getRampTimeSinceLastSeen();
  double getRampDistanceToEndPoint();
  double getRampAngleOfRedLine();
  double getRampLowestLinePointY();
  double getRampLowestLinePointX();
  double getRampHighestLinePointY();
  double getRampHighestLinePointX();
  double getRampDistanceToStartPoint();
  /** /RampSymbols */

  /** Bite-Mark Symbols */
  double getBiteAngleFrontLeft();
  double getBiteDistanceFrontLeft();
  double getAverageBiteDistanceFL();
  double getBiteOffsetFrontLeft();
  double getBiteRelativeXFrontLeft();
  double getBiteRelativeYFrontLeft();
  double getBiteTimeSinceLastSeenFrontLeft();

  double getBiteAngleFrontRight();
  double getBiteDistanceFrontRight();
  double getAverageBiteDistanceFR();
  double getBiteOffsetFrontRight();
  double getBiteRelativeXFrontRight();
  double getBiteRelativeYFrontRight();
  double getBiteTimeSinceLastSeenFrontRight();

  double getBiteAngleBehindRight();
  double getBiteDistanceBehindRight();
  double getAverageBiteDistanceBR();
  double getBiteOffsetBehindRight();
  double getBiteRelativeXBehindRight();
  double getBiteRelativeYBehindRight();
  double getBiteTimeSinceLastSeenBehindRight();

  double getBiteAngleBehindLeft();
  double getBiteDistanceBehindLeft();
  double getAverageBiteDistanceBL();
  double getBiteOffsetBehindLeft();
  double getBiteRelativeXBehindLeft();
  double getBiteRelativeYBehindLeft();
  double getBiteTimeSinceLastSeenBehindLeft();

  int frame;
/**
 *  Imported from WM-Repository
 *  BEGIN
 */

  enum OCStatus
  {
    initial = 0,
    intro,
    goToBridge,
    goToBitePoint,
    allBitePointsReady,
    walkWithBridge,
    extro,
    finished
  };

  enum OCSetStatus
  {
    setInitial = 0,
    setIntro,
    setGoToBridge,
    setGoToBitePoint,
    setMyBitePointIsReady,
    setLostMyBitePoint,
    setWalkWithBridge,
    setExtro,
    setFinished
  };

  /** updates the symbols */
  void update();


  //!@name Input symbols
  //!@{
  OCBridge::Side getLastSeenSide();    /*!< A function for the symbol "bridge.last-seen-side" */
  double getSeenDistanceToBridge();    /*!< A function for the symbol "bridge.seen.distance" */
  double getSeenAngleToBridge();       /*!< A function for the symbol "bridge.seen.angle" */
  double getTimeSinceLastSeenBridge(); /*!< A function for the symbol "bridge.time-since-last-seen" */

  BitePoint::Position getBitePointPosition(); /*!< A function for the symbol "bite-point.position" */
  double getSeenDistanceToBitePoint();        /*!< A function for the symbol "bite-point.seen.distance" */
  double getSeenAverageDistanceToBitePoint();    /*!< A function for the symbol "bite-point.seen.avg-distance" */
  double getSeenAngleToBitePoint();           /*!< A function for the symbol "bite-point.seen.angle" */
  double getPreciseShiftToBitePoint();        /*!< A function for the symbol "bite-point.precise-shift" */
  double getAvgShiftToBitePoint();
  double getTimeSinceLastSeenBitePoint();     /*!< A function for the symbol "bite-point.time-since-last-seen" */

  double getIRRadarMaxAngle();     /*!< A function for the symbol "ir-radar-min-angle" */

  //!@}


  /** Varaible to hold the open challenge status */
  OCStatus ocStatus;

  /* A function for the output symbol "open-challenge.set-status". */
  void setOCStatus(int aStatus);

  void setOCStatusDtt(int aStatus);

  int bitePointToUse[Player::numOfPlayerNumbers];
  int masterDog;

  /* A function for the output symbol "open-challenge.ir-radar". */
  void setIRRadar(int aStatus);
  int irRadarStatus;
  double irMaxDist;
  double irMaxAngle;

private:
  OC m_walkRequest;
  double m_headrot;

  bool bitePointReady[BitePoint::numOfPositions];

  SlidingAverageValue xspeed;
  SlidingAverageValue groundVal;

  SlidingAverageValue avgOffset;
  SlidingAverageValue avgBiteDistance;



  int learnAcc;

/**
 *  END
 *  Imported from WM-Repository
 */

  int ambVal;

};

#endif


/*
* 
* $Log: OpenChallengeSymbols.h,v $
* Revision 1.22  2004/06/21 16:46:34  kerdels
* some new symbols
*
* Revision 1.21  2004/06/21 15:33:51  kerdels
* some new symbols
*
* Revision 1.20  2004/06/18 17:29:46  hamerla
* oc bite
*
* Revision 1.19  2004/06/17 09:47:48  hamerla
* OC rollenzuteilung
*
* Revision 1.18  2004/06/14 20:14:23  kerdels
* added further symbols for sequence-control of the openchallenge
*
* Revision 1.17  2004/06/09 16:01:08  serwe
* added avarage-bitepoint-offset symbol
*
* Revision 1.16  2004/06/09 15:26:22  koh
* changed avr to avg
*
* Revision 1.15  2004/06/09 15:17:15  koh
* little changes to average bite point distance calculation
*
* Revision 1.14  2004/06/07 16:00:57  hamerla
* OptionRation fr OpenChallenge
*
* Revision 1.13  2004/06/06 22:32:49  koh
* added functions to handle xabsl-symbols of average distance to Bite Points
*
* Revision 1.12  2004/06/04 11:35:23  kerdels
* fixed find-climb-runover-ramp...
*
* Revision 1.11  2004/06/03 22:30:40  kerdels
* created auto-learning threshold
*
* Revision 1.10  2004/06/03 16:55:55  kerdels
* averaged AccelartionSymbols in OpenChallenge
*
* Revision 1.9  2004/06/02 22:40:34  kerdels
* merged OpenChallengeSymbols from WM-Repository...
*
* Revision 1.8  2004/05/30 17:21:38  hamerla
* oc some more symbols and testoptions
*
* Revision 1.7  2004/05/28 14:19:25  huelsbusch
* Image-Prozessor switching (per xabsl) eingebaut
*
* Revision 1.6  2004/05/28 10:34:32  schumann
* can find ramp now
*
* Revision 1.5  2004/05/28 08:37:29  koh
* added ramp.highest-line-point.x and ramp.highest-line-point.y
*
* Revision 1.4  2004/05/27 19:44:47  schumann
* bugfix in angleInImage
*
* Revision 1.3  2004/05/27 13:47:52  schmidtb
* further work on open-challenge
*
* Revision 1.2  2004/05/26 16:21:09  serwe
* added symbols for rampclimbing
*
* Revision 1.1  2004/05/26 14:39:40  schumann
* some symbols for the challenge
*
*/

