/**
* @file OpenChallangeSymbols.cpp
* 
*
* @author Carsten Schumann (schumann@tempus-vivit.net)
*/
 
#include "OpenChallengeSymbols.h"
bool g_changetorip(false);
#include "../OpenChallengeDefines.h"
#ifdef OPENCHALLENGE_DEFINES
OCSetStatus2 ocstate(dtt_initial);
#endif
//----------------------------------------------------------------------------
 
//----------------------------------------------------------------------------
OpenChallengeSymbols::OpenChallengeSymbols(const BehaviorControlInterfaces& interfaces)
: BehaviorControlInterfaces(interfaces)
{

/**
 *  Imported from WM-Repository
 *  BEGIN
 */

  ocStatus = initial;

  m_walkRequest.type = 0;
  m_walkRequest.x = 0;
  m_walkRequest.y = 0;
  m_walkRequest.rotation = 0;

  int i;
  for (i = 0; i < BitePoint::numOfPositions; ++i)
    bitePointReady[i] = false;

  // mapping player numbers to bitePoints
  // change mapping here, if u want to
  bitePointToUse[Player::one]   = BitePoint::frontleft;
  bitePointToUse[Player::two]   = BitePoint::frontright;
  bitePointToUse[Player::three] = BitePoint::behindleft;
  bitePointToUse[Player::four]  = BitePoint::behindright;
  // masterdog doesnt use this... just for integrity
  bitePointToUse[Player::five]  = BitePoint::master;
  masterDog = Player::five;
  bitePointReady[BitePoint::master] = true;
  /* to test */
  /*
  masterDog = Player::two;
  bitePointToUse[Player::two]   = BitePoint::master;
  bitePointReady[BitePoint::behindright] = true;
  bitePointReady[BitePoint::frontright] = true;
  bitePointReady[BitePoint::behindleft] = true;
  */
  /* to  test */

/**
 *  END
 *  Imported from WM-Repository
 */

  xspeed.reset(20);
  groundVal.reset(50);
  avgOffset.reset(20);
  avgBiteDistance.reset(5);


  learnAcc = 0;

  ambVal = 0;

  irRadarStatus = 0;
}

//----------------------------------------------------------------------------
void OpenChallengeSymbols::registerSymbols(Xabsl2Engine& engine)
{
  engine.registerDecimalInputSymbol("oc.red-line-angle-in-image", this,
	  (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::redLineInImageAngle);
  engine.registerDecimalInputSymbol("oc.red-line-angle", this,
	  (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::redLineAngle);
//  engine.registerDecimalInputSymbol("oc.red-line-start-distance", this,
//	  (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::redLineInImageAngle);
  engine.registerBooleanInputSymbol("oc.red-line-known", this,
	  (bool (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::redLineKnown);

// climbRamp Symbols
  engine.registerDecimalInputSymbol("ramp.time-since-last-seen",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getRampTimeSinceLastSeen);
  engine.registerDecimalInputSymbol("ramp.distance-to-endpoint",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getRampDistanceToEndPoint);
  engine.registerDecimalInputSymbol("ramp.angle-of-line",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getRampAngleOfRedLine);
  engine.registerDecimalInputSymbol("ramp.lowest-line-point.y",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getRampLowestLinePointY);
  engine.registerDecimalInputSymbol("ramp.lowest-line-point.x",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getRampLowestLinePointX);
  engine.registerDecimalInputSymbol("ramp.highest-line-point.y",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getRampHighestLinePointY);
  engine.registerDecimalInputSymbol("ramp.highest-line-point.x",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getRampHighestLinePointX);
engine.registerDecimalInputSymbol("ramp.lowest-line-point.distance",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getRampDistanceToStartPoint);

//biteMark Symbols
  engine.registerDecimalInputSymbol("bite.distance-front-right",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteDistanceFrontRight);
  engine.registerDecimalInputSymbol("bite.avg-distance-f-r",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getAverageBiteDistanceFR);
  engine.registerDecimalInputSymbol("bite.angle-front-right",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteAngleFrontRight);
  engine.registerDecimalInputSymbol("bite.time-front-right",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteTimeSinceLastSeenFrontRight);
	engine.registerDecimalInputSymbol("bite.rel-x-front-right",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteRelativeXFrontRight);
	engine.registerDecimalInputSymbol("bite.rel-y-front-right",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteRelativeYFrontRight);
	engine.registerDecimalInputSymbol("bite.offset-front-right",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteOffsetFrontRight);
	

  engine.registerDecimalInputSymbol("bite.distance-front-left",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteDistanceFrontLeft);
  engine.registerDecimalInputSymbol("bite.avg-distance-f-l",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getAverageBiteDistanceFL);
  engine.registerDecimalInputSymbol("bite.angle-front-left",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteAngleFrontLeft);
  engine.registerDecimalInputSymbol("bite.time-front-left",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteTimeSinceLastSeenFrontLeft);
	engine.registerDecimalInputSymbol("bite.rel-x-front-left",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteRelativeXFrontLeft);
	engine.registerDecimalInputSymbol("bite.rel-y-front-left",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteRelativeYFrontLeft);
	engine.registerDecimalInputSymbol("bite.offset-front-left",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteOffsetFrontLeft);
	

	engine.registerDecimalInputSymbol("bite.distance-behind-left",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteDistanceBehindLeft);
  engine.registerDecimalInputSymbol("bite.avg-distance-b-l",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getAverageBiteDistanceBL);
  engine.registerDecimalInputSymbol("bite.angle-behind-left",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteAngleBehindLeft);
  engine.registerDecimalInputSymbol("bite.time-behind-left",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteTimeSinceLastSeenBehindLeft);
	engine.registerDecimalInputSymbol("bite.rel-x-behind-left",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteRelativeXBehindLeft);
	engine.registerDecimalInputSymbol("bite.rel-y-behind-left",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteRelativeYBehindLeft);
	engine.registerDecimalInputSymbol("bite.offset-behind-left",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteOffsetBehindLeft);
	
 
 
	engine.registerDecimalInputSymbol("bite.distance-behind-right",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteDistanceBehindRight);
  engine.registerDecimalInputSymbol("bite.avg-distance-b-r",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getAverageBiteDistanceBR);
  engine.registerDecimalInputSymbol("bite.angle-behind-right",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteAngleBehindRight);
  engine.registerDecimalInputSymbol("bite.time-behind-right",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteTimeSinceLastSeenBehindRight);
	engine.registerDecimalInputSymbol("bite.rel-x-behind-right",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteRelativeXBehindRight);
	engine.registerDecimalInputSymbol("bite.rel-y-behind-right",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteRelativeYBehindRight);
	engine.registerDecimalInputSymbol("bite.offset-behind-right",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBiteOffsetBehindRight);
	

  engine.registerEnumeratedOutputSymbol("openchallenge-image",this, (void (Xabsl2FunctionProvider::*)(int))&OpenChallengeSymbols::setRIP);
  engine.registerEnumeratedOutputSymbolEnumElement("openchallenge-image","openchallenge-image.normal", unchanged);
  engine.registerEnumeratedOutputSymbolEnumElement("openchallenge-image","openchallenge-image.rip",rip);

#ifdef OPENCHALLENGE_DEFINES
  engine.registerEnumeratedOutputSymbol("open-challenge.set-status-dtt",this, (void (Xabsl2FunctionProvider::*)(int))&OpenChallengeSymbols::setOCStatusDtt);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status-dtt","open-challenge.set-dtt-initial", dtt_initial);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status-dtt","open-challenge.set-dtt-start",dtt_start);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status-dtt","open-challenge.set-dtt-finishedIntro",dtt_finishedIntro);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status-dtt","open-challenge.set-dtt-finishedGoToBridge",dtt_finishedGoToBridge);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status-dtt","open-challenge.set-dtt-finishedClimbBridge",dtt_finishedClimbBridge);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status-dtt","open-challenge.set-dtt-finishedWalkWithBridge",dtt_finishedWalkWithBridge);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status-dtt","open-challenge.set-dtt-finishedGoToBitePoint",dtt_finishedGoToBitePoint);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status-dtt","open-challenge.set-dtt-finishedBite",dtt_finishedBite);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status-dtt","open-challenge.set-dtt-LoseBitePoints",dtt_loseBitePoints);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status-dtt","open-challenge.set-dtt-finishedExtro",dtt_finishedExtro);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status-dtt","open-challenge.set-dtt-finished",dtt_finished);
#endif
  engine.registerDecimalInputSymbol("open-challenge.headpsd.near",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getSensorPSDNear);
  engine.registerDecimalInputSymbol("open-challenge.headpsd.far",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getSensorPSDFar);
  engine.registerDecimalInputSymbol("open-challenge.accelerator.x",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getSensorAccelerationX);
  engine.registerDecimalInputSymbol("open-challenge.accelerator.y",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getSensorAccelerationY);
  engine.registerDecimalInputSymbol("open-challenge.accelerator.z",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getSensorAccelerationZ);
  
  engine.registerDecimalInputSymbol("open-challenge.on-ramp",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getAiboOnRamp);

/**
 *  Imported from WM-Repository
 *  BEGIN
 */

  engine.registerDecimalInputSymbol("open-challange.walk-request.type",&(m_walkRequest.type));
  engine.registerDecimalInputSymbol("open-challange.walk-request.x",&(m_walkRequest.x));
  engine.registerDecimalInputSymbol("open-challange.walk-request.y",&(m_walkRequest.y));
  engine.registerDecimalInputSymbol("open-challange.walk-request.rotation",&(m_walkRequest.rotation));

  engine.registerDecimalInputSymbol("open-challange.headrot",&(m_headrot));

  // bridge.last-seen-side 
  engine.registerEnumeratedInputSymbol("bridge.last-seen-side", this,
    (int (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getLastSeenSide);
  engine.registerEnumeratedInputSymbolEnumElement("bridge.last-seen-side", "bridge.seen-none",  OCBridge::none);
  engine.registerEnumeratedInputSymbolEnumElement("bridge.last-seen-side", "bridge.seen-left",  OCBridge::left);
  engine.registerEnumeratedInputSymbolEnumElement("bridge.last-seen-side", "bridge.seen-right", OCBridge::right);

  // bridge.seen.distance
  engine.registerDecimalInputSymbol("bridge.seen.distance",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getSeenDistanceToBridge);

  // bridge.seen.angle
  engine.registerDecimalInputSymbol("bridge.seen.angle",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getSeenAngleToBridge);

  // bridge.time-since-last-seen
  engine.registerDecimalInputSymbol("bridge.time-since-last-seen",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getTimeSinceLastSeenBridge);

  // bite-point.position 
  engine.registerEnumeratedInputSymbol("bite-point.position", this,
    (int (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getBitePointPosition);
  engine.registerEnumeratedInputSymbolEnumElement("bite-point.position", "bite-point.frontleft",   BitePoint::frontleft);
  engine.registerEnumeratedInputSymbolEnumElement("bite-point.position", "bite-point.frontright",  BitePoint::frontright);
  engine.registerEnumeratedInputSymbolEnumElement("bite-point.position", "bite-point.behindleft",  BitePoint::behindleft);
  engine.registerEnumeratedInputSymbolEnumElement("bite-point.position", "bite-point.behindright", BitePoint::behindright);
  engine.registerEnumeratedInputSymbolEnumElement("bite-point.position", "bite-point.master", BitePoint::master);

  // bite-point.seen.distance
  engine.registerDecimalInputSymbol("bite-point.seen.distance",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getSeenDistanceToBitePoint);

  // bite-point.seen.avg-distance
  engine.registerDecimalInputSymbol("bite-point.seen.avg-distance",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getSeenAverageDistanceToBitePoint);

  // bite-point.seen.angle
  engine.registerDecimalInputSymbol("bite-point.seen.angle",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getSeenAngleToBitePoint);

  // bite-point.precise-shift
  engine.registerDecimalInputSymbol("bite-point.precise-shift",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getPreciseShiftToBitePoint);

  // bite-point.average-shift
  engine.registerDecimalInputSymbol("bite-point.avg-shift",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getAvgShiftToBitePoint);

  // bite-point.time-since-last-seen
  engine.registerDecimalInputSymbol("bite-point.time-since-last-seen",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getTimeSinceLastSeenBitePoint);

  // open-challenge.status 
  engine.registerEnumeratedInputSymbol("open-challenge.status",(int*)&ocStatus);
  engine.registerEnumeratedInputSymbolEnumElement("open-challenge.status", "open-challenge.initial",            initial);
  engine.registerEnumeratedInputSymbolEnumElement("open-challenge.status", "open-challenge.intro",              intro);
  engine.registerEnumeratedInputSymbolEnumElement("open-challenge.status", "open-challenge.goToBridge",         goToBridge);
  engine.registerEnumeratedInputSymbolEnumElement("open-challenge.status", "open-challenge.goToBitePoint",      goToBitePoint);
  engine.registerEnumeratedInputSymbolEnumElement("open-challenge.status", "open-challenge.allBitePointsReady", allBitePointsReady);
  engine.registerEnumeratedInputSymbolEnumElement("open-challenge.status", "open-challenge.walkWithBridge",     walkWithBridge);
  engine.registerEnumeratedInputSymbolEnumElement("open-challenge.status", "open-challenge.extro",              extro);
  engine.registerEnumeratedInputSymbolEnumElement("open-challenge.status", "open-challenge.finished",           finished);

  // "open-challenge.set-status"
  engine.registerEnumeratedOutputSymbol("open-challenge.set-status",this,
    (void (Xabsl2FunctionProvider::*)(int))&OpenChallengeSymbols::setOCStatus);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status","open-challenge.set-initial",            setInitial);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status","open-challenge.set-intro",              setIntro);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status","open-challenge.set-goToBridge",         setGoToBridge);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status","open-challenge.set-goToBitePoint",      setGoToBitePoint);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status","open-challenge.set-myBitePointIsReady", setMyBitePointIsReady);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status","open-challenge.set-lostMyBitePoint",    setLostMyBitePoint);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status","open-challenge.set-walkWithBridge",     setWalkWithBridge);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status","open-challenge.set-extro",              setExtro);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-status","open-challenge.set-finished",           setFinished);

  // "open-challenge.learning"
  engine.registerEnumeratedOutputSymbol("open-challenge.learning", (int*)&learnAcc);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.learning","open-challenge.learn-on",   1);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.learning","open-challenge.learn-none", 0);
/**
 *  END
 *  Imported from WM-Repository
 */

  // "open-challenge.set-already-moved-bridge"
  engine.registerEnumeratedOutputSymbol("open-challenge.set-already-moved-bridge", (int*)&ambVal);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-already-moved-bridge","open-challenge.set-amb-yes",   1);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.set-already-moved-bridge","open-challenge.set-amb-no" ,   0);

  // "open-challenge.already-moved-bridge"
  engine.registerEnumeratedInputSymbol("open-challenge.already-moved-bridge",(int*)&ambVal);
  engine.registerEnumeratedInputSymbolEnumElement("open-challenge.already-moved-bridge", "open-challenge.amb-yes", 1);
  engine.registerEnumeratedInputSymbolEnumElement("open-challenge.already-moved-bridge", "open-challenge.amb-no",  0);

  // "open-challenge.ir-radar"
  engine.registerEnumeratedOutputSymbol("open-challenge.ir-radar",this,
    (void (Xabsl2FunctionProvider::*)(int))&OpenChallengeSymbols::setIRRadar);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.ir-radar","open-challenge.radar-on",   1);
  engine.registerEnumeratedOutputSymbolEnumElement("open-challenge.ir-radar","open-challenge.radar-none", 0);

  // "open-challenge.ir-radar-max-angle"
	engine.registerDecimalInputSymbol("open-challenge.ir-radar-max-angle",this,
    (double (Xabsl2FunctionProvider::*)())&OpenChallengeSymbols::getIRRadarMaxAngle);
}
//----------------------------------------------------------------------------
double OpenChallengeSymbols::redLineInImageAngle()
{ 
  return specialPercept.ocRedLine.angleInImage-90;
}
//----------------------------------------------------------------------------
double OpenChallengeSymbols::redLineAngle()
{ 
  return toDegrees(specialPercept.ocRedLine.lineStart.angle());
}
//----------------------------------------------------------------------------
bool OpenChallengeSymbols::redLineKnown()
{ 
  return true;
}

// sensor climbRamp 
//----------------------------------------------------------------------------
double OpenChallengeSymbols::getSensorPSDNear()
{
  double tmpdata = 0;
  for (int i = 0; i < sensorDataBuffer.numOfFrames; ++i)
    tmpdata += sensorDataBuffer.frame[i].data[SensorData::headPsdNear];
  if (sensorDataBuffer.numOfFrames !=0) 
    tmpdata /= sensorDataBuffer.numOfFrames;
  else
    tmpdata=0;
  return tmpdata;
//  return toDegrees(fromMicroRad(sensorDataBuffer.lastFrame().data[SensorData::accelerationX]));
}
//----------------------------------------------------------------------------
double OpenChallengeSymbols::getSensorPSDFar()
{
  double tmpdata = 0;
  for (int i = 0; i < sensorDataBuffer.numOfFrames; ++i)
    tmpdata += sensorDataBuffer.frame[i].data[SensorData::headPsdFar];
  if (sensorDataBuffer.numOfFrames !=0) 
    tmpdata /= sensorDataBuffer.numOfFrames;
  else
    tmpdata=0;
  return tmpdata;
//  return toDegrees(fromMicroRad(sensorDataBuffer.lastFrame().data[SensorData::accelerationX]));
}
//----------------------------------------------------------------------------
double OpenChallengeSymbols::getSensorAccelerationX()
{
  double tmpdata = 0;
  for (int i = 0; i < sensorDataBuffer.numOfFrames; ++i)
    tmpdata += toDegrees(fromMicroRad(sensorDataBuffer.frame[i].data[SensorData::accelerationX]));
  if (sensorDataBuffer.numOfFrames !=0) 
    tmpdata /= sensorDataBuffer.numOfFrames;
  else
    tmpdata=0;
  return tmpdata;
//  return toDegrees(fromMicroRad(sensorDataBuffer.lastFrame().data[SensorData::accelerationX]));
}

//----------------------------------------------------------------------------
double OpenChallengeSymbols::getSensorAccelerationY()
{
  double tmpdata = 0;
  for (int i = 0; i < sensorDataBuffer.numOfFrames; ++i)
    tmpdata += toDegrees(fromMicroRad(sensorDataBuffer.frame[i].data[SensorData::accelerationY]));
 if (sensorDataBuffer.numOfFrames !=0) 
   tmpdata /= sensorDataBuffer.numOfFrames;
 else
   tmpdata=0;
  return tmpdata;
//  return toDegrees(fromMicroRad(sensorDataBuffer.lastFrame().data[SensorData::accelerationY]));
}

//----------------------------------------------------------------------------
double OpenChallengeSymbols::getSensorAccelerationZ()
{
  double tmpdata = 0;
  for (int i = 0; i < sensorDataBuffer.numOfFrames; ++i)
    tmpdata += toDegrees(fromMicroRad(sensorDataBuffer.frame[i].data[SensorData::accelerationZ]));
  if (sensorDataBuffer.numOfFrames !=0) 
    tmpdata /= sensorDataBuffer.numOfFrames;
  else
    tmpdata=0;
  return tmpdata;
  return toDegrees(fromMicroRad(sensorDataBuffer.lastFrame().data[SensorData::accelerationZ]));
}

// climbRamp methods
//----------------------------------------------------------------------------
double OpenChallengeSymbols::getAiboOnRamp()
{
  xspeed.add(int(getSensorAccelerationX()));
  xspeed.trigger();
//  if (xspeed.getAverage()>(groundVal.getAverage()))
  if (xspeed.getAverage() > 40 )
    return 1;
	return 0;
}

//----------------------------------------------------------------------------
double OpenChallengeSymbols::getRampTimeSinceLastSeen()
{
	return SystemCall::getTimeSince(specialPercept.ocRedLine.timeWhenLastSeen);
}
//----------------------------------------------------------------------------
double OpenChallengeSymbols::getRampDistanceToEndPoint()
{
  return 800;
}
//----------------------------------------------------------------------------
double OpenChallengeSymbols::getRampDistanceToStartPoint()
{
  return specialPercept.ocRedLine.lineStart.abs();
}
//----------------------------------------------------------------------------
double OpenChallengeSymbols::getRampAngleOfRedLine()
{
	return specialPercept.ocRedLine.angleInImage;
}
//----------------------------------------------------------------------------
double OpenChallengeSymbols::getRampLowestLinePointY()
{
	return specialPercept.ocRedLine.lineStart.y;
}
//----------------------------------------------------------------------------
double OpenChallengeSymbols::getRampLowestLinePointX()
{
	return specialPercept.ocRedLine.lineStart.x;
}
//----------------------------------------------------------------------------
double OpenChallengeSymbols::getRampHighestLinePointX()
{
	return specialPercept.ocRedLine.lineEnd.x;
}
//----------------------------------------------------------------------------
double OpenChallengeSymbols::getRampHighestLinePointY()
{
	return specialPercept.ocRedLine.lineEnd.y;
}
//----------------------------------------------------------------------------

// frontLeft
double OpenChallengeSymbols::getBiteAngleFrontLeft()
{
	return toDegrees(specialPercept.ocBridge.bitePoint[BitePoint::frontleft].angleTo);
}
double OpenChallengeSymbols::getBiteDistanceFrontLeft()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::frontleft].distanceTo;
}
double OpenChallengeSymbols::getAverageBiteDistanceFL()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::frontleft].avgDistanceTo;
}
double OpenChallengeSymbols::getBiteOffsetFrontLeft()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::frontleft].preciseShift;
}
double OpenChallengeSymbols::getBiteRelativeXFrontLeft()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::frontleft].relPos.x;
}
double OpenChallengeSymbols::getBiteRelativeYFrontLeft()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::frontleft].relPos.y;
}
double OpenChallengeSymbols::getBiteTimeSinceLastSeenFrontLeft()
{
	return SystemCall::getCurrentSystemTime() - 
		specialPercept.ocBridge.bitePoint[BitePoint::frontleft].timeWhenLastSeen;
}

//frontRight
double OpenChallengeSymbols::getBiteAngleFrontRight()
{
	return toDegrees(specialPercept.ocBridge.bitePoint[BitePoint::frontright].angleTo);
}
double OpenChallengeSymbols::getBiteDistanceFrontRight()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::frontright].distanceTo;
}
double OpenChallengeSymbols::getAverageBiteDistanceFR()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::frontright].avgDistanceTo;
}
double OpenChallengeSymbols::getBiteOffsetFrontRight()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::frontright].preciseShift;
}
double OpenChallengeSymbols::getBiteRelativeXFrontRight()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::frontright].relPos.x;
}
double OpenChallengeSymbols::getBiteRelativeYFrontRight()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::frontright].relPos.y;
}
double OpenChallengeSymbols::getBiteTimeSinceLastSeenFrontRight()
{
	return SystemCall::getCurrentSystemTime() - 
		specialPercept.ocBridge.bitePoint[BitePoint::frontright].timeWhenLastSeen;
}

//behindLeft
double OpenChallengeSymbols::getBiteAngleBehindLeft()
{
	return toDegrees(specialPercept.ocBridge.bitePoint[BitePoint::behindleft].angleTo);
}
double OpenChallengeSymbols::getBiteDistanceBehindLeft()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::behindleft].distanceTo;
}
double OpenChallengeSymbols::getAverageBiteDistanceBL()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::behindleft].avgDistanceTo;
}
double OpenChallengeSymbols::getBiteOffsetBehindLeft()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::behindleft].preciseShift;
}
double OpenChallengeSymbols::getBiteRelativeXBehindLeft()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::behindleft].relPos.x;
}
double OpenChallengeSymbols::getBiteRelativeYBehindLeft()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::behindleft].relPos.y;
}
double OpenChallengeSymbols::getBiteTimeSinceLastSeenBehindLeft()
{
	return SystemCall::getCurrentSystemTime() - 
		specialPercept.ocBridge.bitePoint[BitePoint::behindleft].timeWhenLastSeen;
}

//behindRight
double OpenChallengeSymbols::getBiteAngleBehindRight()
{
	return toDegrees(specialPercept.ocBridge.bitePoint[BitePoint::behindright].angleTo);
}
double OpenChallengeSymbols::getBiteDistanceBehindRight()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::behindright].distanceTo;
}
double OpenChallengeSymbols::getAverageBiteDistanceBR()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::behindright].avgDistanceTo;
}
double OpenChallengeSymbols::getBiteOffsetBehindRight()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::behindright].preciseShift;
}
double OpenChallengeSymbols::getBiteRelativeXBehindRight()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::behindright].relPos.x;
}
double OpenChallengeSymbols::getBiteRelativeYBehindRight()
{
	return specialPercept.ocBridge.bitePoint[BitePoint::behindright].relPos.y;
}
double OpenChallengeSymbols::getBiteTimeSinceLastSeenBehindRight()
{
	return SystemCall::getCurrentSystemTime() - 
		specialPercept.ocBridge.bitePoint[BitePoint::behindright].timeWhenLastSeen;
}

void OpenChallengeSymbols::setRIP(int t)
{
    switch(t)
    {
        case rip:

            g_changetorip = true;
            break;
        default:
            g_changetorip = false;

    }
}


/**
 *  Imported from WM-Repository
 *  BEGIN
 */

void OpenChallengeSymbols::update()
{

	// update the avr-bitepoint offset every frame
	getAvgShiftToBitePoint() ;
	 

  //verdrehung des aibos
   m_headrot = toDegrees(fromMicroRad(sensorDataBuffer.lastFrame().data[SensorData::headPan]));
//  m_headrot = ((sensorDataBuffer.lastFrame().data[SensorData::mouth]));

  double phi(0);
  double x,y,r;
//  double l(35),b(25);
  double l(300),b(350);
  // Vorzeichen l,b  hngt vom Hund ab
  
  int playnum = getPlayer().getPlayerNumber();
  /*\/ to-test  */
  /*
  if (dttSymbols.actualOption == RateableOptions::gotoBitePos1)
  {
    bitePointToUse[playnum] = BitePoint::frontleft
  }

*/
  /*/\ to test */

  bool left = (bitePointToUse[playnum] == BitePoint::frontleft)
            | (bitePointToUse[playnum] == BitePoint::behindleft);
  bool front = (bitePointToUse[playnum] == BitePoint::frontleft)
            | (bitePointToUse[playnum] == BitePoint::frontright);
  

  Vector2<double> pos, nexpos;

  if (!left)
    b *= -1;  
  if (!front)
	  l *= -1;

  int ii = 0;
  for (int j = 0; j< Player::numOfPlayerNumbers; j++)
  {
    if ( teamMessageCollection[j].playerNumberOfSender == masterDog)
      ii = j;
  }

  m_walkRequest.type 
    = teamMessageCollection[ii].behaviorTeamMessage.walkRequest.type;
  x = teamMessageCollection[ii].behaviorTeamMessage.walkRequest.x;
  y = teamMessageCollection[ii].behaviorTeamMessage.walkRequest.y;
  r = -(teamMessageCollection[ii].behaviorTeamMessage.walkRequest.rotation);

  r = fromDegrees(r);

  Vector2<double> s(0,0),srtmp(1,0), sr(1,0);
  sr.normalize();

  phi = sr.angle();
  pos = s+(sr*l+sr.rotateLeft()*b);
  sr.rotateRight();
//  sr.x = 1;sr.y = 0;

  s.x = x;
  s.y = y;
  srtmp.x = sr.x * cos(r)+sr.y*sin(r);
  srtmp.y = sr.y * cos(r)-sr.x*sin(r);
  sr = srtmp;
  nexpos = s+(sr*l+sr.rotateLeft()*b);
  sr.rotateRight();

  pos = nexpos-pos;
  
  if (left)
    pos.rotateLeft();
  else
    pos.rotateRight();
    
  r = sr.angle()-phi;

	r = toDegrees(r);

  m_walkRequest.x = pos.x;
  m_walkRequest.y = pos.y;
  m_walkRequest.rotation = r;


  // send ocStatus
  {
  for (int i = 0; i < Player::numOfPlayerNumbers-1; ++i)
    if ((teamMessageCollection[i].isActual()) &&
        (teamMessageCollection[i].playerNumberOfSender != Player::undefinedPlayerNumber))
    {
      if (teamMessageCollection[i].playerNumberOfSender == masterDog)
        switch (teamMessageCollection[i].behaviorTeamMessage.ocStatus)
        {
          case setInitial        : ocStatus = initial;        break;
          case setIntro          : ocStatus = intro;          break;
          case setGoToBridge     : ocStatus = goToBridge;     break;
          case setGoToBitePoint  : ocStatus = goToBitePoint;  break;
          case setWalkWithBridge : ocStatus = walkWithBridge; break;
          case setExtro          : ocStatus = extro;          break;
          case setFinished       : ocStatus = finished;       break;
        }

      if (teamMessageCollection[i].behaviorTeamMessage.ocStatus == setMyBitePointIsReady)
        bitePointReady[bitePointToUse[teamMessageCollection[i].playerNumberOfSender]] = true;
      if (teamMessageCollection[i].behaviorTeamMessage.ocStatus == setLostMyBitePoint)
        bitePointReady[bitePointToUse[teamMessageCollection[i].playerNumberOfSender]] = false;
    }
  }

  int allReady = 1;
  int k;
  for (k = 0; k < BitePoint::numOfPositions; ++k)
    allReady *= bitePointReady[k];
  if ((allReady) && 
      (ocStatus == goToBitePoint))
    ocStatus = allBitePointsReady;
  if ((!allReady) &&
      ((ocStatus == allBitePointsReady) || (ocStatus == walkWithBridge)))
    ocStatus = goToBitePoint;

  /** normally the following stuff should be placed inside an BridgeLocator module.. 
      so this is near to a hack ;-) */

  SpecialPercept& sp = const_cast<SpecialPercept&>(specialPercept);
  if (sp.ocBridge.fresh) {
    sp.ocBridge.fresh = false;
  } else {
    sp.ocBridge.relPos =
      (sp.ocBridge.lastOdometry + Pose2D(sp.ocBridge.relPos) - odometryData).translation;
    sp.ocBridge.distanceTo = sp.ocBridge.relPos.abs();
    sp.ocBridge.angleTo = 
      (sgn(sp.ocBridge.relPos.y) * asin(fabs(sp.ocBridge.relPos.y)/(fabs(sp.ocBridge.distanceTo)+1))) +
      (odometryData.rotation - sp.ocBridge.lastOdometry.rotation);
  }
  sp.ocBridge.lastOdometry = odometryData;
  for (k = 0; k < BitePoint::numOfPositions; ++k)
  {
    if (sp.ocBridge.bitePoint[k].fresh) {
	  sp.ocBridge.bitePoint[k].tmpDistanceTo += sp.ocBridge.bitePoint[k].distanceTo;
	  sp.ocBridge.bitePoint[k].tmpDistanceTo -= sp.ocBridge.bitePoint[k].distances[sp.ocBridge.bitePoint[k].frame];
	  sp.ocBridge.bitePoint[k].distances[sp.ocBridge.bitePoint[k].frame] = sp.ocBridge.bitePoint[k].distanceTo;
	  sp.ocBridge.bitePoint[k].frame++;
	  if(sp.ocBridge.bitePoint[k].frame ==5) {
		  sp.ocBridge.bitePoint[k].frame = 0;
		  sp.ocBridge.bitePoint[k].filled = true;

	  }
	  if(sp.ocBridge.bitePoint[k].filled)
		  sp.ocBridge.bitePoint[k].avgDistanceTo = sp.ocBridge.bitePoint[k].tmpDistanceTo / 5;
	  else  
		  sp.ocBridge.bitePoint[k].avgDistanceTo = sp.ocBridge.bitePoint[k].tmpDistanceTo / (sp.ocBridge.bitePoint[k].frame);
      sp.ocBridge.bitePoint[k].fresh = false;

    } else {
      sp.ocBridge.bitePoint[k].relPos =
        (sp.ocBridge.bitePoint[k].lastOdometry + Pose2D(sp.ocBridge.bitePoint[k].relPos) - odometryData).translation;  
      sp.ocBridge.bitePoint[k].distanceTo = sp.ocBridge.bitePoint[k].relPos.abs();
      sp.ocBridge.bitePoint[k].angleTo =
        (sgn(sp.ocBridge.bitePoint[k].relPos.y) * asin(fabs(sp.ocBridge.bitePoint[k].relPos.y)/(fabs(sp.ocBridge.bitePoint[k].distanceTo)+1))) +
        (odometryData.rotation - sp.ocBridge.bitePoint[k].lastOdometry.rotation);
	  sp.ocBridge.bitePoint[k].initDistances();
	  sp.ocBridge.bitePoint[k].distances[sp.ocBridge.bitePoint[k].frame++] = sp.ocBridge.bitePoint[k].distanceTo;
	  sp.ocBridge.bitePoint[k].tmpDistanceTo += sp.ocBridge.bitePoint[k].distanceTo;

                                         
    }
    sp.ocBridge.bitePoint[k].lastOdometry = odometryData;
  }

  //lernen fr die gyros...
  if (learnAcc == 1)
  {
    groundVal.add(xspeed.getAverage());
    groundVal.trigger();
  }

/*
 if(ocStatus == initial)
 {
    //just for fun
    int ii = 0;
    for (int j = 0; j< Player::numOfPlayerNumbers; j++)
    {
      if ( teamMessageCollection[j].playerNumberOfSender == masterDog)
        ii = j;
    }
    m_walkRequest.type 
      = teamMessageCollection[ii].behaviorTeamMessage.walkRequest.type;
    m_walkRequest.x = teamMessageCollection[ii].behaviorTeamMessage.walkRequest.x;
    m_walkRequest.y = teamMessageCollection[ii].behaviorTeamMessage.walkRequest.y;
    m_walkRequest.rotation = teamMessageCollection[ii].behaviorTeamMessage.walkRequest.rotation;
 }
*/

  if (irRadarStatus == 1)
  {
    double tmp = getSensorPSDNear();
    if (tmp > irMaxDist)
    {
      irMaxDist  = tmp;
      irMaxAngle = toDegrees(fromMicroRad(sensorDataBuffer.lastFrame().data[SensorData::headPan]));
    }
  }

}

OCBridge::Side OpenChallengeSymbols::getLastSeenSide()    
{
  return specialPercept.ocBridge.lastSeenSide;
}

double OpenChallengeSymbols::getSeenDistanceToBridge()
{
  return specialPercept.ocBridge.distanceTo;
}    

double OpenChallengeSymbols::getSeenAngleToBridge()
{
  return toDegrees(specialPercept.ocBridge.angleTo);
}

double OpenChallengeSymbols::getTimeSinceLastSeenBridge() 
{
  return SystemCall::getTimeSince(specialPercept.ocBridge.timeWhenLastSeen);
}

BitePoint::Position OpenChallengeSymbols::getBitePointPosition() 
{
  return specialPercept.ocBridge.bitePoint[bitePointToUse[getPlayer().getPlayerNumber()]].position;
}

double OpenChallengeSymbols::getSeenDistanceToBitePoint()        
{
  int tmpPos = bitePointToUse[getPlayer().getPlayerNumber()];
  if ((BitePoint::Position)(tmpPos) == BitePoint::frontright)
    tmpPos = (int)(BitePoint::behindleft);
  if ((BitePoint::Position)(tmpPos) == BitePoint::behindright)
    tmpPos = (int)(BitePoint::frontleft);
  return specialPercept.ocBridge.bitePoint[bitePointToUse[tmpPos]].distanceTo;
}

double OpenChallengeSymbols::getSeenAverageDistanceToBitePoint()        
{
  avgBiteDistance.add(int(specialPercept.ocBridge.bitePoint[bitePointToUse[getPlayer().getPlayerNumber()]].distanceTo));
  avgBiteDistance.trigger();
  return avgBiteDistance.getAverage();
}


double OpenChallengeSymbols::getSeenAngleToBitePoint()
{
  int tmpPos = bitePointToUse[getPlayer().getPlayerNumber()];
  if ((BitePoint::Position)(tmpPos) == BitePoint::frontright)
    tmpPos = (int)(BitePoint::behindleft);
  if ((BitePoint::Position)(tmpPos) == BitePoint::behindright)
    tmpPos = (int)(BitePoint::frontleft);
  return toDegrees(specialPercept.ocBridge.bitePoint[tmpPos].angleTo);
}

double OpenChallengeSymbols::getPreciseShiftToBitePoint()        
{
  int tmpPos = bitePointToUse[getPlayer().getPlayerNumber()];
  if ((BitePoint::Position)(tmpPos) == BitePoint::frontright)
    tmpPos = (int)(BitePoint::behindleft);
  if ((BitePoint::Position)(tmpPos) == BitePoint::behindright)
    tmpPos = (int)(BitePoint::frontleft);
  return specialPercept.ocBridge.bitePoint[tmpPos].preciseShift;
}

double OpenChallengeSymbols::getAvgShiftToBitePoint()        
{
  double tmp = specialPercept.ocBridge.bitePoint[bitePointToUse[getPlayer().getPlayerNumber()]].preciseShift;
  tmp *= 1000;
  avgOffset.add((int)tmp);
  avgOffset.trigger();
  return (double)avgOffset.getAverage()/1000;
}

double OpenChallengeSymbols::getTimeSinceLastSeenBitePoint()     
{
  int tmpPos = bitePointToUse[getPlayer().getPlayerNumber()];
  if ((BitePoint::Position)(tmpPos) == BitePoint::frontright)
    tmpPos = (int)(BitePoint::behindleft);
  if ((BitePoint::Position)(tmpPos) == BitePoint::behindright)
    tmpPos = (int)(BitePoint::frontleft);
  return SystemCall::getTimeSince(specialPercept.ocBridge.bitePoint[tmpPos].timeWhenLastSeen);
}

void OpenChallengeSymbols::setOCStatus(int aStatus)
{
  outgoingBehaviorTeamMessage.ocStatus = aStatus;
  if (getPlayer().getPlayerNumber() == masterDog)
    switch (aStatus)
    {
      case setInitial        : ocStatus = initial;        break;
      case setIntro          : ocStatus = intro;          break;
      case setGoToBridge     : ocStatus = goToBridge;     break;
      case setGoToBitePoint  : ocStatus = goToBitePoint;  break;
      case setWalkWithBridge : ocStatus = walkWithBridge; break;
      case setExtro          : ocStatus = extro;          break;
      case setFinished       : ocStatus = finished;       break;
    }
  else
    switch (aStatus)
    {
      case setMyBitePointIsReady : bitePointReady[bitePointToUse[getPlayer().getPlayerNumber()]] = true;  break;
      case setLostMyBitePoint    : bitePointReady[bitePointToUse[getPlayer().getPlayerNumber()]] = false; break;
    }
}

void OpenChallengeSymbols::setOCStatusDtt(int aStatus)
{
#ifdef OPENCHALLENGE_DEFINES
  ocstate = (OCSetStatus2)aStatus;
#endif
}

/**
 *  END
 *  Imported from WM-Repository
 */

void OpenChallengeSymbols::setIRRadar(int aStatus)
{
  irRadarStatus = aStatus;
  if (irRadarStatus == 1)
  {
    irMaxDist  = 0;
    irMaxAngle = 0;
  }
}

double OpenChallengeSymbols::getIRRadarMaxAngle()
{
	return irMaxAngle;
}

/*
 * Change log :
 * 
 * $Log: OpenChallengeSymbols.cpp,v $
 * Revision 1.36  2004/06/21 16:55:26  kerdels
 * some new symbols
 *
 * Revision 1.35  2004/06/21 16:46:34  kerdels
 * some new symbols
 *
 * Revision 1.34  2004/06/21 15:33:50  kerdels
 * some new symbols
 *
 * Revision 1.32  2004/06/18 17:29:46  hamerla
 * oc bite
 *
 * Revision 1.31  2004/06/17 15:11:02  serwe
 * update avrg offset/shift every frame (not only in demand). implemented in update() function
 *
 * Revision 1.30  2004/06/17 14:18:21  kerdels
 * fixed bug in rfieldspecialist, changed threshold for bridge-detection
 *
 * Revision 1.29  2004/06/17 09:47:48  hamerla
 * OC rollenzuteilung
 *
 * Revision 1.28  2004/06/16 17:29:46  kerdels
 * c64 colortable for dark red line renamed to coltable.c64 and adjusted threshold for master-dog...
 *
 * Revision 1.27  2004/06/15 13:24:12  kerdels
 * some adjustments to oc-symbols
 *
 * Revision 1.26  2004/06/14 20:14:23  kerdels
 * added further symbols for sequence-control of the openchallenge
 *
 * Revision 1.25  2004/06/09 16:01:08  serwe
 * added avarage-bitepoint-offset symbol
 *
 * Revision 1.24  2004/06/09 15:26:21  koh
 * changed avr to avg
 *
 * Revision 1.23  2004/06/09 15:17:15  koh
 * little changes to average bite point distance calculation
 *
 * Revision 1.22  2004/06/07 16:00:57  hamerla
 * OptionRation fr OpenChallenge
 *
 * Revision 1.21  2004/06/07 07:44:51  koh
 * removed a logical nice mistake
 *
 * Revision 1.20  2004/06/07 07:36:01  koh
 * removed a logical nice mistake
 *
 * Revision 1.19  2004/06/06 22:32:49  koh
 * added functions to handle xabsl-symbols of average distance to Bite Points
 *
 * Revision 1.18  2004/06/04 11:35:22  kerdels
 * fixed find-climb-runover-ramp...
 *
 * Revision 1.17  2004/06/04 03:06:38  hamerla
 * OpenChallenge
 *
 * Revision 1.16  2004/06/03 22:45:45  kerdels
 * fixed stupid auto-learning threshold problem
 *
 * Revision 1.15  2004/06/03 22:30:39  kerdels
 * created auto-learning threshold
 *
 * Revision 1.14  2004/06/03 21:27:35  kerdels
 * modified headcontrol
 *
 * Revision 1.13  2004/06/03 18:09:52  lohmann
 * OC-Climb-Ramp, AlignRamp and Master2:
 *
 * integration nearly done
 *
 * some tuning for target-state in align-to-ramp needed
 *
 * Revision 1.12  2004/06/03 16:55:55  kerdels
 * averaged AccelartionSymbols in OpenChallenge
 *
 * Revision 1.11  2004/06/02 22:40:34  kerdels
 * merged OpenChallengeSymbols from WM-Repository...
 *
 * Revision 1.10  2004/06/01 15:08:24  hamerla
 * climb ramp (parameter work -0,1 0.6 1 1 180)
 *
 * Revision 1.9  2004/05/30 17:21:38  hamerla
 * oc some more symbols and testoptions
 *
 * Revision 1.8  2004/05/28 14:19:25  huelsbusch
 * Image-Prozessor switching (per xabsl) eingebaut
 *
 * Revision 1.7  2004/05/28 10:34:32  schumann
 * can find ramp now
 *
 * Revision 1.6  2004/05/28 08:37:29  koh
 * added ramp.highest-line-point.x and ramp.highest-line-point.y
 *
 * Revision 1.5  2004/05/27 19:44:47  schumann
 * bugfix in angleInImage
 *
 * Revision 1.4  2004/05/27 16:04:25  lohmann
 * some bugs fixed
 *
 * Revision 1.3  2004/05/27 13:47:52  schmidtb
 * further work on open-challenge
 *
 * Revision 1.2  2004/05/26 16:21:09  serwe
 * added symbols for rampclimbing
 *
 * Revision 1.1  2004/05/26 14:39:40  schumann
 * some symbols for the challenge
 *
*/
