/**
* @file MSH2004TestSymbols.cpp
*
* Implementation of class MSH2004TestSymbols.
*
* @author Michael Wachter
*/

#include "MSH2004TestSymbols.h"


MSH2004TestSymbols::MSH2004TestSymbols(const BehaviorControlInterfaces& interfaces)
: BehaviorControlInterfaces(interfaces)
{
}


void MSH2004TestSymbols::registerSymbols(Xabsl2Engine& engine)
{
  // "dtt-option-type"
  engine.registerEnumeratedInputSymbol("glassbox-moving-order",(int *)&movingOrder);
  // add here new Options
  engine.registerEnumeratedInputSymbolEnumElement("glassbox-moving-order","forward"  ,(int)forward);
  engine.registerEnumeratedInputSymbolEnumElement("glassbox-moving-order","backward" ,(int)backward);
  engine.registerEnumeratedInputSymbolEnumElement("glassbox-moving-order","left"     ,(int)left);
  engine.registerEnumeratedInputSymbolEnumElement("glassbox-moving-order","right"     ,(int)right);
  engine.registerEnumeratedInputSymbolEnumElement("glassbox-moving-order","rotateLeft" ,(int)rotateLeft);
  engine.registerEnumeratedInputSymbolEnumElement("glassbox-moving-order","rotateRight",(int)rotateRight);
  engine.registerEnumeratedInputSymbolEnumElement("glassbox-moving-order","none",(int)none);
}

void MSH2004TestSymbols::update()
{
	// Speed hack for glassbox-goalie  (ARGH !!!)
	double speedy = (ballPosition.seen.y - lastBallYPosition) / SystemCall::getTimeSince(lastBallYPositionTime) * 1000;
	lastBallYPosition = (int)(ballPosition.seen.y);
	lastBallYPositionTime = SystemCall::getCurrentSystemTime();
	// OUTPUT (idText,text,speedy << " " << lastBallYPosition << " " << ballPosition.seen.y << " " << SystemCall::getTimeSince(lastBallYPosition));
	movingOrder= forward;
	if (speedy < -100)
	{
		movingOrder=right;
	}
	if (speedy > 100)
	{
        movingOrder=left;
	}
 
}



/*
* Change Log
*
* $Log: MSH2004TestSymbols.cpp,v $
* Revision 1.7  2004/03/15 18:08:14  kerdels
* further worked on penalty shooter
*
* Revision 1.6  2004/03/14 18:21:21  wachter
* disabled debug-message
*
* Revision 1.5  2004/03/14 18:19:24  wachter
* rewrote glassbox-goalie
*
* Revision 1.4  2004/03/08 01:07:14  roefer
* Interfaces should be const
*
* Revision 1.3  2004/02/29 13:37:14  dueffert
* doxygen bugs fixed and beautified
*
* Revision 1.2  2004/02/25 05:43:20  wachter
* Doxygen bugs and changelog fixed
*
* Revision 1.1  2004/02/24 21:11:09  wachter
* Added some xabsl-symbols for testing.
*
*
*/

