/** 
* @file MSH2004StrategySymbols.h
*
* Declaration of class MSH2004StrategySymbols.
*
* @author Martin Ltzsch
*/

#ifndef __MSH2004StrategySymbols_h_
#define __MSH2004StrategySymbols_h_

#include "../../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"
/**
* The Xabsl2 symbols that are defined in "strategy-symbols.xml"
*
* @author Martin Ltzsch
*/ 
class MSH2004StrategySymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{


  // used for the penalty-shooter
  unsigned char sectormap[42][27];

  int successfulCarries;
  int failedCarries;

public:

  bool carryIsRunning;
  bool carryDisabled;
  
  bool isPenaltyShooter;
  bool earsStripped;

  // used for the penalty-shooter
  enum SectorNr
  {
    sector1 = 1,
    sector2,
    sector3,
    sector4,
    sector5,
    sector6,
    sector7,
    sector8,
    sector9,
    sector10,
    sector11,
    sector12,
    sector13,
    sector14,
    sector15,
    sector16,
    sector17,
    sector18,
    sector19
  };

  /*
  * Constructor.
  * @param interfaces The paramters of the BehaviorControl module.
  */
  MSH2004StrategySymbols(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);
  
  /** updates the symbols */
  void update();

  /** current estimated time to reach the ball */
  double estimatedTimeToReachBall;

  /** computes the estimated time to reach the ball */
  void estimateTimeToReachBall();

  /** current role */
  BehaviorTeamMessage::DynamicRole role;

  /** current teamcolor */
  Player::teamColor teamcolor;

  /** current sectorNr of ballPosition */
  SectorNr sectNr;

  /** computes the current role */
  void computeRole();

  //!@name Input symbols
  //!@{
  /* 
  * A function for the symbol "robot-number". 
  * Returns the robots back number as read from player.cfg 
  */
  double getRobotNumber() { return (double)(getPlayer().getPlayerNumber() + 1); };

  /** A function for the symbol "another-player-is-in-ready-state". */
  bool getAnotherPlayerIsInReadyState();

  /** A function for the symbol "another-teammate-is-preparing-a-kick" */
  bool getAnotherTeammateIsPreparingAKick();

  /** A function for the symbol "another-teammate-is-performing-a-kick" */
  bool getAnotherTeammateIsPerformingAKick();

  /** A function for the symbol "another-teammate-just-performed-a-kick" */
  bool getAnotherTeammateJustPerformedAKick();

  /** A function for the symbol "the-striker-is-playing-near-the-opponent-goal" */
  bool getTheStrikerIsPlayingNearTheOpponentGoal();

  /** A function for the symbol "the-striker-is-not-playing-near-the-opponent-goal" */
  bool getTheStrikerIsNotPlayingNearTheOpponentGoal();

  /** A function for the symbol "the-striker-is-playing-near-the-own-goal" */
  bool getTheStrikerIsPlayingNearTheOwnGoal();

  /** A function for the symbol "the-striker-is-not-playing-near-the-own-goal" */
  bool getTheStrikerIsNotPlayingNearTheOwnGoal();

  /** A funtion for the symbol "catch-ball" */
  bool getCaught(); 

  /** A function for the symbol "catch-ball-time" */
  double getCatchTime(); 

  /** A function for the symbol "search-ball.x" */
  double getSearchBallX();

  /** A function to report wether a carry-to-opponent-goal was successful */
  void setCarryResult(int number);

  /** A function to report the carry-to-opponent-goal status */
  void setCarryStatus(int number);

  /** A function to report the ear status */
  void setEarsStatus(int number);

  /** A function to report the ear status */
  void setPenaltyShooter(int number);

  //!@}

  /** The time when the ball was started to catch */
  unsigned long timeWhenBallWasStartedToCatch;

  /** The time until the ball was caught */
  unsigned long timeUntilBallWasCaught;

  /** Indicates if the robot is stuck (based on obstacles model)*/
  bool robotIsStuck;

  /** Indicates that there are close obstacles */
  bool obstaclesAreClose;

  double getChoosenKick();

  double getAngleToTeammate1(); /*!< calculates the value for the symbol "fieldpos.angle-to-teammate1" */
  double getDistanceToTeammate1(); /*!< calculates the value for the symbol "fieldpos.distance-to-teammate1" */
  double getAngleToTeammate2(); /*!< calculates the value for the symbol "fieldpos.angle-to-teammate2" */
  double getDistanceToTeammate2(); /*!< calculates the value for the symbol "fieldpos.distance-to-teammate2" */
  double getAngleToTeammate3(); /*!< calculates the value for the symbol "fieldpos.angle-to-teammate3" */
  double getDistanceToTeammate3(); /*!< calculates the value for the symbol "fieldpos.distance-to-teammate3" */

  double getBlockPositionBetweenBallAndGoalX();
  double getBlockPositionBetweenBallAndGoalY();

  double getAngleToOpponentGoal();
  double getAngleToOwnGoal();
  
};


#endif // __MSH2004StrategySymbols_h_

/*
* Change Log
* 
* $Log: MSH2004StrategySymbols.h,v $
* Revision 1.16  2004/04/08 15:33:04  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.21  2004/04/03 22:32:44  wachter
* Added symbol
*
* Revision 1.20  2004/04/02 23:01:50  schumann
* Turning with ball improved
*
* Revision 1.19  2004/04/01 22:47:28  schumann
* Border handling near own goal
*
* Revision 1.18  2004/03/30 01:48:35  pg_joke
* created some symbols to detect wether the ears are already stripped or not, so the ears-off action is only executed once.
* added a "logical-switch" to the carry-option in simple-kick.xml. At the moment the carry option is disabled.
*
* Revision 1.17  2004/03/28 22:15:37  pg_joke
* added carry-ball-to-opponent-goal option and included it into simple-kick.
* the option is executed when the player is not the goalie, the carry option was not penalized before, the carry option was not bad performing before and our score is lower than the score of the opponent team. fair enough, isn't it ?
* btw: at the moment the option uses some fake special-actions, because the real special-actions used for this aren't implemented yet
*
* Revision 1.16  2004/03/25 16:29:41  pg_miwa
* Added symbol to set team-color
*
* Revision 1.15  2004/03/15 18:08:14  kerdels
* further worked on penalty shooter
*
* Revision 1.14  2004/03/15 15:59:45  schumann
* splitted symbols for kick engine from other symbols
*
* Revision 1.13  2004/03/14 18:51:20  kerdels
* worked on penalty shooter
*
* Revision 1.12  2004/03/09 14:13:35  schumann
* changed training for kickengine
*
* Revision 1.11  2004/03/08 01:07:13  roefer
* Interfaces should be const
*
* Revision 1.10  2004/03/04 08:37:41  schumann
* added neighbourhood search
*
* Revision 1.9  2004/03/01 22:27:22  kerdels
* *** empty log message ***
*
* Revision 1.8  2004/03/01 21:58:40  kerdels
* further work on kickengine integration
*
* Revision 1.7  2004/03/01 20:53:11  kerdels
* worked on kickengine integration
*
* Revision 1.6  2004/03/01 17:14:05  kerdels
* added robot-pose.distance-to-opponent-goal,
* moved robot-pose.angle-to-teammate1-3 to MSH2004StrategySymbols as fieldpos.angle-to-teammate1-3,
* added fieldpos.distance-to-teammate1-3,
* added DTT-Options newKickToGoal, newKickToClear, newKickToTeammate1-3,
* added DTT-OptionClass newKickToTeammate,
* added kickToPosRating function in DefaultOptionRating
*
* Revision 1.5  2004/02/27 16:20:46  schumann
* improved kickengine training
*
* Revision 1.4  2004/02/25 11:53:20  schumann
* extended range of kick engine
*
* Revision 1.3  2004/02/23 12:52:58  schumann
* added MSH2004KickEngine
*
* Revision 1.2  2003/12/06 17:45:33  loetzsch
* replaced Player::playerRole (goalie, defender, striker1, striker2)
* by Player::playerNumber (one, two, three, four)
*
* Revision 1.1  2003/10/26 22:49:40  loetzsch
* created ATH2004BehaviorControl from GT2003BehaviorControl
*  - strongly simplified option graph
*  - moved some symbols from GT2003 to CommonXabsl2Symbols
*  - moved some basic behaviors from GT2003 to CommonXabsl2BasicBehaviors
*
* cloned ATH2004 three times (BB2004, DDD2004, MSH2004)
*
*/

