/** 
* @file MSH2004KickEngineSymbols.h
*
* Declaration of class MSH2004KickEngineSymbols.
*
* @author Carsten Schumann
*/

#ifndef __MSH2004KickEngineSymbols_h_
#define __MSH2004KickEngineSymbols_h_

#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"
#include "../../BehaviorControl.h"
#include "../MSH2004KickEngine/MSH2004KickEngine.h"

class MSH2004KickEngineSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
private:

  MotionRequest::SpecialActionID currentTraining;
  MSH2004KickEngine** kickEngine;
  double beforeX[5];
  double beforeY[5];
  double afterAngle[5];
  double afterDistance[5];
  int beforeAndAfterCounter;
  double kick;
  MSH2004KickEngineSearchResult choosenKick;
  void quicksort(double data[], const int& start, const int& end);

  double targetDistance;
  double targetAngle;
public:
  /*
  * Constructor.
  * @param interfaces The paramters of the BehaviorControl module.
  */
  MSH2004KickEngineSymbols(const BehaviorControlInterfaces& interfaces, MSH2004KickEngine** kickEngine);
  void registerSymbols(Xabsl2Engine& engine);

  bool kickEngineSave();
  int kickEngineGetPreferredKick();
  bool kickEngineFindKick(double ballAngle, double ballDistance, double kickAngle, double kickDistance);

  bool kickEngineSetBeforeState();
  bool kickEngineSetAfterStateAndCommit();
  bool kickEngineSetTry();
  void setCurrentTraining();
  double getTrainingKick();

  double targetAbsoluteX;
  double targetAbsoluteY;
  double setTarget();
  bool kickForTargetFromCurrentPositionKnown();
  bool kickForTargetFromNearbyPositionKnown();
  double getFoundSuccessRate();
  double getFoundKick();
  double getFoundSearchDistance();
  double getTargetDistance();
  double getTargetAngle();
  bool setKickExecuted();

//  double getSuccessRate();

  bool kickEngineFindTrainingPos();
  double kickEngineNumberOfRemainingTrainingPos();
  double kickEngineFindTrainingPosX();
  double kickEngineFindTrainingPosY();
  double kickEngineFindTrainingPosXWalking();
  double kickEngineFindTrainingPosYWalking();
  double kickEngineFindTrainingPosXRelative();
  double kickEngineFindTrainingPosYRelative();
  double kickEngineFindTrainingPosXSector();
  double kickEngineFindTrainingPosYSector();
  double getRobotRelativeBallPosX();
  double getRobotRelativeBallPosY();


//  double getChoosenKick();

};

#endif


/*
* Change Log
* 
* $Log: MSH2004KickEngineSymbols.h,v $
* Revision 1.2  2004/04/08 15:33:04  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.4  2004/03/26 11:24:50  pg_cars
* StickOMat
*
* Revision 1.3  2004/03/25 21:05:25  pg_cars
* change of datafile, before backup
*
* Revision 1.2  2004/03/22 17:53:08  pg_cars
* improved training for kick engine
*
* Revision 1.1  2004/03/15 15:59:45  schumann
* splitted symbols for kick engine from other symbols
*
*/

