/** 
* @file MSH2004EvoSymbols.cpp
*
* Implementation of class MSH2004EvoSymbols.
*
* @author Arthur Cesarz
*/

#include "MSH2004EvoSymbols.h"
#include "Tools/Location.h"
#include "Tools/Streams/InStreams.h"

MSH2004EvoSymbols::MSH2004EvoSymbols(const BehaviorControlInterfaces& interfaces)
: BehaviorControlInterfaces(interfaces)
{
  ReadConfigFile();
}


void MSH2004EvoSymbols::registerSymbols(Xabsl2Engine& engine)
{
  // "evo-point-0.x"
  engine.registerDecimalInputSymbol("evo-point-0.x", (double*)&evoPoint0.x);

  // "evo-point-0.y"
  engine.registerDecimalInputSymbol("evo-point-0.y", (double*)&evoPoint0.y);
  
  // "evo-point-1.x"
  engine.registerDecimalInputSymbol("evo-point-1.x", (double*)&evoPoint1.x);
  
  // "evo-point-1.y"
  engine.registerDecimalInputSymbol("evo-point-1.y", (double*)&evoPoint1.y);
  
  // "evo-walk-angle"
  engine.registerDecimalInputSymbol("evo-walk-angle", (double*)&evoWalkAngle);

  // "evo-walk-duration"
  engine.registerDecimalInputSymbol("evo-walk-duration", (double*)&evoWalkDuration);
}

void MSH2004EvoSymbols::ReadConfigFile()
{
  InConfigFile evoConfigFile(getLocation().getFilename("evo_walk.cfg"));
  if (evoConfigFile.exists())
  { 
    evoConfigFile >> evoPoint0.x;
    evoConfigFile >> evoPoint0.y;
    evoConfigFile >> evoPoint1.x;
    evoConfigFile >> evoPoint1.y;
    evoConfigFile >> evoWalkAngle;
    evoConfigFile >> evoWalkDuration;
    if (evoWalkDuration == 0.0)
      evoWalkDuration = 0.1;
  }
  else
  {
    evoPoint0.x = 0.0;
    evoPoint0.y = 0.0;
    evoPoint1.x = 0.0;
    evoPoint1.y = 0.0;
    evoWalkAngle = 0.0;
    evoWalkDuration = 0.1;
  } 
}

/*
* Change Log
* 
* $Log: MSH2004EvoSymbols.cpp,v $
* Revision 1.3  2004/03/12 21:26:20  cesarz
* Evolution of walks in any walking direction is possible now.
*
* Revision 1.2  2004/03/08 01:07:13  roefer
* Interfaces should be const
*
* Revision 1.1  2004/02/26 18:07:28  cesarz
* first version of evolution behavior
*
*
*/

